/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.util.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.PortContext;

public final class PortContextCreator {
    private PortContextCreator() {
    }

    public static void createPortContexts(NodeContext nodeContext, boolean ignoreInsidePortLabels) {
        boolean imPortLabels = !ignoreInsidePortLabels || nodeContext.portLabelsPlacement != PortLabelPlacement.INSIDE;
        int volatileId = 0;
        for (GraphAdapters.PortAdapter<?> port : nodeContext.node.getPorts()) {
            if (port.getSide() == PortSide.UNDEFINED) {
                throw new IllegalArgumentException("Label and node size calculator can only be used with ports that have port sides assigned.");
            }
            port.setVolatileId(volatileId++);
            PortContextCreator.createPortContext(nodeContext, port, imPortLabels);
        }
    }

    private static void createPortContext(NodeContext nodeContext, GraphAdapters.PortAdapter<?> port, boolean imPortLabels) {
        PortContext portContext = new PortContext(nodeContext, port);
        nodeContext.portContexts.put((Object)port.getSide(), (Object)portContext);
        if (imPortLabels && nodeContext.portLabelsPlacement != PortLabelPlacement.FIXED) {
            portContext.portLabelCell = new LabelCell(nodeContext.labelLabelSpacing);
            port.getLabels().forEach(label -> portContext.portLabelCell.addLabel((GraphAdapters.LabelAdapter<?>)label));
        }
    }
}

