/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.core.comments.IAttachmentTargetProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;

public class SiblingAttachmentTargetProvider
implements IAttachmentTargetProvider {
    private boolean includeComments = false;

    public SiblingAttachmentTargetProvider includeComments() {
        this.includeComments = true;
        return this;
    }

    @Override
    public List<ElkGraphElement> provideAttachmentTargetsFor(ElkNode comment) {
        if (comment.getParent() == null) {
            return Collections.emptyList();
        }
        return comment.getParent().getChildren().stream().filter(sibling -> sibling != comment).filter(sibling -> this.includeComments || !this.isCommentNode((ElkGraphElement)sibling)).collect(Collectors.toList());
    }

    private boolean isCommentNode(ElkGraphElement graphElement) {
        return graphElement instanceof ElkNode && (Boolean)graphElement.getProperty(CoreOptions.COMMENT_BOX) != false;
    }
}

