/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BFSNodeOrderCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);
    private HashSet<LNode> sources;
    private HashSet<LNode> sinks;
    private boolean[] visited;
    private Queue<LNode> bfsQueue;
    private List<LEdge> edgesToBeReversed;
    private LGraph graph;

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Breadth-first cycle removal", 1.0f);
        this.graph = graph;
        List<LNode> nodes = graph.getLayerlessNodes();
        this.bfsQueue = new LinkedList<LNode>();
        this.sources = new HashSet();
        this.sinks = new HashSet();
        this.visited = new boolean[nodes.size()];
        this.edgesToBeReversed = new ArrayList<LEdge>();
        int index = 0;
        for (LNode node : nodes) {
            node.id = index;
            if (Iterables.isEmpty(node.getIncomingEdges())) {
                this.sources.add(node);
            }
            if (Iterables.isEmpty(node.getOutgoingEdges())) {
                this.sinks.add(node);
            }
            ++index;
        }
        for (LNode source : this.sources) {
            this.bfsQueue.add(source);
            this.bfsLoop();
        }
        this.bfsLoop();
        boolean changed = true;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < nodes.size()) {
                if (!this.visited[i]) {
                    LNode n = nodes.get(i);
                    assert (n.id == i);
                    this.bfsQueue.add(n);
                    changed = true;
                    break;
                }
                ++i;
            }
            this.bfsLoop();
        }
        for (LEdge edge : this.edgesToBeReversed) {
            edge.reverse(graph, true);
            graph.setProperty(InternalProperties.CYCLIC, true);
        }
        this.sources = null;
        this.visited = null;
        this.bfsQueue = null;
        this.edgesToBeReversed = null;
        monitor.done();
    }

    private void bfsLoop() {
        while (!this.bfsQueue.isEmpty()) {
            this.bfs(this.bfsQueue.poll());
        }
    }

    private void bfs(LNode n) {
        if (this.visited[n.id]) {
            return;
        }
        this.visited[n.id] = true;
        HashMap<Integer, HashSet<LEdge>> modelOrderMap = new HashMap<Integer, HashSet<LEdge>>();
        boolean groupModelOrder = this.graph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
        for (LEdge e : n.getOutgoingEdges()) {
            if (!e.getTarget().getNode().hasProperty(InternalProperties.MODEL_ORDER)) {
                modelOrderMap.put(Integer.MAX_VALUE - modelOrderMap.size(), new HashSet<LEdge>(Arrays.asList(e)));
                continue;
            }
            int targetModelOrder = 0;
            LNode target = e.getTarget().getNode();
            if (groupModelOrder) {
                int maxModelOrderGroupSize = (Integer)this.graph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES);
                targetModelOrder = maxModelOrderGroupSize * (Integer)target.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CYCLE_BREAKING_ID) + (Integer)target.getProperty(InternalProperties.MODEL_ORDER);
            } else {
                targetModelOrder = (Integer)e.getTarget().getNode().getProperty(InternalProperties.MODEL_ORDER);
            }
            if (modelOrderMap.containsKey(targetModelOrder)) {
                ((HashSet)modelOrderMap.get(targetModelOrder)).add(e);
                continue;
            }
            modelOrderMap.put(targetModelOrder, new HashSet<LEdge>(Arrays.asList(e)));
        }
        TreeSet modelOrderSet = new TreeSet(modelOrderMap.keySet());
        Iterator iterator = modelOrderSet.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            LEdge out = (LEdge)((Object)((HashSet)modelOrderMap.get(key)).iterator().next());
            if (out.isSelfLoop()) continue;
            LNode target = out.getTarget().getNode();
            if (this.visited[target.id] && !this.sources.contains((Object)n) && !this.sinks.contains((Object)target)) {
                this.edgesToBeReversed.addAll((Collection)modelOrderMap.get(key));
                continue;
            }
            this.bfsQueue.add(target);
        }
    }
}

