/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackIndexV1
implements PackIndex {
    private static final int IDX_HDR_LEN = 1024;
    private static final int RECORD_SIZE = 24;
    private final long[] idxHeader;
    protected byte[] packChecksum;
    byte[][] idxdata;
    private long objectCnt;

    PackIndexV1(InputStream fd, byte[] hdr) throws CorruptObjectException, IOException {
        byte[] fanoutTable = new byte[1024];
        System.arraycopy(hdr, 0, fanoutTable, 0, hdr.length);
        IO.readFully(fd, fanoutTable, hdr.length, 1024 - hdr.length);
        this.idxHeader = new long[256];
        int k = 0;
        while (k < this.idxHeader.length) {
            this.idxHeader[k] = NB.decodeUInt32(fanoutTable, k * 4);
            ++k;
        }
        this.idxdata = new byte[this.idxHeader.length][];
        k = 0;
        while (k < this.idxHeader.length) {
            long n = k == 0 ? this.idxHeader[k] : this.idxHeader[k] - this.idxHeader[k - 1];
            if (n > 0L) {
                long len = n * 24L;
                if (len > 0x7FFFFFF7L) {
                    throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
                }
                this.idxdata[k] = new byte[(int)len];
                IO.readFully(fd, this.idxdata[k], 0, this.idxdata[k].length);
            }
            ++k;
        }
        this.objectCnt = this.idxHeader[255];
        this.packChecksum = new byte[20];
        IO.readFully(fd, this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        long n64 = 0L;
        for (PackIndex.MutableEntry e : this) {
            if (e.getOffset() < Integer.MAX_VALUE) continue;
            ++n64;
        }
        return n64;
    }

    private int findLevelOne(long nthPosition) {
        int levelOne = Arrays.binarySearch(this.idxHeader, nthPosition + 1L);
        if (levelOne >= 0) {
            long base = this.idxHeader[levelOne];
            while (levelOne > 0 && base == this.idxHeader[levelOne - 1]) {
                --levelOne;
            }
        } else {
            levelOne = -(levelOne + 1);
        }
        return levelOne;
    }

    private int getLevelTwo(long nthPosition, int levelOne) {
        long base = levelOne > 0 ? this.idxHeader[levelOne - 1] : 0L;
        return (int)(nthPosition - base);
    }

    @Override
    public ObjectId getObjectId(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int p = this.getLevelTwo(nthPosition, levelOne);
        int dataIdx = PackIndexV1.idOffset(p);
        return ObjectId.fromRaw(this.idxdata[levelOne], dataIdx);
    }

    @Override
    public long getOffset(long nthPosition) {
        int levelOne = this.findLevelOne(nthPosition);
        int levelTwo = this.getLevelTwo(nthPosition, levelOne);
        int p = 24 * levelTwo;
        return NB.decodeUInt32(this.idxdata[levelOne], p);
    }

    @Override
    public long findOffset(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        byte[] data = this.idxdata[levelOne];
        int pos = this.levelTwoPosition(objId, data);
        if (pos < 0) {
            return -1L;
        }
        int b0 = data[pos - 4] & 0xFF;
        int b1 = data[pos - 3] & 0xFF;
        int b2 = data[pos - 2] & 0xFF;
        int b3 = data[pos - 1] & 0xFF;
        return (long)b0 << 24 | (long)(b1 << 16) | (long)(b2 << 8) | (long)b3;
    }

    @Override
    public int findPosition(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.levelTwoPosition(objId, this.idxdata[levelOne]);
        if (levelTwo < 0) {
            return -1;
        }
        long objsBefore = levelOne == 0 ? 0L : this.idxHeader[levelOne - 1];
        return (int)objsBefore + (levelTwo - 4) / 24;
    }

    private int levelTwoPosition(AnyObjectId objId, byte[] data) {
        if (data == null || data.length == 0) {
            return -1;
        }
        int high = data.length / 24;
        int low = 0;
        do {
            int mid;
            int pos;
            int cmp;
            if ((cmp = objId.compareTo(data, pos = PackIndexV1.idOffset(mid = low + high >>> 1))) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return pos;
            }
            low = mid + 1;
        } while (low < high);
        return -1;
    }

    @Override
    public long findCRC32(AnyObjectId objId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasCRC32Support() {
        return false;
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        return new EntriesIteratorV1(this);
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        int max;
        byte[] data = this.idxdata[id.getFirstByte()];
        if (data == null) {
            return;
        }
        int high = max = data.length / 24;
        int low = 0;
        do {
            int p;
            int cmp;
            if ((cmp = id.prefixCompare(data, PackIndexV1.idOffset(p = low + high >>> 1))) < 0) {
                high = p;
                continue;
            }
            if (cmp == 0) {
                while (p > 0 && id.prefixCompare(data, PackIndexV1.idOffset(p - 1)) == 0) {
                    --p;
                }
                while (p < max && id.prefixCompare(data, PackIndexV1.idOffset(p)) == 0) {
                    matches.add(ObjectId.fromRaw(data, PackIndexV1.idOffset(p)));
                    if (matches.size() > matchLimit) break;
                    ++p;
                }
                return;
            }
            low = p + 1;
        } while (low < high);
    }

    private static int idOffset(int mid) {
        return 24 * mid + 4;
    }

    @Override
    public byte[] getChecksum() {
        return this.packChecksum;
    }

    private static class EntriesIteratorV1
    extends PackIndex.EntriesIterator {
        private int levelOne;
        private int levelTwo;
        private final PackIndexV1 packIndex;

        private EntriesIteratorV1(PackIndexV1 packIndex) {
            super(packIndex.objectCnt);
            this.packIndex = packIndex;
        }

        @Override
        protected void readNext() {
            while (this.levelOne < this.packIndex.idxdata.length) {
                if (this.packIndex.idxdata[this.levelOne] != null) {
                    if (this.levelTwo < this.packIndex.idxdata[this.levelOne].length) {
                        super.setOffset(NB.decodeUInt32(this.packIndex.idxdata[this.levelOne], this.levelTwo));
                        this.levelTwo += 24;
                        super.setIdBuffer(this.packIndex.idxdata[this.levelOne], this.levelTwo - 20);
                        return;
                    }
                    this.levelTwo = 0;
                }
                ++this.levelOne;
            }
            throw new NoSuchElementException();
        }
    }
}

