/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.internal.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.loader.IJavaClassLoader;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectClassLoader
extends URLClassLoader
implements IJavaClassLoader {
    private IJavaProject _project;
    private List<IJavaProject> _dependencies;

    public JavaProjectClassLoader(IJavaProject project, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this._project = project;
        this._dependencies = new UniqueEList();
    }

    public JavaProjectClassLoader(IJavaProject project, List<IJavaProject> dependencies, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this._project = project;
        this._dependencies = dependencies != null ? dependencies : new UniqueEList();
    }

    @Override
    public IJavaProject getJavaProject() {
        return this._project;
    }

    @Override
    public IProject getProject() {
        return this._project.getProject();
    }

    @Override
    public IJavaProject[] getWorkspaceDependencies() throws CoreException {
        return this._dependencies.toArray(new IJavaProject[this._dependencies.size()]);
    }

    @Override
    public URL[] getURLs() {
        return super.getURLs();
    }

    @Override
    public URL findResource(String name) {
        if (name.length() > 1 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return super.findResource(name);
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.getParent();
    }

    @Override
    public synchronized Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        if (name != null && name.startsWith("java.")) {
            return Class.forName(name, true, this);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = name.lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        return super.findClass(name);
    }
}

