/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor.util.hovers;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.emf.codegen.jet.editor.codeassist.JETTemplateCompletionProcessor;
import org.eclipse.emf.codegen.jet.editor.presentation.JETTextEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;

public class JETTemplateScriptletHover
implements IJavaEditorTextHover {
    private IEditorPart jetEditor;

    public JETTemplateScriptletHover(JETTextEditor editor) {
        this.jetEditor = editor;
    }

    public void setEditor(IEditorPart editor) {
        this.jetEditor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ProposalThread pt = new ProposalThread(textViewer, hoverRegion);
        textViewer.getTextWidget().getDisplay().syncExec((Runnable)pt);
        if (pt.proposals != null && pt.proposals.length == 1) {
            ICompletionProposal p = pt.proposals[0];
            return this.createHoverInfo(p);
        }
        return null;
    }

    private String createHoverInfo(ICompletionProposal p) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)p.getDisplayString());
        if (p.getAdditionalProposalInfo() != null) {
            StringReader reader = new StringReader(p.getAdditionalProposalInfo());
            HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)new JavaDoc2HTMLTextReader((Reader)reader));
        }
        return buffer.toString();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    private class ProposalThread
    implements Runnable {
        protected ICompletionProposal[] proposals = null;
        private ITextViewer textViewer = null;
        private IRegion hoverRegion;

        public void run() {
            JETTemplateCompletionProcessor processor = new JETTemplateCompletionProcessor((JETTextEditor)JETTemplateScriptletHover.this.jetEditor);
            this.proposals = processor.computeCompletionProposals(this.textViewer, this.hoverRegion.getOffset());
        }

        public ProposalThread(ITextViewer textViewer, IRegion hoverRegion) {
            this.textViewer = textViewer;
            this.hoverRegion = hoverRegion;
        }
    }
}

