/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.JETURLClassLoader;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.ecore.EModelElement;

public class JETEditorGenerator
extends GenBaseImpl {
    protected Object currentGeneratedObject = null;
    protected ClassLoader classLoader = null;
    protected GenModel genModel = null;
    static /* synthetic */ Class class$0;

    public GenModel getGenModel() {
        if (this.genModel == null) {
            this.genModel = GenModelFactory.eINSTANCE.createGenModel();
        }
        return this.genModel;
    }

    public Object getCurrentGeneratedObject() {
        return this.currentGeneratedObject;
    }

    public void setCurrentGeneratedObject(Object newCurrentGeneratedObject) {
        this.currentGeneratedObject = newCurrentGeneratedObject;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader newClassLoader) {
        this.classLoader = newClassLoader;
    }

    protected Class loadEmitterClass(String className, ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            if (cl instanceof JETURLClassLoader) {
                ((JETURLClassLoader)cl).addNoDelegatesClass(className);
            }
            clazz = Class.forName(className, true, cl);
        }
        catch (Throwable throwable) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public void setMethod(JETEmitter jetEmitter, String className, ClassLoader cl) {
        try {
            Class emitterClass = this.loadEmitterClass(className, cl);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method emitterMethod = emitterClass.getDeclaredMethod("generate", classArray);
            jetEmitter.setMethod(emitterMethod);
        }
        catch (Exception exception) {
            JETEditorPlugin.getDefault().log(exception);
        }
    }

    public String generateText(Object generatedObject, String jetFilePath, IProgressMonitor progressMonitor) {
        try {
            JETCompiler jetCompiler = new JETCompiler(jetFilePath, "UTF-8");
            jetCompiler.parse();
            ClassLoader cl = this.getClassLoader();
            JETEmitter jetEmitter = new JETEmitter(jetFilePath, cl);
            this.setMethod(jetEmitter, String.valueOf(jetCompiler.getSkeleton().getPackageName()) + "." + jetCompiler.getSkeleton().getClassName(), cl);
            return this.getGeneratedTextString(progressMonitor, jetEmitter, generatedObject, false);
        }
        catch (JETException e) {
            JETEditorPlugin.getDefault().log((Object)e);
            return null;
        }
    }

    public String generateJava(Object generatedObject, String jetFilePath, IProgressMonitor progressMonitor) {
        try {
            JETCompiler jetCompiler = new JETCompiler(jetFilePath, "UTF-8");
            jetCompiler.parse();
            ClassLoader cl = this.getClassLoader();
            JETEmitter jetEmitter = new JETEmitter(jetFilePath, cl);
            this.setMethod(jetEmitter, String.valueOf(jetCompiler.getSkeleton().getPackageName()) + "." + jetCompiler.getSkeleton().getClassName(), cl);
            if (generatedObject instanceof GenBase) {
                this.genModel = ((GenBase)generatedObject).getGenModel();
            }
            ImportManager importManager = new ImportManager("");
            this.setImportManager(importManager);
            return this.getGeneratedJavaString(progressMonitor, jetEmitter, generatedObject, false);
        }
        catch (JETException e) {
            JETEditorPlugin.getDefault().log((Object)e);
            return null;
        }
    }

    protected String getGeneratedTextString(IProgressMonitor progressMonitor, JETEmitter jetEmitter, Object argument, boolean additionalGenModelArg) {
        String string;
        try {
            progressMonitor.beginTask("", 3);
            progressMonitor.subTask("Generating Output");
            ArrayList args = argument;
            if (additionalGenModelArg) {
                ArrayList list = new ArrayList();
                list.add(argument);
                list.add(this.getGenModel());
                args = list;
            }
            String emitterResult = jetEmitter.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), new Object[]{args});
            emitterResult = JETEditorGenerator.unicodeEscapeEncode((String)emitterResult);
            progressMonitor.worked(1);
            string = emitterResult;
            Object var7_9 = null;
        }
        catch (Exception exception) {
            try {
                JETEditorPlugin.getDefault().log(exception);
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                progressMonitor.done();
                throw throwable;
            }
            progressMonitor.done();
            return "";
        }
        progressMonitor.done();
        return string;
    }

    protected String getGeneratedJavaString(IProgressMonitor progressMonitor, JETEmitter jetEmitter, Object argument, boolean additionalGenModelArg) {
        String string;
        try {
            String newContents;
            progressMonitor.beginTask("", 3);
            progressMonitor.subTask("Generating Output");
            ArrayList args = argument;
            if (additionalGenModelArg) {
                ArrayList list = new ArrayList();
                list.add(argument);
                list.add(this.getGenModel());
                args = list;
            }
            String emitterResult = jetEmitter.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), new Object[]{args});
            emitterResult = JETEditorGenerator.unicodeEscapeEncode((String)emitterResult);
            JControlModel jControlModel = this.getGenModel().getJControlModel();
            if (jControlModel.getFacadeHelper() == null || !jControlModel.getFacadeHelper().getClass().getName().equals(this.getGenModel().getFacadeHelperClass())) {
                FacadeHelper facadeHelper = CodeGenUtil.instantiateFacadeHelper((String)this.getGenModel().getFacadeHelperClass());
                jControlModel.initialize(facadeHelper, this.getGenModel().getMergeRulesLocation());
            }
            string = newContents = CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)emitterResult);
            Object var9_11 = null;
        }
        catch (Exception exception) {
            try {
                JETEditorPlugin.getDefault().log(exception);
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                progressMonitor.done();
                throw throwable;
            }
            progressMonitor.done();
            return "";
        }
        progressMonitor.done();
        return string;
    }

    public String getName() {
        return "JETEditorGenerator";
    }

    public EModelElement getEcoreModelElement() {
        return null;
    }

    public boolean reconcile() {
        return false;
    }
}

