/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.internal.ui.wizard.page;

import java.util.Locale;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.pde.internal.ui.IHelpContextIds;
import org.eclipse.egf.pde.ui.wizard.Messages;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.ContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class FactoryComponentContentPage
extends ContentPage {
    private static final String S_GENERATE_ACTIVATOR = "generateActivator";
    private static final String S_UI_PLUGIN = "uiPlugin";
    private static final String S_TEMPLATE_BASED_FACTORY_COMPONENT = "templateBasedFactoryComponent";
    protected static final int P_CLASS_GROUP = 2;
    private static final String NO_EXECUTION_ENVIRONMENT = PDEUIMessages.PluginContentPage_noEE;
    private static final String S_API_ANALYSIS = "apiAnalysis";
    protected Text fClassText;
    protected Label fClassLabel;
    protected Button fGenerateClass;
    private Button fUIPlugin;
    private Label _label;
    private Button _yesButton;
    private Button _noButton;
    private Label fEELabel;
    private Combo fEEChoice;
    private Button fExeEnvButton;
    private Button fApiAnalysisButton;
    private Group _fcGroup;
    private ModifyListener _classListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (FactoryComponentContentPage.this.fInitialized) {
                FactoryComponentContentPage factoryComponentContentPage = FactoryComponentContentPage.this;
                factoryComponentContentPage.fChangedGroups = factoryComponentContentPage.fChangedGroups | 2;
            }
            FactoryComponentContentPage.this.validatePage();
        }
    };

    public FactoryComponentContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName, provider, page, data);
        this.setTitle(Messages.FactoryComponentContentPage_Title);
        this.setDescription(Messages.FactoryComponentContentPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createPluginClassGroup(container);
        this.createFactoryComponentGroup(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IHelpContextIds.NEW_FACTORY_COMPONENT_CONTENT_WIZARD_PAGE);
    }

    private void createPluginPropertiesGroup(Composite container) {
        Group propertiesGroup = SWTFactory.createGroup((Composite)container, (String)PDEUIMessages.ContentPage_pGroup, (int)3, (int)1, (int)768);
        Label label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pid);
        this.fIdText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        this.fIdText.setEditable(false);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pversion);
        this.fVersionText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pname);
        this.fNameText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        label = new Label((Composite)propertiesGroup, 0);
        label.setText(PDEUIMessages.ContentPage_pprovider);
        this.fProviderText = this.createText((Composite)propertiesGroup, this.propertiesListener, 2);
        this.createExecutionEnvironmentControls((Composite)propertiesGroup);
    }

    private void createExecutionEnvironmentControls(Composite container) {
        this.fEELabel = new Label(container, 0);
        this.fEELabel.setText(PDEUIMessages.NewProjectCreationPage_executionEnvironments_label);
        this.fEEChoice = new Combo(container, 2060);
        this.fEEChoice.setLayoutData((Object)new GridData(768));
        IExecutionEnvironment[] exeEnvs = VMUtil.getExecutionEnvironments();
        TreeSet<String> availableEEs = new TreeSet<String>();
        int i = 0;
        while (i < exeEnvs.length) {
            availableEEs.add(exeEnvs[i].getId());
            ++i;
        }
        availableEEs.add(NO_EXECUTION_ENVIRONMENT);
        this.fEEChoice.setItems(availableEEs.toArray(new String[availableEEs.size() - 1]));
        this.fEEChoice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FactoryComponentContentPage.this.validatePage();
            }
        });
        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
        String[] EEChoices = this.fEEChoice.getItems();
        int i2 = 0;
        while (i2 < EEChoices.length) {
            if (!EEChoices[i2].equals(NO_EXECUTION_ENVIRONMENT) && VMUtil.getExecutionEnvironment((String)EEChoices[i2]).isStrictlyCompatible(defaultVM)) {
                this.fEEChoice.select(i2);
                break;
            }
            ++i2;
        }
        this.fExeEnvButton = new Button(container, 8);
        this.fExeEnvButton.setLayoutData((Object)new GridData());
        this.fExeEnvButton.setText(PDEUIMessages.NewProjectCreationPage_environmentsButton);
        this.fExeEnvButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)FactoryComponentContentPage.this.getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
            }
        });
    }

    private void createPluginClassGroup(Composite container) {
        Group classGroup = SWTFactory.createGroup((Composite)container, (String)PDEUIMessages.ContentPage_pClassGroup, (int)2, (int)1, (int)768);
        IDialogSettings settings = this.getDialogSettings();
        this.fGenerateClass = SWTFactory.createCheckButton((Composite)classGroup, (String)PDEUIMessages.ContentPage_generate, null, (boolean)(settings != null ? !settings.getBoolean(S_GENERATE_ACTIVATOR) : true), (int)2);
        this.fGenerateClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FactoryComponentContentPage.this.fClassLabel.setEnabled(FactoryComponentContentPage.this.fGenerateClass.getSelection());
                FactoryComponentContentPage.this.fClassText.setEnabled(FactoryComponentContentPage.this.fGenerateClass.getSelection());
                FactoryComponentContentPage.this.updateData();
                FactoryComponentContentPage.this.validatePage();
            }
        });
        this.fClassLabel = new Label((Composite)classGroup, 0);
        this.fClassLabel.setText(PDEUIMessages.ContentPage_classname);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        this.fClassLabel.setLayoutData((Object)gd);
        this.fClassText = this.createText((Composite)classGroup, this._classListener);
        this.fUIPlugin = SWTFactory.createCheckButton((Composite)classGroup, (String)PDEUIMessages.ContentPage_uicontribution, null, (boolean)(settings != null ? !settings.getBoolean(S_UI_PLUGIN) : true), (int)2);
        this.fUIPlugin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FactoryComponentContentPage.this.updateData();
                FactoryComponentContentPage.this.validatePage();
            }
        });
        this.fApiAnalysisButton = SWTFactory.createCheckButton((Composite)classGroup, (String)PDEUIMessages.PluginContentPage_enable_api_analysis, null, (boolean)false, (int)2);
        this.fApiAnalysisButton.setSelection(settings != null ? settings.getBoolean(S_API_ANALYSIS) : false);
        this.fApiAnalysisButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FactoryComponentContentPage.this.updateData();
                FactoryComponentContentPage.this.validatePage();
            }
        });
    }

    public void updateData() {
        super.updateData();
        PluginFieldData data = (PluginFieldData)this.fData;
        data.setClassname(this.fClassText.getText().trim());
        data.setUIPlugin(this.fUIPlugin.getSelection());
        data.setDoGenerateClass(this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection());
        data.setRCPApplicationPlugin(!this.fData.isSimple() && !this.isPureOSGi() && this._yesButton.getSelection());
        data.setEnableAPITooling(this.fApiAnalysisButton.getSelection());
        if (this.fEEChoice.isEnabled() && !this.fEEChoice.getText().equals(NO_EXECUTION_ENVIRONMENT)) {
            this.fData.setExecutionEnvironment(this.fEEChoice.getText().trim());
        } else {
            this.fData.setExecutionEnvironment(null);
        }
    }

    private void createFactoryComponentGroup(Composite container) {
        this._fcGroup = new Group(container, 0);
        this._fcGroup.setLayout((Layout)new GridLayout(2, false));
        this._fcGroup.setLayoutData((Object)new GridData(768));
        this._fcGroup.setText(Messages.FactoryComponentContentPage_FactoryComponentGroup_Title);
        this.createFactoryComponentQuestion((Composite)this._fcGroup, 2);
    }

    private void createFactoryComponentQuestion(Composite parent, int horizontalSpan) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        comp.setLayoutData((Object)gd);
        this._label = new Label(comp, 0);
        this._label.setText(Messages.FactoryComponentContentPage_FactoryComponentModelQuestion_Title);
        this._label.setLayoutData((Object)new GridData(768));
        IDialogSettings settings = this.getDialogSettings();
        boolean templateBasedFc = settings != null ? settings.getBoolean(S_TEMPLATE_BASED_FACTORY_COMPONENT) : false;
        this._yesButton = new Button(comp, 16);
        this._yesButton.setText(PDEUIMessages.PluginContentPage_yes);
        this._yesButton.setSelection(templateBasedFc);
        gd = new GridData();
        gd.widthHint = FactoryComponentContentPage.getButtonWidthHint(this._yesButton);
        this._yesButton.setLayoutData((Object)gd);
        this._yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FactoryComponentContentPage.this.updateData();
                FactoryComponentContentPage.this.getContainer().updateButtons();
            }
        });
        this._noButton = new Button(comp, 16);
        this._noButton.setText(PDEUIMessages.PluginContentPage_no);
        this._noButton.setSelection(!templateBasedFc);
        gd = new GridData();
        gd.widthHint = FactoryComponentContentPage.getButtonWidthHint(this._noButton);
        this._noButton.setLayoutData((Object)gd);
    }

    public boolean canFlipToNextPage() {
        return this.isTemplateBasedFactoryComponentCreation();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.isTemplateBasedFactoryComponentCreation();
    }

    private boolean isTemplateBasedFactoryComponentCreation() {
        PluginFieldData data = (PluginFieldData)this.fData;
        return data.isRCPApplicationPlugin();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fMainPage.updateData();
            this.fGenerateClass.setEnabled(!this.fData.isSimple());
            this.fClassLabel.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            this.fClassText.setEnabled(!this.fData.isSimple() && this.fGenerateClass.getSelection());
            boolean wasUIPluginEnabled = this.fUIPlugin.isEnabled();
            this.fUIPlugin.setEnabled(!this.fData.isSimple() && !this.isPureOSGi());
            if (!this.fUIPlugin.isEnabled()) {
                this.fUIPlugin.setSelection(false);
            } else if (!wasUIPluginEnabled) {
                this.fUIPlugin.setSelection(true);
            }
            if ((this.fChangedGroups & 2) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fClassText.setText(String.valueOf(this.computeId().toLowerCase(Locale.ENGLISH)) + ".Activator");
                this.fChangedGroups = oldfChanged;
            }
            boolean allowEESelection = !this.fData.isSimple() && this.fData.hasBundleStructure();
            this.fEELabel.setEnabled(allowEESelection);
            this.fEEChoice.setEnabled(allowEESelection);
            this.fExeEnvButton.setEnabled(allowEESelection);
            this._fcGroup.setVisible(!this.fData.isSimple() && !this.isPureOSGi());
        }
        super.setVisible(visible);
    }

    private boolean isPureOSGi() {
        return ((PluginFieldData)this.fData).getOSGiFramework() != null;
    }

    protected void validatePage() {
        String errorMessage = this.validateProperties();
        if (errorMessage == null && this.fGenerateClass.isEnabled() && this.fGenerateClass.getSelection()) {
            IStatus status = JavaConventions.validateJavaTypeName((String)this.fClassText.getText().trim(), (String)PDEJavaHelper.getJavaSourceLevel(null), (String)PDEJavaHelper.getJavaComplianceLevel(null));
            if (status.getSeverity() == 4) {
                errorMessage = status.getMessage();
            } else if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        return Math.max(50, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

