/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.internal.ui.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IBaseModel;

public abstract class ModelModification {
    private IFile fModelFile;
    private IFile fManifestFile;
    private IFile fXMLFile;
    private IFile fPropertiesFile;
    private boolean fIsBundleModel;

    public ModelModification(IFile modelFile) {
        this.singleFileModification(modelFile);
    }

    public ModelModification(IFile bundleFile, IFile xmlFile) {
        this.createFullBundleModification(bundleFile, xmlFile);
    }

    public ModelModification(IProject project) {
        IFile manifest;
        IFile xml = project.getFile("plugin.xml");
        if (!xml.exists()) {
            xml = project.getFile("fragment.xml");
        }
        if (!xml.exists()) {
            xml = null;
        }
        if (!(manifest = project.getFile("META-INF/MANIFEST.MF")).exists() && xml != null) {
            this.singleFileModification(xml);
        } else if (manifest.exists()) {
            this.createFullBundleModification(manifest, xml);
        }
    }

    private void singleFileModification(IFile file) {
        if (file == null) {
            return;
        }
        this.assignFile(file);
        if (this.fManifestFile != null) {
            this.fModelFile = this.fManifestFile;
        } else if (this.fXMLFile != null) {
            this.fModelFile = this.fXMLFile;
        } else if (this.fPropertiesFile != null) {
            this.fModelFile = this.fPropertiesFile;
        }
        this.fIsBundleModel = file.getName().equals("MANIFEST.MF");
    }

    private void createFullBundleModification(IFile bundleFile, IFile xmlFile) {
        this.assignFile(bundleFile);
        this.assignFile(xmlFile);
        Assert.isNotNull((Object)this.fManifestFile);
        this.fModelFile = this.fManifestFile;
        this.fIsBundleModel = true;
    }

    private void assignFile(IFile file) {
        if (file == null) {
            return;
        }
        String name = file.getName();
        if (name.equals("MANIFEST.MF")) {
            this.fManifestFile = file;
        } else if (name.equals("plugin.xml") || name.equals("fragment.xml")) {
            this.fXMLFile = file;
        } else if (name.endsWith(".properties")) {
            this.fPropertiesFile = file;
        }
    }

    protected abstract void modifyModel(IBaseModel var1, IProgressMonitor var2) throws CoreException;

    protected final IFile getFile() {
        return this.fModelFile;
    }

    protected final IFile getManifestFile() {
        return this.fManifestFile;
    }

    protected final IFile getXMLFile() {
        return this.fXMLFile;
    }

    protected final IFile getPropertiesFile() {
        return this.fPropertiesFile;
    }

    protected final boolean isFullBundleModification() {
        return this.fIsBundleModel;
    }

    public boolean saveOpenEditor() {
        return true;
    }
}

