/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.wizard.page;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWizardPage
extends WizardPage {
    private boolean _computeCompleteStatus;
    private boolean _completeStatus;

    public AbstractWizardPage(String pageName_p) {
        super(pageName_p);
        this.initialize();
    }

    public AbstractWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
        this.initialize();
    }

    protected void initialize() {
        this._computeCompleteStatus = true;
    }

    public void createControl(Composite parent_p) {
        this.setTitle(this.getPageTitle());
        this.setDescription(this.getPageDescription());
        Composite content = this.createComposite(parent_p, this.getContentNumColumn());
        this.initializeDialogUnits((Control)content);
        this.createPageArea(content);
        this.updateButtons();
        Point size = content.computeSize(-1, -1);
        GridData gridData = (GridData)parent_p.getLayoutData();
        gridData.heightHint = Math.max(size.y + 10, gridData.heightHint);
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)content, helpContextId);
        }
    }

    protected abstract boolean isReadOnly();

    public final void updateButtons() {
        this._computeCompleteStatus = true;
        this.setPageComplete(this.computeCompleteStatus());
    }

    public boolean isPageComplete() {
        return this.computeCompleteStatus();
    }

    protected abstract boolean getCompleteStatus();

    protected abstract void createPageArea(Composite var1);

    protected void handlePageLayout(Composite parent_p) {
    }

    protected int getContentNumColumn() {
        return 2;
    }

    protected abstract String getPageTitle();

    protected abstract String getPageDescription();

    protected String getHelpContextId() {
        return null;
    }

    private boolean computeCompleteStatus() {
        if (this._computeCompleteStatus) {
            this._completeStatus = this.getCompleteStatus();
            this._computeCompleteStatus = false;
        }
        return this._completeStatus;
    }

    private Composite createComposite(Composite parent_p, int numColumns_p) {
        Composite composite = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns_p;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        return composite;
    }

    public void performHelp() {
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextId);
        }
    }
}

