/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.helper;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.ui.helper.Messages;
import org.eclipse.egf.common.ui.internal.resource.ExtendedUnmodifiableFile;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class WorkbenchHelper {
    private static final Logger __logger = Logger.getLogger((String)WorkbenchHelper.class.getPackage().getName());

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static IEditorPart openFileEditor(String fileRelativePath_p, String editorId_p, boolean editable_p) {
        if (fileRelativePath_p == null || editorId_p == null) {
            return null;
        }
        Object file = null;
        Path filePath = new Path(fileRelativePath_p);
        file = editable_p ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath) : new ExtendedUnmodifiableFile((IPath)filePath);
        return WorkbenchHelper.openEditor((IEditorInput)new FileEditorInput(file), editorId_p, PlatformUI.getWorkbench().getDisplay().getActiveShell());
    }

    public static IEditorPart openEditor(IEditorInput editorInput_p, String editorId_p, Shell shell_p) {
        IEditorPart openEditor = null;
        if (editorInput_p == null || editorId_p == null) {
            return openEditor;
        }
        try {
            IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
            if (activeWorkbenchPage == null) {
                throw new PartInitException("No active workbench page was found to open an editor");
            }
            openEditor = activeWorkbenchPage.openEditor(editorInput_p, editorId_p);
        }
        catch (PartInitException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("WorkbenchHelper.openEditor(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            MessageDialog.openError((Shell)shell_p, (String)Messages.OpenEditor_ErrorMessage, (String)exception_p.getMessage());
        }
        return openEditor;
    }

    public static IEditorPart openDefaultFileEditor(String fileRelativePath_p, Shell shell_p) {
        if (fileRelativePath_p == null) {
            return null;
        }
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = editorRegistry.getDefaultEditor(fileRelativePath_p);
        if (defaultEditor != null) {
            return WorkbenchHelper.openFileEditor(fileRelativePath_p, defaultEditor.getId(), true);
        }
        return null;
    }

    public static void saveEditor(IEditorPart editor_p) {
        if (editor_p.isDirty()) {
            editor_p.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static boolean closeFileEditors(String fileRelativePath_p) {
        boolean result = false;
        if (fileRelativePath_p == null) {
            return result;
        }
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        IFile fileToClose = null;
        try {
            fileToClose = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileRelativePath_p));
        }
        catch (Exception e_p) {
            StringBuilder loggerMessage = new StringBuilder("WorkbenchHelper.closeFileEditor(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)e_p);
        }
        if (activeWorkbenchPage == null || fileToClose == null) {
            return result;
        }
        result = true;
        IEditorReference[] editorReferences = activeWorkbenchPage.getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IFile file;
            IEditorPart editorPart = editorReferences[i].getEditor(false);
            IEditorInput editorInput = editorPart.getEditorInput();
            if (editorInput != null && fileToClose.equals((Object)(file = (IFile)editorInput.getAdapter(IFile.class)))) {
                result &= WorkbenchHelper.closeEditor(editorPart, true);
            }
            ++i;
        }
        return result;
    }

    public static boolean closeEditor(IEditorPart editor_p, boolean save_p) {
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        if (activeWorkbenchPage != null) {
            return activeWorkbenchPage.closeEditor(editor_p, save_p);
        }
        return false;
    }

    public static void closeView(String viewId_p) {
        if (viewId_p == null) {
            return;
        }
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        IViewPart viewPart = activeWorkbenchPage.findView(viewId_p);
        if (viewPart != null) {
            activeWorkbenchPage.hideView(viewPart);
        }
    }

    public static void openView(String viewId_p) {
        if (viewId_p == null) {
            return;
        }
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        try {
            activeWorkbenchPage.showView(viewId_p);
        }
        catch (PartInitException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("WorkbenchHelper.openView(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
    }

    public static boolean isViewOpen(String viewId_p) {
        if (viewId_p == null) {
            return false;
        }
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        if (activeWorkbenchPage != null) {
            return activeWorkbenchPage.findView(viewId_p) != null;
        }
        return false;
    }

    public static void addPartListener(IPartListener listener_p) {
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        if (activeWorkbenchPage != null) {
            activeWorkbenchPage.addPartListener(listener_p);
        }
    }

    public static IEditorReference[] getAllOpenEditors(String editorId_p) {
        IEditorReference[] allEditorReferences;
        ArrayList<IEditorReference> openEditors = new ArrayList<IEditorReference>(0);
        IWorkbenchPage activePage = WorkbenchHelper.getActiveWorkbenchPage();
        IEditorReference[] iEditorReferenceArray = allEditorReferences = activePage.getEditorReferences();
        int n = allEditorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            if (editorId_p.equals(editorReference.getId())) {
                openEditors.add(editorReference);
            }
            ++n2;
        }
        return openEditors.toArray(new IEditorReference[openEditors.size()]);
    }

    public static PackageExplorerPart getPackageExplorerView() {
        IWorkbenchPage activeWorkbenchPage = WorkbenchHelper.getActiveWorkbenchPage();
        if (activeWorkbenchPage != null) {
            return (PackageExplorerPart)activeWorkbenchPage.findView("org.eclipse.jdt.ui.PackageExplorer");
        }
        return null;
    }
}

