/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.common.ui.toolkit.viewers.AbstractTransferViewer;
import org.eclipse.egf.common.ui.toolkit.viewers.TransferTreeViewer;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.ui.internal.data.UiReferencedFactoryComponentContainer;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.internal.observable.IListViewerObserver;
import org.eclipse.egf.core.ui.internal.viewers.CustomTooltipLabelProvider;
import org.eclipse.egf.core.ui.internal.viewers.DecoratedModelLabelProvider;
import org.eclipse.egf.core.ui.internal.viewers.ObservableReferencedContractElementContentProvider;
import org.eclipse.egf.core.ui.internal.viewers.PossibleContractElementReferenceTreeContentProvider;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContractElementReferenceWizardPage
extends AbstractModelElementWizardPage {
    private final int TRANSFER_BUTTONS = 24;
    private final int TRANSFER_TREE_STYLE = 88;
    protected AbstractTransferViewer _treeTransferViewer;
    private ILabelProvider _decoratedLabelProvider;

    public ContractElementReferenceWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContractElementReferenceWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected String getPageTitle() {
        return Messages.ContractElementWizardPage_Title;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    protected void createPageArea(Composite parent_p) {
        this._decoratedLabelProvider = new CustomTooltipLabelProvider(new DecoratedModelLabelProvider());
        this.createTransferViewer(parent_p);
    }

    private void createTransferViewer(Composite parent_p) {
        this._treeTransferViewer = new TransferTreeViewer(parent_p, 88);
        SelectionChangedHandler handler = new SelectionChangedHandler(){

            protected boolean doHandleSelection(ISelection selection_p) {
                boolean result = true;
                if (selection_p instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)selection_p;
                    Iterator selectedObjects = selection.iterator();
                    while (selectedObjects.hasNext() && result) {
                        Object selectedObject = selectedObjects.next();
                        if (selectedObject instanceof ContractElement) continue;
                        result = false;
                    }
                } else {
                    result = false;
                }
                return result;
            }
        };
        this._treeTransferViewer.setSelectionChangedHandler(handler, 24);
        AbstractTreeViewer rightViewer = (AbstractTreeViewer)this._treeTransferViewer.getRightViewer();
        rightViewer.setAutoExpandLevel(-1);
        ViewerSorter defaultViewerSorter = new ViewerSorter();
        rightViewer.setSorter(defaultViewerSorter);
        this._treeTransferViewer.getLeftViewer().setSorter(defaultViewerSorter);
        Collection<ContractElement> referencedContractElements = this.handleRightViewerInitialization();
        this.handleSiblingContractElements(referencedContractElements);
        this.handleSiblingContext(referencedContractElements);
        this.handleLeftViewerInitialization(referencedContractElements);
        parent_p.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Composite control = (Composite)ContractElementReferenceWizardPage.this._treeTransferViewer.getControl();
                control.layout();
            }
        });
    }

    private void handleSiblingContext(Collection<ContractElement> referencedContractElements_p) {
        FactoryComponent fc = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)this.getParent());
        ProductionPlan productionPlan = ModelHelper.getProductionPlan((FactoryComponent)fc);
        Context context = productionPlan.getContext();
        referencedContractElements_p.addAll(DataHelper.getReferencedContractElementsFor((Context)context));
        EList fcInvocations = productionPlan.getFactoryComponentInvocations();
        for (FactoryComponentInvocation fcInvocation : fcInvocations) {
            context = fcInvocation.getContext();
            referencedContractElements_p.addAll(DataHelper.getReferencedContractElementsFor((Context)context));
        }
    }

    private void handleSiblingContractElements(Collection<ContractElement> referencedContractElements_p) {
        Contract contract = (Contract)this.getParent();
        referencedContractElements_p.addAll(DataHelper.getReferencedContractElementsFor((Contract)contract));
    }

    protected IContentProvider handleLeftViewerInitialization(Collection<ContractElement> referencedContractElementList_p) {
        this._treeTransferViewer.setLeftLabelProvider(this._decoratedLabelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)this._treeTransferViewer.getLeftViewer()));
        PossibleContractElementReferenceTreeContentProvider possibleContractElementReferenceTreeContentProvider = new PossibleContractElementReferenceTreeContentProvider(referencedContractElementList_p);
        this._treeTransferViewer.setLeftContentProvider((IContentProvider)possibleContractElementReferenceTreeContentProvider);
        this._treeTransferViewer.setLeftInput((Object)this.getParent());
        return possibleContractElementReferenceTreeContentProvider;
    }

    protected Collection<ContractElement> handleRightViewerInitialization() {
        this._treeTransferViewer.setRightLabelProvider(this._decoratedLabelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)((TreeViewer)this._treeTransferViewer.getRightViewer()));
        ObservableReferencedContractElementContentProvider observableContentProvider = new ObservableReferencedContractElementContentProvider();
        this._treeTransferViewer.setRightContentProvider((IContentProvider)observableContentProvider);
        Collection referencedContractElements = DataHelper.getReferencedContractElementsFor((ContractElement)this.getContractElement());
        UiReferencedFactoryComponentContainer initialInput = new UiReferencedFactoryComponentContainer(referencedContractElements.toArray(new ContractElement[referencedContractElements.size()]));
        this._treeTransferViewer.setRightInput((Object)initialInput);
        ContractElementListObserver contractElementListObserver = new ContractElementListObserver();
        observableContentProvider.addListViewerObserver(contractElementListObserver);
        return referencedContractElements;
    }

    protected boolean getCompleteStatus() {
        String errorMessage = null;
        boolean result = this.hasAtLeastOneContractReference();
        if (!result) {
            errorMessage = Messages.ContractElementTypeWizardPage_ErrorMessage_1;
        } else {
            result = this.checkEveryReferencedContractElementHasSameType();
            if (!result) {
                errorMessage = Messages.ContractElementTypeWizardPage_ErrorMessage_2;
            }
        }
        this.setErrorMessage(errorMessage);
        return result;
    }

    private boolean checkEveryReferencedContractElementHasSameType() {
        boolean result = true;
        String typeHolderName = null;
        ContractElement contractElement = this.getContractElement();
        Iterator iterator = contractElement.getContractElementReferences().iterator();
        while (iterator.hasNext() && result) {
            ContractElementReference contractElementReference = (ContractElementReference)iterator.next();
            String currentTypeHolderClassName = contractElementReference.getReferencedContractElement().getContractType().getTypeHolderClassName();
            if (typeHolderName == null) {
                typeHolderName = currentTypeHolderClassName;
                continue;
            }
            result = typeHolderName.equals(currentTypeHolderClassName);
        }
        if (result) {
            ModelHelper.setContractType((ContractElement)contractElement, typeHolderName);
        }
        return result;
    }

    private boolean hasAtLeastOneContractReference() {
        return !this.getContractElement().getContractElementReferences().isEmpty();
    }

    protected ContractElement getContractElement() {
        return (ContractElement)this.getModelElement();
    }

    public void dispose() {
        super.dispose();
        this._treeTransferViewer.dispose();
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTRACT_ELEMENT_REFERENCE_WIZARD_PAGE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContractElementListObserver
    implements IListViewerObserver {
        ContractElementListObserver() {
        }

        @Override
        public void elementAdded(List<Object> elements_p) {
            EList contractElementReferences = ContractElementReferenceWizardPage.this.getContractElement().getContractElementReferences();
            for (Object element : elements_p) {
                ContractElement referencedContractElement = (ContractElement)element;
                ContractElementReference contractElementReference = ModelHelper.createContractElementReferenceBasedOn((ContractElement)referencedContractElement);
                contractElementReferences.add((Object)contractElementReference);
            }
            ContractElementReferenceWizardPage.this.updateButtons();
        }

        @Override
        public void elementRemoved(List<Object> elements_p) {
            EList contractElementReferences = ContractElementReferenceWizardPage.this.getContractElement().getContractElementReferences();
            for (Object element : elements_p) {
                ContractElement referencedContractElement = (ContractElement)element;
                Iterator iterator = contractElementReferences.iterator();
                while (iterator.hasNext()) {
                    ContractElementReference contractElementReference = (ContractElementReference)iterator.next();
                    DataHelper.resolveContractElement((ContractElementReference)contractElementReference);
                    if (referencedContractElement != contractElementReference.getReferencedContractElement()) continue;
                    iterator.remove();
                }
            }
            ContractElementReferenceWizardPage.this.updateButtons();
        }

        @Override
        public void elementUpdated(List<Object> elements_p) {
            ContractElementReferenceWizardPage.this.updateButtons();
        }
    }
}

