/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer;

import java.util.List;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.core.ui.workbench.action.edit.EditContextElementAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditContractElementAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditDomainAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditFactoryComponentAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditFactoryComponentInvocationAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditMappingAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditPatternLibraryAction;
import org.eclipse.egf.core.ui.workbench.action.edit.EditTaskFactoryHolderAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.CleanPatternAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.CleanPatternLibraryAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.ProducePatternElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateContextAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateContextElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateContractElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateDomainAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateFactoryComponentInvocationAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateMappingAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreatePatternAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreatePatternLibraryAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateRootPatternLibraryAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.create.CreateTaskFactoryHolderAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteContextAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteContextElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteContractElementAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteDomainAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteFactoryComponentInvocationAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteMappingAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeletePatternAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeletePatternLibraryAction;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteTaskFactoryHolderAction;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractActionProvider;
import org.eclipse.egf.core.ui.workbench.action.navigator.ValidateElementAction;
import org.eclipse.egf.core.ui.workbench.action.open.OpenDomainAction;
import org.eclipse.egf.core.ui.workbench.action.open.OpenMappingAction;
import org.eclipse.egf.core.ui.workbench.action.open.OpenPatternAction;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class ExplorerActionProvider
extends AbstractActionProvider {
    private static final String GROUP_UNDO_REDO = "group.undoredo";
    private UndoAction _undoAction;
    private RedoAction _redoAction;

    protected void initActions(Shell shell_p, IWorkbenchPage page_p, ISelectionProvider selectionProvider_p) {
        this.initUndoRedoActions();
        this.initCreationActions(shell_p, selectionProvider_p);
        this.initEditActions(shell_p, selectionProvider_p);
        this.initOpenActions(shell_p, selectionProvider_p);
        this.initDeleteActions(shell_p, selectionProvider_p);
        this.initAdditionActions(shell_p, selectionProvider_p);
    }

    private void initUndoRedoActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        AdapterFactoryEditingDomain editingDomain = EgfUiActivator.getDefault().getEditingDomain();
        this._undoAction = new UndoAction((EditingDomain)editingDomain);
        this._undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this._undoAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO_DISABLED"));
        this._redoAction = new RedoAction((EditingDomain)editingDomain);
        this._redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this._redoAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
    }

    private void initOpenActions(Shell shell_p, ISelectionProvider selectionProvider_p) {
        List<IAction> openActions = this.getOpenActions();
        openActions.add((IAction)new OpenDomainAction(shell_p, selectionProvider_p, false));
        openActions.add((IAction)new OpenPatternAction(shell_p, selectionProvider_p, false));
        openActions.add((IAction)new OpenMappingAction(shell_p, selectionProvider_p, false));
        openActions.add((IAction)new ProducePatternElementAction(shell_p, selectionProvider_p, false));
    }

    private void initDeleteActions(Shell shell_p, ISelectionProvider selectionProvider_p) {
        List<IAction> deleteActions = this.getDeleteActions();
        deleteActions.add((IAction)new DeleteDomainAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteFactoryComponentInvocationAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteTaskFactoryHolderAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteContractElementAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteContextAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteContextElementAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeletePatternLibraryAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeletePatternAction(shell_p, selectionProvider_p, false));
        deleteActions.add((IAction)new DeleteMappingAction(shell_p, selectionProvider_p, false));
    }

    private void initEditActions(Shell shell_p, ISelectionProvider selectionProvider_p) {
        List<IAction> editActions = this.getEditActions();
        editActions.add((IAction)new EditFactoryComponentAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditDomainAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditFactoryComponentInvocationAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditTaskFactoryHolderAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditContractElementAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditContextElementAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditPatternLibraryAction(shell_p, selectionProvider_p, false));
        editActions.add((IAction)new EditMappingAction(shell_p, selectionProvider_p, false));
    }

    private void initAdditionActions(Shell shell_p, ISelectionProvider selectionProvider_p) {
        List<IAction> additionActions = this.getAdditionActions();
        additionActions.add((IAction)new CleanPatternLibraryAction(shell_p, selectionProvider_p, false));
        additionActions.add((IAction)new CleanPatternAction(shell_p, selectionProvider_p, false));
        additionActions.add((IAction)new ValidateElementAction(shell_p, selectionProvider_p, false));
    }

    private void initCreationActions(Shell shell_p, ISelectionProvider selectionProvider_p) {
        List<IAction> newActions = this.getNewActions();
        newActions.add((IAction)new CreateDomainAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateFactoryComponentInvocationAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateTaskFactoryHolderAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateContractElementAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateContextAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateContextElementAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateRootPatternLibraryAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreatePatternLibraryAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreatePatternAction(shell_p, selectionProvider_p, false));
        newActions.add((IAction)new CreateMappingAction(shell_p, selectionProvider_p, false));
    }

    public void fillContextMenu(IMenuManager menu_p) {
        super.fillContextMenu(menu_p);
        menu_p.appendToGroup(GROUP_UNDO_REDO, (IAction)this._undoAction);
        menu_p.appendToGroup(GROUP_UNDO_REDO, (IAction)this._redoAction);
    }

    public void fillActionBars(IActionBars actionBars_p) {
        super.fillActionBars(actionBars_p);
        actionBars_p.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this._undoAction);
        actionBars_p.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this._redoAction);
    }

    public void updateActionBars() {
        this._undoAction.update();
        this._redoAction.update();
    }
}

