/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.progress.IProgressRunnable;
import org.eclipse.egf.common.progress.ProgressReporter;
import org.eclipse.egf.core.ui.actions.AbstractUiHandler;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertPlugin2FactoryComponentHandler
extends AbstractUiHandler {
    public Object execute(ExecutionEvent executionEvent_p) throws ExecutionException {
        Object result = null;
        List selection = this.getSelection(executionEvent_p, IJavaProject.class);
        if (selection.isEmpty()) {
            return result;
        }
        for (IJavaProject selectedJavaProject : selection) {
            IProject project = selectedJavaProject.getProject();
            final String projectName = project.getName();
            IPluginModelBase pluginModelBase = EgfPdeActivator.getDefault().getPluginModelBase(project);
            String dialogTitle = MessageFormat.format(Messages.ConvertPlugin2FactoryComponent_Title, projectName);
            boolean convertToFC = true;
            if (pluginModelBase == null) {
                convertToFC = EgfPdeActivator.getDefault().convertToPlugin(projectName);
            } else {
                String pluginId = pluginModelBase.getPluginBase().getId();
                if (!projectName.equals(pluginId)) {
                    String dialogMessage = MessageFormat.format(Messages.ConvertPlugin2FactoryComponent_ErrorDialog_Message, projectName, pluginId);
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)dialogMessage);
                    convertToFC = false;
                }
            }
            if (!convertToFC) continue;
            IProgressRunnable convertToFcRunnable = new IProgressRunnable(){

                public String getReportingTitle() {
                    return MessageFormat.format(Messages.ConvertPlugin2FactoryComponent_Title, projectName);
                }

                public boolean run(IProgressMonitor progressMonitor_p) {
                    EgfPdeActivator.getDefault().convertToFactoryComponent(projectName);
                    return true;
                }
            };
            ProgressReporter.asyncExec((IProgressRunnable)convertToFcRunnable);
        }
        return result;
    }

    public boolean isEnabled() {
        boolean result = true;
        ISelection selection = this.getSelection();
        if (selection != null) {
            List<IProject> projects = this.getProjects(selection);
            if (!projects.isEmpty()) {
                Iterator<IProject> iter = projects.iterator();
                while (iter.hasNext() && result) {
                    result &= this.canConvert(iter.next());
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private boolean canConvert(IProject project_p) {
        return EgfPdeActivator.getDefault().getFactoryComponent(project_p) == null;
    }

    private ISelection getSelection() {
        ISelection currentSelection = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            currentSelection = activeWorkbenchWindow.getSelectionService().getSelection();
        }
        return currentSelection;
    }

    private List<IProject> getProjects(ISelection selection_p) {
        ArrayList<IProject> projects = new ArrayList<IProject>(0);
        if (selection_p == null) {
            return projects;
        }
        IStructuredSelection selection = (IStructuredSelection)selection_p;
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof IJavaProject)) continue;
            projects.add(((IJavaProject)selectedElement).getProject());
        }
        return projects;
    }
}

