/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.AbstractPatternCodeWizardPage;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.Messages;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.PatternCodeActionWizard;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class PatternCodeActionTypeSelectionPage
extends AbstractPatternCodeWizardPage {
    protected static final String PAGE_ID = "actionType";
    private static final Map<String, String> CODE_TO_MESSAGE = new HashMap<String, String>();

    static {
        CODE_TO_MESSAGE.put("CALL", Messages.PatternCodeActionTypeSelectionPage_Call_Label);
        CODE_TO_MESSAGE.put("PATTERN", Messages.PatternCodeActionTypeSelectionPage_Pattern_Label);
        CODE_TO_MESSAGE.put("SUPER", Messages.PatternCodeActionTypeSelectionPage_SuperCall_Label);
    }

    public PatternCodeActionTypeSelectionPage() {
        super(PAGE_ID);
    }

    public IWizardPage getNextPage() {
        String actionType = this.getWizard().getActionType();
        return this.getWizard().getPage(PatternCodeActionTypeSelectionPage.getParameterPageId(actionType));
    }

    public boolean canFlipToNextPage() {
        String actionType = this.getWizard().getActionType();
        return this.isPageComplete() && PatternCodeActionTypeSelectionPage.getParameterPageId(actionType) != null;
    }

    protected static String getParameterPageId(String actionType_p) {
        String pageId = null;
        if ("PATTERN".equals(actionType_p)) {
            pageId = "actionPatternIdParameter";
        } else if ("CALL".equals(actionType_p)) {
            pageId = "actionMethodNameParameter";
        } else if ("SUPER".equals(actionType_p)) {
            pageId = "actionSuperMethodNameParameter";
        }
        return pageId;
    }

    protected String getPageDescription() {
        return Messages.PatternCodeActionTypeSelectionPage_Description;
    }

    protected String getPageTitle() {
        return Messages.PatternCodeActionTypeSelectionPage_Title;
    }

    public PatternCodeActionWizard getWizard() {
        return (PatternCodeActionWizard)super.getWizard();
    }

    protected StructuredViewer createViewer(Composite parent_p) {
        ListViewer result = new ListViewer(parent_p, 2820);
        result.setContentProvider((IContentProvider)new AbstractPatternPageContentProvider(){

            protected void doDispose() {
            }

            protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
            }

            protected void doHandleElementsAdded(Object addedElements_p) {
            }

            protected void doHandleElementsRemoved(Object removedElements_p) {
            }

            public Object[] getElements(Object inputElement_p) {
                return PatternCodeActionTypeSelectionPage.this.getWizard().getAvailableActions().toArray();
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element_p) {
                return PatternCodeActionTypeSelectionPage.getActionTypeDisplayableText(element_p);
            }
        });
        result.setInput(this.getWizard().getAvailableActions());
        return result;
    }

    protected boolean delegateSelectionChanged(Object selectedElement_p) {
        String selectedActionType = (String)selectedElement_p;
        this.getWizard().setActionType(selectedActionType);
        return selectedActionType != null;
    }

    public static String getActionTypeDisplayableText(Object actionType_p) {
        return CODE_TO_MESSAGE.get(actionType_p);
    }
}

