/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation;

import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.internal.editor.DefaultPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.viewers.IContentProvider;

public class InternalMethodHandler
extends DefaultContentHandler {
    private EOperation _method;
    private String _previousName;
    private boolean _isModifiable;
    private boolean _overrides;
    private IContentProvider _provider;

    public InternalMethodHandler(AbstractPatternPage page_p, EOperation method_p, PatternHandler.PatternData patternData_p, IContentProvider provider_p) {
        super(patternData_p, page_p);
        this.setMethodAndcomputeExtraData(method_p);
        this._provider = provider_p;
    }

    public InternalMethodHandler(EOperation method_p, PatternHandler.PatternData patternData_p) {
        super(patternData_p, null);
        this.setMethodAndcomputeExtraData(method_p);
    }

    protected void setMethodAndcomputeExtraData(EOperation method_p) {
        Assert.isNotNull((Object)method_p);
        this._method = method_p;
        String methodName = method_p.getName();
        this._isModifiable = !"generateHeader".equals(methodName) && !"generateFooter".equals(methodName);
        this._overrides = this.computeOverriding(this.getPatternData().getParentPattern());
    }

    protected boolean computeOverriding(Pattern parentPattern_p) {
        boolean result = false;
        if (parentPattern_p == null) {
            return result;
        }
        EList operations = parentPattern_p.getEOperations();
        for (EOperation operation : operations) {
            result = this.getMethodName().equals(operation.getName());
            if (result) break;
        }
        if (!result) {
            EList superTypes = parentPattern_p.getESuperTypes();
            for (EClass superType : superTypes) {
                boolean bl = result = superType instanceof Pattern && this.computeOverriding((Pattern)superType);
                if (result) break;
            }
        }
        return result;
    }

    public boolean isOverriding() {
        return this._overrides;
    }

    public EOperation getMethod() {
        return this._method;
    }

    public void setMethodName(String newName_p) {
        String oldName;
        if (!this.isModifiable()) {
            return;
        }
        if (newName_p != null && !"".equals(newName_p.trim()) && !newName_p.equals(oldName = this.getMethodName())) {
            if (this._previousName == null) {
                this._previousName = this._method.getName();
            }
            this._method.setName(newName_p);
            this._overrides = this.computeOverriding(this.getPatternData().getParentPattern());
            if (this._provider != null) {
                this._provider.inputChanged(null, (Object)this, (Object)this);
            }
            this.notifyModification();
            this.notifyNameChanged(oldName, newName_p);
        }
    }

    protected void notifyNameChanged(String oldName_p, String newName_p) {
        DefaultPatternModificationNotification notification = DefaultPatternModificationNotification.createNotification(3, this.getMethod(), oldName_p, newName_p);
        this.getPage().getEditor().sendNotification(notification);
    }

    public String getMethodName() {
        return this._method.getName();
    }

    public boolean isModifiable() {
        return this._isModifiable;
    }

    public boolean isHandlerFor(EOperation method_p) {
        return this.getMethod().equals(method_p);
    }

    public boolean equals(Object obj_p) {
        return obj_p instanceof InternalMethodHandler && ((InternalMethodHandler)obj_p).isHandlerFor(this.getMethod());
    }

    public int hashCode() {
        return this.getMethod().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getMethodName()) + '(' + ')';
    }
}

