/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.utils;

import java.util.List;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.dashboard.ui.utils.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SelectionDialog
extends FormDialog {
    private final List<GerritServerInformation> fListGerritServerInformation;
    private GerritServerInformation fSelection = null;

    public SelectionDialog(Shell parent, List<GerritServerInformation> listGerritServerInformation) {
        super(parent);
        this.fListGerritServerInformation = listGerritServerInformation;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText(Messages.SelectionDialog_selectTitle);
        mform.getForm().getShell().setText(Messages.SelectionDialog_shellText);
        ScrolledForm sform = mform.getForm();
        sform.setExpandHorizontal(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)composite);
        for (GerritServerInformation server : this.fListGerritServerInformation) {
            Button button = new Button(composite, 16);
            button.setText(server.getName());
            button.setData((Object)server);
            button.setSelection(false);
            button.addListener(13, event -> this.setSelection((GerritServerInformation)button.getData()));
            GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)button);
        }
        this.setHelpAvailable(false);
    }

    private void setSelection(GerritServerInformation selectedServer) {
        this.fSelection = selectedServer;
    }

    public GerritServerInformation getSelection() {
        return this.fSelection;
    }
}

