/**
 *   Copyright (c) 2015 Ericsson AB
 *  
 *   All rights reserved. This program and the accompanying materials are
 *   made available under the terms of the Eclipse Public License v1.0 which
 *   accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     Ericsson AB - Initial API and implementation
 */
package org.eclipse.egerrit.internal.model.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.egerrit.internal.model.util.ModelAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelItemProviderAdapterFactory extends ModelAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(ITableItemLabelProvider.class);
		supportedTypes.add(ITableItemColorProvider.class);
		supportedTypes.add(IItemColorProvider.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.RelatedChangeAndCommitInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelatedChangeAndCommitInfoItemProvider relatedChangeAndCommitInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.RelatedChangeAndCommitInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelatedChangeAndCommitInfoAdapter() {
		if (relatedChangeAndCommitInfoItemProvider == null) {
			relatedChangeAndCommitInfoItemProvider = new RelatedChangeAndCommitInfoItemProvider(this);
		}

		return relatedChangeAndCommitInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.FetchInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FetchInfoItemProvider fetchInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.FetchInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFetchInfoAdapter() {
		if (fetchInfoItemProvider == null) {
			fetchInfoItemProvider = new FetchInfoItemProvider(this);
		}

		return fetchInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.SubmitInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubmitInfoItemProvider submitInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.SubmitInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubmitInfoAdapter() {
		if (submitInfoItemProvider == null) {
			submitInfoItemProvider = new SubmitInfoItemProvider(this);
		}

		return submitInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToStringItemProvider stringToStringItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToStringAdapter() {
		if (stringToStringItemProvider == null) {
			stringToStringItemProvider = new StringToStringItemProvider(this);
		}

		return stringToStringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ProjectAccessInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectAccessInfoItemProvider projectAccessInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ProjectAccessInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjectAccessInfoAdapter() {
		if (projectAccessInfoItemProvider == null) {
			projectAccessInfoItemProvider = new ProjectAccessInfoItemProvider(this);
		}

		return projectAccessInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.CommentRange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentRangeItemProvider commentRangeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.CommentRange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentRangeAdapter() {
		if (commentRangeItemProvider == null) {
			commentRangeItemProvider = new CommentRangeItemProvider(this);
		}

		return commentRangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ActionInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ActionInfoItemProvider actionInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ActionInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createActionInfoAdapter() {
		if (actionInfoItemProvider == null) {
			actionInfoItemProvider = new ActionInfoItemProvider(this);
		}

		return actionInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.CommentInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommentInfoItemProvider commentInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.CommentInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommentInfoAdapter() {
		if (commentInfoItemProvider == null) {
			commentInfoItemProvider = new CommentInfoItemProvider(this);
		}

		return commentInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToRevisionInfoItemProvider stringToRevisionInfoItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToRevisionInfoAdapter() {
		if (stringToRevisionInfoItemProvider == null) {
			stringToRevisionInfoItemProvider = new StringToRevisionInfoItemProvider(this);
		}

		return stringToRevisionInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ReviewInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReviewInfoItemProvider reviewInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ReviewInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReviewInfoAdapter() {
		if (reviewInfoItemProvider == null) {
			reviewInfoItemProvider = new ReviewInfoItemProvider(this);
		}

		return reviewInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.LabelInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelInfoItemProvider labelInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.LabelInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLabelInfoAdapter() {
		if (labelInfoItemProvider == null) {
			labelInfoItemProvider = new LabelInfoItemProvider(this);
		}

		return labelInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ApprovalInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ApprovalInfoItemProvider approvalInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ApprovalInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createApprovalInfoAdapter() {
		if (approvalInfoItemProvider == null) {
			approvalInfoItemProvider = new ApprovalInfoItemProvider(this);
		}

		return approvalInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.RelatedChangesInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelatedChangesInfoItemProvider relatedChangesInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.RelatedChangesInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelatedChangesInfoAdapter() {
		if (relatedChangesInfoItemProvider == null) {
			relatedChangesInfoItemProvider = new RelatedChangesInfoItemProvider(this);
		}

		return relatedChangesInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.FileInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FileInfoItemProvider fileInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.FileInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFileInfoAdapter() {
		if (fileInfoItemProvider == null) {
			fileInfoItemProvider = new FileInfoItemProvider(this);
		}

		return fileInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.MergeableInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MergeableInfoItemProvider mergeableInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.MergeableInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMergeableInfoAdapter() {
		if (mergeableInfoItemProvider == null) {
			mergeableInfoItemProvider = new MergeableInfoItemProvider(this);
		}

		return mergeableInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ProjectInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProjectInfoItemProvider projectInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ProjectInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProjectInfoAdapter() {
		if (projectInfoItemProvider == null) {
			projectInfoItemProvider = new ProjectInfoItemProvider(this);
		}

		return projectInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.CommitInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CommitInfoItemProvider commitInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.CommitInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCommitInfoAdapter() {
		if (commitInfoItemProvider == null) {
			commitInfoItemProvider = new CommitInfoItemProvider(this);
		}

		return commitInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.AccountInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AccountInfoItemProvider accountInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.AccountInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAccountInfoAdapter() {
		if (accountInfoItemProvider == null) {
			accountInfoItemProvider = new AccountInfoItemProvider(this);
		}

		return accountInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ReviewerInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReviewerInfoItemProvider reviewerInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ReviewerInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReviewerInfoAdapter() {
		if (reviewerInfoItemProvider == null) {
			reviewerInfoItemProvider = new ReviewerInfoItemProvider(this);
		}

		return reviewerInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.GitPersonInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GitPersonInfoItemProvider gitPersonInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.GitPersonInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGitPersonInfoAdapter() {
		if (gitPersonInfoItemProvider == null) {
			gitPersonInfoItemProvider = new GitPersonInfoItemProvider(this);
		}

		return gitPersonInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.IncludedInInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludedInInfoItemProvider includedInInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.IncludedInInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludedInInfoAdapter() {
		if (includedInInfoItemProvider == null) {
			includedInInfoItemProvider = new IncludedInInfoItemProvider(this);
		}

		return includedInInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToFileInfoItemProvider stringToFileInfoItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToFileInfoAdapter() {
		if (stringToFileInfoItemProvider == null) {
			stringToFileInfoItemProvider = new StringToFileInfoItemProvider(this);
		}

		return stringToFileInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToLabelInfoItemProvider stringToLabelInfoItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToLabelInfoAdapter() {
		if (stringToLabelInfoItemProvider == null) {
			stringToLabelInfoItemProvider = new StringToLabelInfoItemProvider(this);
		}

		return stringToLabelInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.BranchInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BranchInfoItemProvider branchInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.BranchInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBranchInfoAdapter() {
		if (branchInfoItemProvider == null) {
			branchInfoItemProvider = new BranchInfoItemProvider(this);
		}

		return branchInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ChangeInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeInfoItemProvider changeInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ChangeInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeInfoAdapter() {
		if (changeInfoItemProvider == null) {
			changeInfoItemProvider = new ChangeInfoItemProvider(this);
		}

		return changeInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ProblemInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProblemInfoItemProvider problemInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ProblemInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProblemInfoAdapter() {
		if (problemInfoItemProvider == null) {
			problemInfoItemProvider = new ProblemInfoItemProvider(this);
		}

		return problemInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.ChangeMessageInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChangeMessageInfoItemProvider changeMessageInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.ChangeMessageInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createChangeMessageInfoAdapter() {
		if (changeMessageInfoItemProvider == null) {
			changeMessageInfoItemProvider = new ChangeMessageInfoItemProvider(this);
		}

		return changeMessageInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToActionInfoItemProvider stringToActionInfoItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToActionInfoAdapter() {
		if (stringToActionInfoItemProvider == null) {
			stringToActionInfoItemProvider = new StringToActionInfoItemProvider(this);
		}

		return stringToActionInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToListOfStringItemProvider stringToListOfStringItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToListOfStringAdapter() {
		if (stringToListOfStringItemProvider == null) {
			stringToListOfStringItemProvider = new StringToListOfStringItemProvider(this);
		}

		return stringToListOfStringItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToFetchInfoItemProvider stringToFetchInfoItemProvider;

	/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringToFetchInfoAdapter() {
		if (stringToFetchInfoItemProvider == null) {
			stringToFetchInfoItemProvider = new StringToFetchInfoItemProvider(this);
		}

		return stringToFetchInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.RevisionInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RevisionInfoItemProvider revisionInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.RevisionInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRevisionInfoAdapter() {
		if (revisionInfoItemProvider == null) {
			revisionInfoItemProvider = new RevisionInfoItemProvider(this);
		}

		return revisionInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.SuggestReviewerInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SuggestReviewerInfoItemProvider suggestReviewerInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.SuggestReviewerInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSuggestReviewerInfoAdapter() {
		if (suggestReviewerInfoItemProvider == null) {
			suggestReviewerInfoItemProvider = new SuggestReviewerInfoItemProvider(this);
		}

		return suggestReviewerInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.GroupBaseInfo} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GroupBaseInfoItemProvider groupBaseInfoItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.GroupBaseInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGroupBaseInfoAdapter() {
		if (groupBaseInfoItemProvider == null) {
			groupBaseInfoItemProvider = new GroupBaseInfoItemProvider(this);
		}

		return groupBaseInfoItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.egerrit.internal.model.Reviews} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReviewsItemProvider reviewsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.egerrit.internal.model.Reviews}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReviewsAdapter() {
		if (reviewsItemProvider == null) {
			reviewsItemProvider = new ReviewsItemProvider(this);
		}

		return reviewsItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (relatedChangeAndCommitInfoItemProvider != null)
			relatedChangeAndCommitInfoItemProvider.dispose();
		if (fetchInfoItemProvider != null)
			fetchInfoItemProvider.dispose();
		if (submitInfoItemProvider != null)
			submitInfoItemProvider.dispose();
		if (stringToStringItemProvider != null)
			stringToStringItemProvider.dispose();
		if (projectAccessInfoItemProvider != null)
			projectAccessInfoItemProvider.dispose();
		if (commentRangeItemProvider != null)
			commentRangeItemProvider.dispose();
		if (actionInfoItemProvider != null)
			actionInfoItemProvider.dispose();
		if (commentInfoItemProvider != null)
			commentInfoItemProvider.dispose();
		if (stringToRevisionInfoItemProvider != null)
			stringToRevisionInfoItemProvider.dispose();
		if (reviewInfoItemProvider != null)
			reviewInfoItemProvider.dispose();
		if (labelInfoItemProvider != null)
			labelInfoItemProvider.dispose();
		if (approvalInfoItemProvider != null)
			approvalInfoItemProvider.dispose();
		if (relatedChangesInfoItemProvider != null)
			relatedChangesInfoItemProvider.dispose();
		if (fileInfoItemProvider != null)
			fileInfoItemProvider.dispose();
		if (mergeableInfoItemProvider != null)
			mergeableInfoItemProvider.dispose();
		if (projectInfoItemProvider != null)
			projectInfoItemProvider.dispose();
		if (commitInfoItemProvider != null)
			commitInfoItemProvider.dispose();
		if (accountInfoItemProvider != null)
			accountInfoItemProvider.dispose();
		if (reviewerInfoItemProvider != null)
			reviewerInfoItemProvider.dispose();
		if (gitPersonInfoItemProvider != null)
			gitPersonInfoItemProvider.dispose();
		if (includedInInfoItemProvider != null)
			includedInInfoItemProvider.dispose();
		if (stringToFileInfoItemProvider != null)
			stringToFileInfoItemProvider.dispose();
		if (stringToLabelInfoItemProvider != null)
			stringToLabelInfoItemProvider.dispose();
		if (branchInfoItemProvider != null)
			branchInfoItemProvider.dispose();
		if (changeInfoItemProvider != null)
			changeInfoItemProvider.dispose();
		if (problemInfoItemProvider != null)
			problemInfoItemProvider.dispose();
		if (changeMessageInfoItemProvider != null)
			changeMessageInfoItemProvider.dispose();
		if (stringToActionInfoItemProvider != null)
			stringToActionInfoItemProvider.dispose();
		if (stringToListOfStringItemProvider != null)
			stringToListOfStringItemProvider.dispose();
		if (stringToFetchInfoItemProvider != null)
			stringToFetchInfoItemProvider.dispose();
		if (revisionInfoItemProvider != null)
			revisionInfoItemProvider.dispose();
		if (suggestReviewerInfoItemProvider != null)
			suggestReviewerInfoItemProvider.dispose();
		if (groupBaseInfoItemProvider != null)
			groupBaseInfoItemProvider.dispose();
		if (reviewsItemProvider != null)
			reviewsItemProvider.dispose();
	}

}
