/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class FileInfoCompareCellLabelProvider
extends CellLabelProvider {
    final String EMPTY_STRING = "";
    private static final String COMMENTS = Messages.FileInfoCompareCellLabelProvider_1;
    private static final String DRAFTS = Messages.FileInfoCompareCellLabelProvider_2;
    public static final String CHECKED_IMAGE = "greenCheck.png";
    private boolean nameFirst = true;
    private IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)FileInfoCompareCellLabelProvider.this, affectedElements.toArray());
                FileInfoCompareCellLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };

    public FileInfoCompareCellLabelProvider(IObservableMap ... attributeMaps) {
        IObservableMap[] iObservableMapArray = attributeMaps;
        int n = attributeMaps.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableMap attributeMap = iObservableMapArray[n2];
            attributeMap.addMapChangeListener(this.mapChangeListener);
            ++n2;
        }
    }

    public String getLabel(Object element, int columnIdx) {
        GerritDiffNode gerrritNode = (GerritDiffNode)((Object)element);
        switch (columnIdx) {
            case 0: {
                return "";
            }
            case 1: {
                switch (gerrritNode.getKind()) {
                    case 0: {
                        return "";
                    }
                    case 17: {
                        return "A";
                    }
                    case 34: {
                        return "D";
                    }
                    case 67: {
                        return "M";
                    }
                    case 128: {
                        return "R";
                    }
                    case 256: {
                        return "C";
                    }
                }
                return "M";
            }
            case 2: {
                return gerrritNode.getLabelName(this.nameFirst);
            }
            case 3: {
                if (gerrritNode.getLeft() == null || !(gerrritNode.getLeft() instanceof CommentableCompareItem)) {
                    return "";
                }
                return this.prettyPrintComments((CommentableCompareItem)gerrritNode.getLeft());
            }
            case 4: {
                if (gerrritNode.getRight() == null || !(gerrritNode.getRight() instanceof CommentableCompareItem)) {
                    return "";
                }
                return this.prettyPrintComments((CommentableCompareItem)gerrritNode.getRight());
            }
            case 5: {
                StringBuilder modifySize = new StringBuilder();
                FileInfo file = gerrritNode.getDiffFileInfo() != null ? gerrritNode.getDiffFileInfo() : gerrritNode.getFileInfo();
                modifySize.append('+');
                modifySize.append(Integer.toString(file.getLines_inserted()));
                modifySize.append('/');
                modifySize.append('-');
                modifySize.append(Integer.toString(file.getLines_deleted()));
                return modifySize.toString();
            }
        }
        return "";
    }

    private String prettyPrintComments(CommentableCompareItem commentableCompareItem) {
        String result = "";
        int commentsCount = commentableCompareItem.getComments().size();
        int draftsCount = commentableCompareItem.getDrafts().size();
        if (draftsCount != 0) {
            result = String.valueOf(result) + DRAFTS + draftsCount;
            if (commentsCount != 0) {
                result = String.valueOf(result) + " ";
            }
        } else {
            result = "                     ";
        }
        if (commentsCount != 0) {
            result = String.valueOf(result) + COMMENTS + commentsCount;
        }
        return result;
    }

    public void update(ViewerCell cell) {
        Object obj;
        if (cell != null && (obj = cell.getElement()) instanceof GerritDiffNode) {
            cell.setText(this.getLabel(obj, cell.getColumnIndex()));
            if (cell.getColumnIndex() == 0) {
                GerritDiffNode gerrritNode = (GerritDiffNode)((Object)obj);
                FileInfo fileInfo = gerrritNode.getFileInfo();
                Image image = this.getReviewedStateImage(fileInfo.isReviewed());
                cell.setImage(image);
            }
        }
    }

    private Image getReviewedStateImage(boolean aState) {
        if (aState) {
            return EGerritImages.get("icons/greenCheck.png");
        }
        return null;
    }

    public void setFileNameFirst(boolean b) {
        this.nameFirst = b;
    }

    public boolean getFileOrder() {
        return this.nameFirst;
    }
}

