/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.filter;

import java.util.ArrayList;
import org.eclipse.egerrit.internal.model.impl.ChangeMessageInfoImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AuthorKindFilter
extends ViewerFilter {
    private boolean fIsMachine;

    public AuthorKindFilter(boolean isMachine) {
        this.fIsMachine = isMachine;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ChangeMessageInfoImpl row = (ChangeMessageInfoImpl)element;
        if (row != null && row.getAuthor() != null) {
            if (this.fIsMachine) {
                return this.hasCiAuthor(row.getAuthor().getName());
            }
            return !this.hasCiAuthor(row.getAuthor().getName());
        }
        return true;
    }

    private boolean hasCiAuthor(String authorName) {
        String[] testName;
        boolean included = false;
        String[] stringArray = testName = AuthorCiName.getAllNames();
        int n = testName.length;
        int n2 = 0;
        while (n2 < n) {
            String st = stringArray[n2];
            if (authorName.toLowerCase().contains(st.toLowerCase())) {
                included = true;
            }
            ++n2;
        }
        return included;
    }

    static enum AuthorCiName {
        HUDSON("Hudson"),
        JENKINS("Jenkins"),
        CI(" CI");

        private final String name;

        private AuthorCiName(String aName) {
            this.name = aName;
        }

        private String getName() {
            return this.name;
        }

        private static String[] getAllNames() {
            ArrayList<String> listName = new ArrayList<String>();
            AuthorCiName[] authorCiNameArray = AuthorCiName.values();
            int n = authorCiNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                AuthorCiName st = authorCiNameArray[n2];
                listName.add(st.getName());
                ++n2;
            }
            return listName.toArray(new String[0]);
        }
    }
}

