/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.completion;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.ListProjectsCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.dashboard.ui.completion.ParamCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposal;
import org.eclipse.egerrit.internal.dashboard.ui.utils.UIUtils;
import org.eclipse.egerrit.internal.model.ProjectInfo;

public class ProjectNameCompleter
extends ParamCompleter {
    public ProjectNameCompleter() {
        super(new String[]{"project:", "parentproject:"});
    }

    @Override
    public SearchContentProposal[] requestCompletionList(String lastWord, String query, GerritClient client) {
        if (lastWord.length() < 3) {
            return null;
        }
        ListProjectsCommand command = client.listProjects();
        command.setMaxNumberOfResults(20);
        command.setQuery(lastWord);
        Map res = null;
        try {
            res = (Map)command.call();
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(client.getRepository().formatGerritVersion()) + e.getMessage()));
        }
        if (res == null) {
            return null;
        }
        ArrayList<SearchContentProposal> proposals = new ArrayList<SearchContentProposal>();
        for (Map.Entry info : res.entrySet()) {
            String projectName = (String)info.getKey();
            String description = ((ProjectInfo)info.getValue()).getDescription();
            String fullProjectDescription = description != null && !description.isEmpty() ? String.valueOf(projectName) + " (" + description + ")" : projectName;
            proposals.add(new SearchContentProposal(String.valueOf(query.substring(0, query.length() - lastWord.length())) + UIUtils.quoteIfNeeded(projectName), fullProjectDescription));
        }
        return proposals.toArray(new SearchContentProposal[proposals.size()]);
    }
}

