/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.completion;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.dashboard.ui.completion.AccountCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.AccountGroupCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.ParamCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.ProjectNameCompleter;
import org.eclipse.egerrit.internal.dashboard.ui.completion.SearchContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class SearchContentProposalProvider
implements IContentProposalProvider {
    public static final String SELF = "self";
    public static final String REVIEWER_IN = "reviewerin:";
    public static final String OWNER_IN = "ownerin:";
    public static final String FROM = "from:";
    public static final String COMMITTER = "committer:";
    public static final String AUTHOR = "author:";
    public static final String REVIEWED_BY = "reviewedby:";
    public static final String COMMENT_BY = "commentby:";
    public static final String OWNER = "owner:";
    public static final String REVIEWER = "reviewer:";
    public static final String PARENT_PROJECT = "parentproject:";
    public static final String PROJECT = "project:";
    private static final String OWNER_SELF = "owner:self";
    private static final String STATUS_OPEN = "status:open";
    private static final String AGE_1WEEK = "age:1week";
    private static final ParamCompleter[] paramCompleters = new ParamCompleter[]{new ProjectNameCompleter(), new AccountCompleter(), new AccountGroupCompleter()};
    private static final List<String> completionList = new ArrayList<String>();
    private Runnable fConnectRequest;
    private String fPreviousSearchContent;
    private GerritClient fGerritClient;

    static {
        completionList.add("age:");
        completionList.add(AGE_1WEEK);
        completionList.add("added:");
        completionList.add("AND");
        completionList.add("branch:");
        completionList.add("bug:");
        completionList.add("change:");
        completionList.add("commit:");
        completionList.add("comment:");
        completionList.add("conflicts:");
        completionList.add("deleted:");
        completionList.add("delta:");
        completionList.add("file:");
        completionList.add("has:");
        completionList.add("has:draft");
        completionList.add("has:star");
        completionList.add("is:");
        completionList.add("is:open");
        completionList.add("is:merged");
        completionList.add("is:submitted");
        completionList.add("is:abandoned");
        completionList.add("is:closed");
        completionList.add("is:draft");
        completionList.add("is:owner");
        completionList.add("is:mergeable");
        completionList.add("is:pending");
        completionList.add("is:reviewed");
        completionList.add("is:reviewer");
        completionList.add("is:starred");
        completionList.add("is:watched");
        completionList.add("label:");
        completionList.add("limit:");
        completionList.add("limit:10");
        completionList.add("message:");
        completionList.add("NOT");
        completionList.add("OR");
        completionList.add(OWNER);
        completionList.add(OWNER_SELF);
        completionList.add(OWNER_IN);
        completionList.add(PROJECT);
        completionList.add("projects:");
        completionList.add(PARENT_PROJECT);
        completionList.add(REVIEWER);
        completionList.add("reviewer:self");
        completionList.add(REVIEWER_IN);
        completionList.add("ref:");
        completionList.add("status:");
        completionList.add(STATUS_OPEN);
        completionList.add("status:draft");
        completionList.add("status:merged");
        completionList.add("status:abandoned");
        completionList.add("status:pending");
        completionList.add("status:reviewed");
        completionList.add("status:submitted");
        completionList.add("status:closed");
        completionList.add("size:");
        completionList.add("topic:");
        completionList.add("tr:");
    }

    public SearchContentProposalProvider(Runnable connectRequest) {
        this.fConnectRequest = connectRequest;
    }

    public void setGerritClient(GerritClient client) {
        this.fGerritClient = client;
    }

    private boolean isSignedIn() {
        if (this.fGerritClient == null) {
            return false;
        }
        return !this.fGerritClient.getRepository().getServerInfo().isAnonymous();
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents != null && (contents.isEmpty() || !contents.equals(this.fPreviousSearchContent))) {
            this.fPreviousSearchContent = contents;
            while (position < contents.length() && contents.charAt(contents.length() - 1) == ' ') {
                contents = contents.substring(0, contents.length() - 1);
            }
            return this.getProposals(contents);
        }
        return null;
    }

    private SearchContentProposal[] getProposals(String contents) {
        if (contents.trim().isEmpty()) {
            return this.getDefaultProposals();
        }
        String lastWord = SearchContentProposalProvider.getLastWord(contents);
        if (lastWord == null) {
            return null;
        }
        ParamCompleter[] paramCompleterArray = paramCompleters;
        int n = paramCompleters.length;
        int n2 = 0;
        while (n2 < n) {
            ParamCompleter completer = paramCompleterArray[n2];
            if (completer.isApplicable(lastWord)) {
                if (this.fGerritClient == null && this.fConnectRequest != null) {
                    this.fConnectRequest.run();
                }
                if (this.fGerritClient == null) break;
                return completer.suggest(lastWord, contents, this.fGerritClient);
            }
            ++n2;
        }
        ArrayList<SearchContentProposal> proposals = new ArrayList<SearchContentProposal>();
        for (String suggestion : completionList) {
            if (lastWord.length() >= suggestion.length() || !suggestion.startsWith(lastWord) || suggestion.contains(SELF) && !this.isSignedIn()) continue;
            proposals.add(new SearchContentProposal(String.valueOf(contents.substring(0, contents.length() - lastWord.length())) + suggestion, suggestion));
        }
        return proposals.toArray(new SearchContentProposal[proposals.size()]);
    }

    private SearchContentProposal[] getDefaultProposals() {
        ArrayList<SearchContentProposal> proposals = new ArrayList<SearchContentProposal>();
        proposals.add(new SearchContentProposal(STATUS_OPEN, STATUS_OPEN));
        proposals.add(new SearchContentProposal(AGE_1WEEK, AGE_1WEEK));
        if (this.isSignedIn()) {
            proposals.add(new SearchContentProposal(OWNER_SELF, OWNER_SELF));
        }
        return proposals.toArray(new SearchContentProposal[proposals.size()]);
    }

    private static String getLastWord(String query) {
        int lastSpace = query.lastIndexOf(32);
        if (lastSpace == query.length() - 1) {
            return null;
        }
        if (lastSpace == -1) {
            return query;
        }
        return query.substring(lastSpace + 1);
    }
}

