/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.egerrit.internal.ui.editors.EGerritCommentMarkers;
import org.eclipse.egerrit.internal.ui.editors.EGerritQuickFix;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QuickFixDeleteDraftComment
extends EGerritQuickFix {
    QuickFixDeleteDraftComment(String label, String completeMessage) {
        super(label, completeMessage);
    }

    public void run(IMarker marker) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            String message = (String)marker.getAttribute(EGerritCommentMarkers.ATTR_MESSAGE);
            GerritClient gerritClient = (GerritClient)marker.getAttribute(EGerritCommentMarkers.ATTR_GERRIT_CLIENT);
            CommentInfo existingComment = (CommentInfo)marker.getAttribute(EGerritCommentMarkers.ATTR_COMMENT_INFO);
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.QuickFixDeleteDraftComment_0, (String)(String.valueOf(Messages.QuickFixDeleteDraftComment_1) + message))) {
                QueryHelpers.deleteDraft(gerritClient, existingComment);
            }
        }
        catch (CoreException e) {
            EGerritCorePlugin.logError((String)e.getMessage());
        }
    }

    public Image getImage() {
        return EGerritImages.get("icons/delete.gif");
    }
}

