/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class EGerritCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.egerrit.core";
    private static EGerritCorePlugin fPlugin;
    private String userAgent;

    public EGerritCorePlugin() {
        EGerritCorePlugin.setDefault(this);
    }

    public static EGerritCorePlugin getDefault() {
        return fPlugin;
    }

    private static void setDefault(EGerritCorePlugin plugin) {
        fPlugin = plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EGerritCorePlugin.setDefault(this);
    }

    public void stop(BundleContext context) throws Exception {
        EGerritCorePlugin.setDefault(null);
        super.stop(context);
    }

    public static void log(IStatus status) {
        if (fPlugin != null) {
            fPlugin.getLog().log(status);
        } else {
            System.out.println(status);
        }
    }

    private static void log(int status, String message, Throwable exception) {
        String version = EGerritCorePlugin.getBundleVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("Plug-in Version: " + version + "\n");
        sb.append(message);
        EGerritCorePlugin.log((IStatus)new Status(status, PLUGIN_ID, sb.toString(), exception));
    }

    public static void logInfo(String message) {
        EGerritCorePlugin.logInfo(message, null);
    }

    public static void logInfo(String message, Throwable exception) {
        EGerritCorePlugin.log(1, message, exception);
    }

    public static void logWarning(String message) {
        EGerritCorePlugin.logWarning(message, null);
    }

    public static void logWarning(String message, Throwable exception) {
        EGerritCorePlugin.log(2, message, exception);
    }

    public static void logError(String message) {
        EGerritCorePlugin.logError(message, null);
    }

    public static void logError(String message, Throwable exception) {
        EGerritCorePlugin.log(4, message, exception);
    }

    String getUserAgent() {
        if (this.userAgent == null) {
            String productId = System.getProperty("eclipse.product", "unknownProduct");
            String buildId = System.getProperty("eclipse.buildId", "unknownBuildId");
            String pluginVersion = this.getBundle().getVersion().toString();
            this.userAgent = String.valueOf(productId) + '/' + buildId + ' ' + PLUGIN_ID + '/' + pluginVersion;
        }
        return this.userAgent;
    }

    public static String getBundleVersion() {
        String ret = "";
        Bundle bdleEgerritUi = Platform.getBundle((String)PLUGIN_ID);
        if (bdleEgerritUi != null) {
            Version version = bdleEgerritUi.getVersion();
            ret = version.toString();
        }
        return ret;
    }
}

