/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal.utils;

import org.eclipse.fx.ide.model.IFXPrimitiveProperty;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class Util {
    public static <R> R getAnnotationMemberValue(IAnnotation annotation, String name) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (name.equals(pair.getMemberName())) {
                return (R)pair.getValue();
            }
            ++n2;
        }
        return null;
    }

    public static boolean checkStatemask(int state, int mask) {
        return (state & mask) != 0;
    }

    public static String getFQNType(IType referenceType, String name) throws JavaModelException {
        if (name.contains(".")) {
            return name;
        }
        IFXPrimitiveProperty.Type[] typeArray = IFXPrimitiveProperty.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFXPrimitiveProperty.Type t = typeArray[n2];
            if (t.jvmType().equals(name)) {
                return null;
            }
            ++n2;
        }
        String[][] parts = referenceType.resolveType(name);
        if (parts != null && parts.length > 0) {
            return Util.toFQN(parts[0]);
        }
        return null;
    }

    public static String toFQN(String[] array) {
        StringBuilder b = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (b.length() > 0 && !b.toString().endsWith(".")) {
                b.append(".");
            }
            b.append(s);
            ++n2;
        }
        return b.toString();
    }

    public static String toFQN(IType owner, String signature) throws JavaModelException {
        String genericType;
        String eType = genericType = Signature.toString((String)signature);
        if (genericType.contains("<")) {
            eType = genericType.substring(genericType.indexOf(60) + 1, genericType.indexOf(62));
        }
        if (eType.contains("super")) {
            eType = eType.substring(eType.indexOf("super") + "super".length()).trim();
        } else if (eType.contains("extends")) {
            eType = eType.substring(eType.indexOf("extends") + "extends".length()).trim();
        }
        String fqn = Util.getFQNType(owner, eType);
        return fqn;
    }
}

