/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class DynCachePane<K, N extends Node>
extends Pane {
    int maxCache = 100;
    protected Map<K, N> existingNodes = new HashMap<K, N>();
    protected Map<K, N> usedNodes = new HashMap<K, N>();
    protected Queue<N> cachedNodes = new LinkedList<N>();
    private Supplier<N> nodeFactory;
    long count = 0L;

    public DynCachePane(Supplier<N> nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    protected N get(K key) {
        Node node = (Node)this.usedNodes.get(key);
        if (node == null) {
            node = (Node)this.existingNodes.get(key);
        }
        if (node == null && !this.cachedNodes.isEmpty()) {
            node = (Node)this.cachedNodes.poll();
        }
        if (node == null) {
            node = (Node)this.nodeFactory.get();
            this.existingNodes.put(key, node);
        }
        this.usedNodes.put(key, node);
        node.setVisible(true);
        return (N)node;
    }

    protected void release(K key) {
        Node node = (Node)this.existingNodes.get(key);
        if (node != null) {
            node.setVisible(false);
            this.usedNodes.remove(node);
            this.cachedNodes.add(node);
        }
    }
}

