/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public interface URLDynamicDataStreamHandler {
    public static final String DYNAMIC_DATA_KEY = "efx_DynamicDataHandlerId";
    public static final String PROTOCOL = "dyndata";
    public static final String TPL_HANDLER = "tplUrlHandler";

    public static URL createDynamicDataStreamURL(URL url, String handlerId) {
        return URLDynamicDataStreamHandler.createDynamicDataStreamURL(url, handlerId, Collections.emptyMap());
    }

    public static URL createDynamicDataStreamURL(URL url, String handlerId, Map<String, String> queryMap) {
        String query = queryMap.entrySet().stream().map(e -> {
            try {
                return URLEncoder.encode((String)e.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)e.getValue(), "UTF-8");
            }
            catch (Exception e1) {
                throw new IllegalStateException(e1);
            }
        }).collect(Collectors.joining("&"));
        String newUrl = url.getQuery() == null ? "dyndata:" + url.toExternalForm() + "?efx_DynamicDataHandlerId=" + handlerId : url.toExternalForm() + "&efx_DynamicDataHandlerId=" + handlerId;
        if (!query.isEmpty()) {
            newUrl = newUrl + "&" + query;
        }
        try {
            return new URL(newUrl);
        }
        catch (MalformedURLException e1) {
            throw new IllegalStateException("Failed to create URL '" + newUrl + "'", e1);
        }
    }

    public static boolean isValidDynamicDataStreamURL(URL url) {
        return PROTOCOL.equals(url.getProtocol()) && url.getQuery() != null && url.getQuery().contains(DYNAMIC_DATA_KEY);
    }

    public String getId();

    public @Nullable InputStream createDataStream(URL var1);
}

