/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.patch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.fx.osgi.patch.PFAdaptorHook;
import org.eclipse.fx.osgi.patch.PFConfigurator;
import org.eclipse.fx.osgi.patch.PFStorageHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.baseadaptor.DevClassPathHelper;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class PFBundleFile
extends BundleFile {
    private final BundleFile wrapped;
    private final BaseData patchedData;
    private final PFAdaptorHook pfAdaptorHook;
    private boolean processed = false;
    private BundleFile[] patches;

    public PFBundleFile(BundleFile wrapped, BaseData patchedData, PFAdaptorHook pfAdaptorHook) {
        super(wrapped.getBaseFile());
        this.wrapped = wrapped;
        this.patchedData = patchedData;
        this.pfAdaptorHook = pfAdaptorHook;
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public boolean containsDir(String dir) {
        return this.wrapped.containsDir(dir);
    }

    public BundleEntry getEntry(String path) {
        BundleFile[] patchFiles = this.getPatches();
        if (patchFiles == null) {
            return this.wrapped.getEntry(path);
        }
        if ("META-INF/MANIFEST.MF".equals(path)) {
            return this.wrapped.getEntry(path);
        }
        int i = 0;
        while (i < patchFiles.length) {
            BundleEntry entry = patchFiles[i].getEntry(path);
            if (entry != null) {
                if (PFConfigurator.DEBUG) {
                    System.out.println("Found patch for \"" + path + "\" in \"" + patchFiles[i] + "\"");
                }
                return entry;
            }
            ++i;
        }
        return this.wrapped.getEntry(path);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.wrapped.getEntryPaths(path);
    }

    public File getFile(String path, boolean nativeCode) {
        BundleFile[] patchFiles = this.getPatches();
        if (patchFiles == null) {
            return this.wrapped.getFile(path, nativeCode);
        }
        int i = 0;
        while (i < patchFiles.length) {
            File file = patchFiles[i].getFile(path, nativeCode);
            if (file != null) {
                return file;
            }
            ++i;
        }
        return this.wrapped.getFile(path, nativeCode);
    }

    public void open() throws IOException {
        this.wrapped.open();
    }

    private synchronized BundleFile[] getPatches() {
        if (this.processed) {
            return this.patches;
        }
        Bundle bundle = this.patchedData.getBundle();
        if (bundle == null) {
            return null;
        }
        if ((3 & bundle.getState()) != 0) {
            return null;
        }
        PackageAdmin pa = this.pfAdaptorHook.getPackageAdmin();
        if (pa == null) {
            return null;
        }
        ArrayList<Bundle> bundlesToListen = new ArrayList<Bundle>();
        try {
            if ((pa.getBundleType(bundle) & 1) != 0) {
                return null;
            }
            bundlesToListen.add(bundle);
            Bundle[] fragments = pa.getFragments(bundle);
            if (fragments == null) {
                return null;
            }
            ArrayList<BundleFile> patchList = new ArrayList<BundleFile>(fragments.length);
            int i = 0;
            while (i < fragments.length) {
                AbstractBundle fragment = (AbstractBundle)fragments[i];
                BaseData fragmentData = (BaseData)fragment.getBundleData();
                PFStorageHook storageHook = (PFStorageHook)fragmentData.getStorageHook(PFStorageHook.KEY);
                if (storageHook.isPatchFragment()) {
                    String[] devPath;
                    if (PFConfigurator.DEBUG) {
                        System.out.println("Found patch fragment: " + fragmentData.toString());
                    }
                    patchList.add(fragmentData.getBundleFile());
                    bundlesToListen.add((Bundle)fragment);
                    if (DevClassPathHelper.inDevelopmentMode() && (devPath = DevClassPathHelper.getDevClassPath((String)fragmentData.getSymbolicName())) != null) {
                        int j = 0;
                        while (j < devPath.length) {
                            File devFile = fragmentData.getBundleFile().getFile(devPath[i], false);
                            patchList.add(this.pfAdaptorHook.createDevClasspathBundleFile(devFile, fragmentData));
                            ++j;
                        }
                    }
                }
                this.patches = patchList.toArray(new BundleFile[patchList.size()]);
                ++i;
            }
        }
        finally {
            this.pfAdaptorHook.listenToPatches(bundlesToListen, this);
            this.processed = true;
        }
        return this.patches;
    }

    synchronized void resetPatches() {
        this.processed = false;
        this.patches = null;
    }

    public String toString() {
        return this.patchedData.toString();
    }
}

