/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.eclipse.xtext.xbase.lib.Inline;

@GwtCompatible
public class CollectionExtensions {
    @Inline(value="$1.add($2)")
    public static <E> boolean operator_add(Collection<? super E> collection, E value) {
        return collection.add(value);
    }

    @Inline(value="$3.$4addAll($1, $2)", imported={Iterables.class})
    public static <E> boolean operator_add(Collection<E> collection, Iterable<? extends E> newElements) {
        return CollectionExtensions.addAll(collection, newElements);
    }

    @Inline(value="$1.remove($2)")
    public static <E> boolean operator_remove(Collection<? super E> collection, E value) {
        return collection.remove(value);
    }

    @Inline(value="$3.removeAll($1, $2)", imported={Iterables.class})
    public static <E> boolean operator_remove(Collection<E> collection, Collection<? extends E> newElements) {
        return CollectionExtensions.removeAll(collection, newElements);
    }

    @Inline(value="$2.$3unmodifiableList($1)", imported={Collections.class})
    public static <T> List<T> unmodifiableView(List<? extends T> list) {
        return Collections.unmodifiableList(list);
    }

    @Inline(value="$2.$3unmodifiableCollection($1)", imported={Collections.class})
    public static <T> Collection<T> unmodifiableView(Collection<? extends T> collection) {
        return Collections.unmodifiableCollection(collection);
    }

    @Inline(value="$2.$3unmodifiableSet($1)", imported={Collections.class})
    public static <T> Set<T> unmodifiableView(Set<? extends T> set) {
        return Collections.unmodifiableSet(set);
    }

    @Inline(value="$2.$3unmodifiableSortedSet($1)", imported={Collections.class})
    public static <T> SortedSet<T> unmodifiableView(SortedSet<T> set) {
        return Collections.unmodifiableSortedSet(set);
    }

    @Inline(value="$2.$3unmodifiableMap($1)", imported={Collections.class})
    public static <K, V> Map<K, V> unmodifiableView(Map<? extends K, ? extends V> map) {
        return Collections.unmodifiableMap(map);
    }

    @Inline(value="$2.$3unmodifiableSortedMap($1)", imported={Collections.class})
    public static <K, V> SortedMap<K, V> unmodifiableView(SortedMap<K, ? extends V> map) {
        return Collections.unmodifiableSortedMap(map);
    }

    @Inline(value="$2.$3copyOf($1)", imported={ImmutableList.class})
    public static <T> List<T> immutableCopy(List<? extends T> list) {
        return ImmutableList.copyOf(list);
    }

    @Inline(value="$2.$3copyOf($1)", imported={ImmutableSet.class})
    public static <T> Set<T> immutableCopy(Set<? extends T> set) {
        return ImmutableSet.copyOf(set);
    }

    @Inline(value="$2.$3copyOfSorted($1)", imported={ImmutableSortedSet.class})
    public static <T> SortedSet<T> immutableCopy(SortedSet<T> set) {
        return ImmutableSortedSet.copyOfSorted(set);
    }

    @Inline(value="$2.$3copyOf($1)", imported={ImmutableMap.class})
    public static <K, V> Map<K, V> immutableCopy(Map<? extends K, ? extends V> map) {
        return ImmutableMap.copyOf(map);
    }

    @Inline(value="$2.$3copyOfSorted($1)", imported={ImmutableSortedMap.class})
    public static <K, V> SortedMap<K, V> immutableCopy(SortedMap<K, ? extends V> map) {
        return ImmutableSortedMap.copyOfSorted(map);
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... elements) {
        return collection.addAll(Arrays.asList(elements));
    }

    @Inline(value="$3.$4addAll($1, $2)", imported={Iterables.class})
    public static <T> boolean addAll(Collection<T> collection, Iterable<? extends T> elements) {
        return Iterables.addAll(collection, elements);
    }

    public static <T> boolean removeAll(Collection<? super T> collection, T ... elements) {
        return collection.removeAll(Arrays.asList(elements));
    }

    @Inline(value="$3.$4removeAll($1, $2)", imported={Iterables.class})
    public static <T> boolean removeAll(Collection<T> collection, Collection<? extends T> elements) {
        return Iterables.removeAll(collection, elements);
    }

    public static <T> boolean removeAll(Collection<T> collection, Iterable<? extends T> elements) {
        return Iterables.removeAll(collection, (Collection)Sets.newHashSet(elements));
    }
}

