/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.jdt.internal.core.util.CharArrayBuffer;

public class JavaNames {
    private static final char[] CLASS_FILE_SUFFIX = ".class".toCharArray();
    public static final char[] FIELD_DESCRIPTOR_PREFIX = new char[]{'L'};
    private static final char[] FIELD_DESCRIPTOR_SUFFIX = new char[]{';'};
    private static final char[] METHOD_ID_SEPARATOR = new char[]{'#'};
    private static final char[] JAR_FILE_ENTRY_SEPARATOR = "|".toCharArray();
    public static final char[] ARRAY_FIELD_DESCRIPTOR_PREFIX = new char[]{'['};

    public static char[] binaryNameToSimpleName(char[] binaryName) {
        int skipIndex = Math.max(Math.max(CharOperation.lastIndexOf('$', binaryName), CharOperation.lastIndexOf('.', binaryName)), CharOperation.lastIndexOf('/', binaryName)) + 1;
        return CharArrayUtils.subarray(binaryName, skipIndex);
    }

    public static char[] binaryNameToResourceRelativePath(char[] binaryName) {
        return CharOperation.concat(binaryName, CLASS_FILE_SUFFIX);
    }

    public static char[] fullyQualifiedNameToBinaryName(char[] fullyQualifiedName) {
        return CharOperation.replaceOnCopy(fullyQualifiedName, '.', '/');
    }

    public static char[] fullyQualifiedNameToFieldDescriptor(char[] fullyQualifiedName) {
        char[] result = CharArrayUtils.concat(FIELD_DESCRIPTOR_PREFIX, fullyQualifiedName, FIELD_DESCRIPTOR_SUFFIX);
        CharOperation.replace(result, '.', '/');
        return result;
    }

    public static char[] getIndexPathFor(NdType type, IWorkspaceRoot root) {
        NdResourceFile resourceFile = type.getResourceFile();
        char[] binaryName = type.getTypeId().getBinaryName();
        char[] workspaceLocation = null;
        if (root != null) {
            workspaceLocation = resourceFile.getAnyOpenWorkspaceLocation(root).toString().toCharArray();
        }
        if (workspaceLocation == null || workspaceLocation.length == 0) {
            workspaceLocation = resourceFile.getLocation().getChars();
        }
        return CharArrayUtils.concat(workspaceLocation, JAR_FILE_ENTRY_SEPARATOR, JavaNames.binaryNameToResourceRelativePath(binaryName));
    }

    public static char[] binaryNameToFieldDescriptor(char[] binaryName) {
        return CharArrayUtils.concat(FIELD_DESCRIPTOR_PREFIX, binaryName, FIELD_DESCRIPTOR_SUFFIX);
    }

    public static char[] fieldDescriptorToSimpleName(char[] fieldDescriptor) {
        if (!CharArrayUtils.startsWith(fieldDescriptor, 'L')) {
            return null;
        }
        if (!CharArrayUtils.endsWith(fieldDescriptor, ';')) {
            return null;
        }
        int separatorPosition = CharArrayUtils.lastIndexOf('/', fieldDescriptor);
        if (separatorPosition == -1) {
            separatorPosition = 0;
        }
        char[] className = CharArrayUtils.subarray(fieldDescriptor, separatorPosition + 1, fieldDescriptor.length - 1);
        return className;
    }

    public static char[] fieldDescriptorToJavaName(char[] fieldDescriptor, boolean fullyQualified) {
        int arrayCount = 0;
        CharArrayBuffer result = new CharArrayBuffer();
        int scanPosition = 0;
        while (scanPosition < fieldDescriptor.length) {
            char nextChar = fieldDescriptor[scanPosition];
            switch (nextChar) {
                case 'B': {
                    result.append("byte");
                    break;
                }
                case 'C': {
                    result.append("char");
                    break;
                }
                case 'D': {
                    result.append("double");
                    break;
                }
                case 'F': {
                    result.append("float");
                    break;
                }
                case 'I': {
                    result.append("int");
                    break;
                }
                case 'J': {
                    result.append("long");
                    break;
                }
                case 'L': {
                    int end = fieldDescriptor.length - 1;
                    char[] binaryName = CharArrayUtils.subarray(fieldDescriptor, scanPosition + 1, end);
                    if (fullyQualified) {
                        CharOperation.replace(binaryName, '/', '.');
                        result.append(binaryName);
                    } else {
                        result.append(JavaNames.binaryNameToSimpleName(binaryName));
                    }
                    scanPosition += binaryName.length;
                    break;
                }
                case 'S': {
                    result.append("short");
                    break;
                }
                case 'Z': {
                    result.append("boolean");
                    break;
                }
                case '[': {
                    ++arrayCount;
                }
            }
            ++scanPosition;
        }
        while (--arrayCount >= 0) {
            result.append("[]");
        }
        return CharArrayUtils.notNull(result.getContents());
    }

    public static char[] binaryNameToFullyQualifiedName(char[] binaryName) {
        return CharOperation.replaceOnCopy(binaryName, '/', '.');
    }

    public static char[] getMethodId(char[] parentTypeBinaryName, char[] methodSelectorAndDescriptor) {
        return CharArrayUtils.concat(FIELD_DESCRIPTOR_PREFIX, parentTypeBinaryName, METHOD_ID_SEPARATOR, methodSelectorAndDescriptor);
    }

    public static char[] getMethodId(char[] parentTypeBinaryName, char[] methodSelector, char[] methodDescriptor) {
        return CharArrayUtils.concat(FIELD_DESCRIPTOR_PREFIX, parentTypeBinaryName, METHOD_ID_SEPARATOR, methodSelector, methodDescriptor);
    }

    public static char[] fieldDescriptorToBinaryName(char[] fieldDescriptor) {
        if (CharArrayUtils.startsWith(fieldDescriptor, 'L')) {
            int end = fieldDescriptor.length - 1;
            return CharArrayUtils.subarray(fieldDescriptor, 1, end);
        }
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    public static char[] simpleNameToSourceName(char[] chars) {
        int lastSlash = CharOperation.lastIndexOf('/', chars);
        int lastDollar = CharOperation.lastIndexOf('$', chars);
        int lastDot = CharOperation.lastIndexOf('.', chars);
        int startPosition = Math.max(Math.max(lastSlash, lastDollar), lastDot) + 1;
        while (startPosition < chars.length && Character.isDigit(chars[startPosition])) {
            ++startPosition;
        }
        return CharArrayUtils.subarray(chars, startPosition);
    }

    public static String classFilePathToBinaryName(String classFilePath) {
        if (classFilePath.endsWith(".class")) {
            return classFilePath.substring(0, classFilePath.length() - 6);
        }
        return classFilePath;
    }
}

