/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.manipulation.FileBuffersMessages;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class GenericFileBufferOperationRunner {
    private final Object fValidationContext;
    private final IFileBufferManager fFileBufferManager;
    private final Object fCompletionLock = new Object();
    private transient boolean fIsCompleted;
    private transient Throwable fThrowable;

    public GenericFileBufferOperationRunner(IFileBufferManager fileBufferManager, Object validationContext) {
        this.fFileBufferManager = fileBufferManager;
        this.fValidationContext = validationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(IPath[] locations, final IFileBufferOperation operation, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        int size = locations.length;
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)operation.getOperationName(), (int)(size * 200));
        try {
            IFileBuffer[] fileBuffers = this.createFileBuffers(locations, (IProgressMonitor)subMonitor.split(size * 10));
            IFileBuffer[] fileBuffers2Save = this.findFileBuffersToSave(fileBuffers);
            this.fFileBufferManager.validateState(fileBuffers2Save, (IProgressMonitor)subMonitor.split(size * 10), this.fValidationContext);
            if (!this.isCommitable(fileBuffers2Save)) {
                throw new OperationCanceledException();
            }
            IFileBuffer[] unsynchronizedFileBuffers = this.findUnsynchronizedFileBuffers(fileBuffers);
            this.performOperation(unsynchronizedFileBuffers, operation, (IProgressMonitor)subMonitor.split(size * 40));
            final IFileBuffer[] synchronizedFileBuffers = this.findSynchronizedFileBuffers(fileBuffers);
            this.fIsCompleted = false;
            this.fThrowable = null;
            Object object = this.fCompletionLock;
            synchronized (object) {
                this.executeInContext(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = GenericFileBufferOperationRunner.this.fCompletionLock;
                        synchronized (object) {
                            try {
                                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                                    public void handleException(Throwable throwable) {
                                        GenericFileBufferOperationRunner.this.fThrowable = throwable;
                                    }

                                    public void run() throws Exception {
                                        GenericFileBufferOperationRunner.this.performOperation(synchronizedFileBuffers, operation, (IProgressMonitor)subMonitor.split(50));
                                    }
                                });
                            }
                            finally {
                                GenericFileBufferOperationRunner.this.fIsCompleted = true;
                                GenericFileBufferOperationRunner.this.fCompletionLock.notifyAll();
                            }
                        }
                    }
                });
                while (!this.fIsCompleted) {
                    try {
                        this.fCompletionLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.fThrowable != null) {
                if (this.fThrowable instanceof CoreException) {
                    throw (CoreException)this.fThrowable;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, this.fThrowable.getLocalizedMessage(), this.fThrowable));
            }
            this.commit(fileBuffers2Save, (IProgressMonitor)subMonitor.split(size * 80));
        }
        finally {
            this.releaseFileBuffers(locations, (IProgressMonitor)subMonitor.split(size * 10));
        }
    }

    private void performOperation(IFileBuffer fileBuffer, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        ISchedulingRule rule = fileBuffer.computeCommitRule();
        IJobManager manager = Job.getJobManager();
        manager.beginRule(rule, (IProgressMonitor)subMonitor.split(1));
        String name = fileBuffer.getLocation().lastSegment();
        subMonitor.setTaskName(name);
        operation.run(fileBuffer, (IProgressMonitor)subMonitor.split(99));
        manager.endRule(rule);
    }

    private void performOperation(IFileBuffer[] fileBuffers, IFileBufferOperation operation, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)fileBuffers.length);
        IFileBuffer[] iFileBufferArray = fileBuffers;
        int n = fileBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            this.performOperation(fileBuffer, operation, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    private void executeInContext(Runnable runnable) {
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        fileBufferManager.execute(runnable);
    }

    private IFileBuffer[] findUnsynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isSynchronizationContextRequested()) {
                list.add(fileBuffers[i]);
            }
            ++i;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private IFileBuffer[] findSynchronizedFileBuffers(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        IFileBuffer[] iFileBufferArray = fileBuffers;
        int n = fileBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            if (fileBuffer.isSynchronizationContextRequested()) {
                list.add(fileBuffer);
            }
            ++n2;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private IFileBuffer[] createFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)FileBuffersMessages.FileBufferOperationRunner_task_connecting, (int)locations.length);
        try {
            IFileBuffer[] fileBuffers = new ITextFileBuffer[locations.length];
            int i = 0;
            while (i < locations.length) {
                this.fFileBufferManager.connect(locations[i], LocationKind.NORMALIZE, (IProgressMonitor)subMonitor.split(1));
                fileBuffers[i] = this.fFileBufferManager.getFileBuffer(locations[i], LocationKind.NORMALIZE);
                ++i;
            }
            return fileBuffers;
        }
        catch (CoreException x) {
            try {
                this.releaseFileBuffers(locations, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
            throw x;
        }
    }

    private void releaseFileBuffers(IPath[] locations, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)FileBuffersMessages.FileBufferOperationRunner_task_disconnecting, (int)locations.length);
        ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath[] iPathArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location = iPathArray[n2];
            fileBufferManager.disconnect(location, LocationKind.NORMALIZE, (IProgressMonitor)subMonitor.split(1));
            ++n2;
        }
    }

    private IFileBuffer[] findFileBuffersToSave(IFileBuffer[] fileBuffers) {
        ArrayList<IFileBuffer> list = new ArrayList<IFileBuffer>();
        IFileBuffer[] iFileBufferArray = fileBuffers;
        int n = fileBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            IFileBuffer buffer = fileBuffer;
            if (!buffer.isDirty()) {
                list.add(buffer);
            }
            ++n2;
        }
        return list.toArray(new IFileBuffer[list.size()]);
    }

    private boolean isCommitable(IFileBuffer[] fileBuffers) {
        int i = 0;
        while (i < fileBuffers.length) {
            if (!fileBuffers[i].isCommitable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected ISchedulingRule computeCommitRule(IFileBuffer[] fileBuffers) {
        ArrayList<ISchedulingRule> list = new ArrayList<ISchedulingRule>();
        IFileBuffer[] iFileBufferArray = fileBuffers;
        int n = fileBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            ISchedulingRule rule = fileBuffer.computeCommitRule();
            if (rule != null) {
                list.add(rule);
            }
            ++n2;
        }
        ISchedulingRule[] rules = new ISchedulingRule[list.size()];
        list.toArray(rules);
        return new MultiRule(rules);
    }

    protected void commit(IFileBuffer[] fileBuffers, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
        ISchedulingRule rule = this.computeCommitRule(fileBuffers);
        Job.getJobManager().beginRule(rule, (IProgressMonitor)subMonitor.split(1));
        try {
            this.doCommit(fileBuffers, (IProgressMonitor)subMonitor.split(1));
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    protected void doCommit(IFileBuffer[] fileBuffers, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)FileBuffersMessages.FileBufferOperationRunner_task_committing, (int)fileBuffers.length);
        IFileBuffer[] iFileBufferArray = fileBuffers;
        int n = fileBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            IFileBuffer fileBuffer = iFileBufferArray[n2];
            fileBuffer.commit((IProgressMonitor)subMonitor.split(1), true);
            ++n2;
        }
    }
}

