/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.adapter;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.binder.AnnotatedBindingBuilder;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.adapter.NamingAdapter;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.RuntimeProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.StandardProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.XtextProjectConfig;

public class Generator2AdapterSetup {
    private final LanguageConfig languageConfig;
    private final XpandExecutionContext xpandContext;
    private final Naming naming;
    private Injector injector;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private Module additionalGeneratorBindings = it -> {};
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private Module additionalLanguageBindings = it -> {};

    public Generator2AdapterSetup(LanguageConfig languageConfig, XpandExecutionContext xpandContext, Naming naming) {
        this.languageConfig = languageConfig;
        this.xpandContext = xpandContext;
        this.naming = naming;
    }

    public Injector getInjector() {
        Injector _xblockexpression = null;
        if (this.injector == null) {
            this.injector = this.createInjector();
        }
        _xblockexpression = this.injector;
        return _xblockexpression;
    }

    private Injector createInjector() {
        Module _function_1;
        Procedures.Procedure1 _function = it -> {
            it.setProject(this.createProjectConfig());
            it.setCode(this.createCodeConfig());
        };
        DefaultGeneratorModule generatorModule = (DefaultGeneratorModule)ObjectExtensions.operator_doubleArrow((Object)new DefaultGeneratorModule(){

            public void configure(Binder binder) {
                super.configure(binder);
                binder.install(Generator2AdapterSetup.this.additionalGeneratorBindings);
            }
        }, (Procedures.Procedure1)_function);
        Injector generatorInjector = Guice.createInjector((Module[])new Module[]{generatorModule});
        generatorModule.getProject().initialize(generatorInjector);
        generatorModule.getCode().initialize(generatorInjector);
        IXtextGeneratorLanguage language = this.createLanguage(generatorInjector);
        Module languageModule = _function_1 = it -> {
            it.bind(IXtextGeneratorLanguage.class).toInstance((Object)language);
            it.bind(Grammar.class).toInstance((Object)language.getGrammar());
            AnnotatedBindingBuilder _bind = it.bind(XtextGeneratorNaming.class);
            NamingAdapter _namingAdapter = new NamingAdapter(this.naming);
            _bind.toInstance((Object)_namingAdapter);
            it.install(this.additionalLanguageBindings);
        };
        return generatorInjector.createChildInjector(new Module[]{languageModule});
    }

    private XtextProjectConfig createProjectConfig() {
        StandardProjectConfig _standardProjectConfig = new StandardProjectConfig();
        Procedures.Procedure1 _function = it -> {
            it.setCreateEclipseMetaData(true);
            it.setBaseName(this.naming.getProjectNameRt());
            String runtimeRoot = this.xpandContext.getOutput().getOutlet("PLUGIN").getPath();
            int projectNameIndex = runtimeRoot.lastIndexOf(it.getBaseName());
            if (projectNameIndex >= 0) {
                it.setRootPath(runtimeRoot.substring(0, projectNameIndex));
            } else {
                it.setRootPath(runtimeRoot);
            }
            RuntimeProjectConfig _runtime = it.getRuntime();
            _runtime.setName(it.getBaseName());
            RuntimeProjectConfig _runtime_1 = it.getRuntime();
            _runtime_1.setRoot(runtimeRoot);
            RuntimeProjectConfig _runtime_2 = it.getRuntime();
            _runtime_2.setSrc(this.xpandContext.getOutput().getOutlet("SRC").getPath());
            RuntimeProjectConfig _runtime_3 = it.getRuntime();
            _runtime_3.setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN").getPath());
            RuntimeProjectConfig _runtime_4 = it.getRuntime();
            _runtime_4.setEcoreModel(this.xpandContext.getOutput().getOutlet("MODEL").getPath());
            BundleProjectConfig _eclipsePlugin = it.getEclipsePlugin();
            _eclipsePlugin.setEnabled(true);
            BundleProjectConfig _eclipsePlugin_1 = it.getEclipsePlugin();
            _eclipsePlugin_1.setName(this.naming.getProjectNameUi());
            BundleProjectConfig _eclipsePlugin_2 = it.getEclipsePlugin();
            _eclipsePlugin_2.setRoot(this.xpandContext.getOutput().getOutlet("PLUGIN_UI").getPath());
            BundleProjectConfig _eclipsePlugin_3 = it.getEclipsePlugin();
            _eclipsePlugin_3.setSrc(this.xpandContext.getOutput().getOutlet("SRC_UI").getPath());
            BundleProjectConfig _eclipsePlugin_4 = it.getEclipsePlugin();
            _eclipsePlugin_4.setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN_UI").getPath());
            BundleProjectConfig _genericIde = it.getGenericIde();
            _genericIde.setEnabled(true);
            BundleProjectConfig _genericIde_1 = it.getGenericIde();
            _genericIde_1.setName(this.naming.getProjectNameIde());
            BundleProjectConfig _genericIde_2 = it.getGenericIde();
            _genericIde_2.setRoot(this.xpandContext.getOutput().getOutlet("PLUGIN_IDE").getPath());
            BundleProjectConfig _genericIde_3 = it.getGenericIde();
            _genericIde_3.setSrc(this.xpandContext.getOutput().getOutlet("SRC_IDE").getPath());
            BundleProjectConfig _genericIde_4 = it.getGenericIde();
            _genericIde_4.setSrcGen(this.xpandContext.getOutput().getOutlet("SRC_GEN_IDE").getPath());
        };
        return (XtextProjectConfig)ObjectExtensions.operator_doubleArrow((Object)_standardProjectConfig, (Procedures.Procedure1)_function);
    }

    private CodeConfig createCodeConfig() {
        CodeConfig _codeConfig = new CodeConfig();
        Procedures.Procedure1 _function = it -> {
            it.setLineDelimiter(this.naming.getLineDelimiter());
            it.setFileHeader(this.naming.fileHeader());
        };
        return (CodeConfig)ObjectExtensions.operator_doubleArrow((Object)_codeConfig, (Procedures.Procedure1)_function);
    }

    private IXtextGeneratorLanguage createLanguage(Injector generatorInjector) {
        XtextGeneratorLanguage _xtextGeneratorLanguage = new XtextGeneratorLanguage();
        Procedures.Procedure1 _function = it -> {
            it.setGrammarUri(this.languageConfig.getGrammar().eResource().getURI().toString());
            it.setResourceSet(this.languageConfig.getGrammar().eResource().getResourceSet());
            it.setFileExtensions(IterableExtensions.join(this.languageConfig.getFileExtensions(this.languageConfig.getGrammar()), (CharSequence)","));
            generatorInjector.injectMembers(it);
            it.initialize(this.languageConfig.getGrammar());
        };
        return (IXtextGeneratorLanguage)ObjectExtensions.operator_doubleArrow((Object)_xtextGeneratorLanguage, (Procedures.Procedure1)_function);
    }

    public void setAdditionalGeneratorBindings(Module additionalGeneratorBindings) {
        this.additionalGeneratorBindings = additionalGeneratorBindings;
    }

    public void setAdditionalLanguageBindings(Module additionalLanguageBindings) {
        this.additionalLanguageBindings = additionalLanguageBindings;
    }
}

