/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.CheckBox;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.control.cell.CheckBoxTreeTableCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.fx.core.ReflectionUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AdapterFactoryCellFactory {
    protected final @NonNull AdapterFactory adapterFactory;
    final @NonNull List<ICellCreationListener> cellCreationListeners = new ArrayList<ICellCreationListener>();
    final @NonNull List<ICellUpdateListener> cellUpdateListeners = new ArrayList<ICellUpdateListener>();
    final @NonNull List<ICellEditHandler> cellEditHandlers = new ArrayList<ICellEditHandler>();

    public AdapterFactoryCellFactory(@NonNull AdapterFactory adapterFactory) {
        if (adapterFactory == null) {
            throw new IllegalArgumentException("AdapterFactory must not be null.");
        }
        this.adapterFactory = adapterFactory;
    }

    public @NonNull AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void addCellCreationListener(@NonNull ICellCreationListener listener) {
        this.cellCreationListeners.add(listener);
    }

    public void removeCellCreationListener(@NonNull ICellCreationListener listener) {
        this.cellCreationListeners.remove(listener);
    }

    public void addCellUpdateListener(@NonNull ICellUpdateListener listener) {
        this.cellUpdateListeners.add(listener);
    }

    public void removeCellUpdateListener(@NonNull ICellUpdateListener listener) {
        this.cellUpdateListeners.remove(listener);
    }

    public void addCellEditHandler(@NonNull ICellEditHandler cellEditHandler) {
        this.cellEditHandlers.add(cellEditHandler);
    }

    public void remvoveCellEditHandler(@NonNull ICellEditHandler cellEditHandler) {
        this.cellEditHandlers.remove(cellEditHandler);
    }

    @Nullable ICellEditHandler getCellEditHandler(Cell<?> cell) {
        for (ICellEditHandler cellEditHandler : this.cellEditHandlers) {
            if (!cellEditHandler.canEdit(cell)) continue;
            return cellEditHandler;
        }
        return null;
    }

    static void applyItemProviderStyle(@Nullable Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        AdapterFactoryCellFactory.applyItemProviderLabel(item, cell, adapterFactory);
        AdapterFactoryCellFactory.applyItemProviderColor(item, cell, adapterFactory);
        AdapterFactoryCellFactory.applyItemProviderFont(item, cell, adapterFactory);
    }

    static void applyItemProviderFont(@Nullable Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        IItemFontProvider fontProvider = (IItemFontProvider)adapterFactory.adapt(item, IItemFontProvider.class);
        if (fontProvider != null) {
            Font font = AdapterFactoryCellFactory.fontFromObject(fontProvider.getFont(item));
            cell.setFont(font == null ? Font.getDefault() : font);
        }
    }

    static Font fontFromObject(@Nullable Object object) {
        if (object instanceof URI) {
            int height;
            boolean delta;
            String heightSpecification;
            URI fontURI = (URI)object;
            if (!"font".equals(fontURI.scheme())) {
                throw new IllegalArgumentException("Only 'font' scheme is recognized" + fontURI);
            }
            if (fontURI.segmentCount() != 2) {
                throw new IllegalArgumentException("The URI must have an authority and two segments");
            }
            String fontNameSpecification = fontURI.authority();
            if ("".equals(fontNameSpecification)) {
                fontNameSpecification = null;
            }
            if ((heightSpecification = fontURI.segment(0)).startsWith("+")) {
                delta = true;
                height = Integer.parseInt(heightSpecification.substring(1));
            } else if ("".equals(heightSpecification)) {
                delta = true;
                height = 0;
            } else {
                height = Integer.parseInt(heightSpecification);
                delta = height < 0;
            }
            String styleSpecification = fontURI.segment(1);
            boolean italic = false;
            boolean bold = false;
            if ("bold".equals(styleSpecification)) {
                bold = true;
            } else if ("italic".equals(styleSpecification)) {
                italic = true;
            } else if ("italic+bold".equals(styleSpecification) || "bold+italic".equals(styleSpecification)) {
                italic = true;
                bold = true;
            }
            double size = delta ? Font.getDefault().getSize() + (double)height : (double)height;
            return Font.font((String)fontNameSpecification, (FontWeight)(bold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)size);
        }
        return null;
    }

    static void applyItemProviderLabel(@Nullable Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            cell.setText(labelProvider.getText(item));
            Node graphic = AdapterFactoryCellFactory.graphicFromObject(labelProvider.getImage(item));
            if (graphic == null) {
                AdapterFactoryCellFactory.resetPropertyState(cell, cell.graphicProperty(), null);
            } else if (cell instanceof CheckBoxTreeCell || cell instanceof CheckBoxTreeTableCell || cell instanceof CheckBoxListCell || cell instanceof CheckBoxTableCell) {
                Object value = ReflectionUtil.getFieldValue(cell, (String)"checkBox");
                ((CheckBox)value).setGraphic(graphic);
            } else {
                cell.setGraphic(graphic);
            }
        } else {
            cell.setText(null);
            AdapterFactoryCellFactory.resetPropertyState(cell, cell.graphicProperty(), null);
        }
    }

    static void applyTableItemProviderStyle(@Nullable Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        AdapterFactoryCellFactory.applyTableItemProviderLabel(item, columnIndex, cell, adapterFactory);
        AdapterFactoryCellFactory.applyTableItemProviderColor(item, columnIndex, cell, adapterFactory);
        AdapterFactoryCellFactory.applyTableItemProviderFont(item, columnIndex, cell, adapterFactory);
    }

    static void applyTableItemProviderLabel(@Nullable Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        ITableItemLabelProvider labelProvider = (ITableItemLabelProvider)adapterFactory.adapt(item, ITableItemLabelProvider.class);
        if (labelProvider != null) {
            cell.setText(labelProvider.getColumnText(item, columnIndex));
            Object columnImage = labelProvider.getColumnImage(item, columnIndex);
            Node graphic = AdapterFactoryCellFactory.graphicFromObject(columnImage);
            if (graphic == null) {
                AdapterFactoryCellFactory.resetPropertyState(cell, cell.graphicProperty(), null);
            } else {
                cell.setGraphic(graphic);
            }
        } else {
            cell.setText(null);
            AdapterFactoryCellFactory.resetPropertyState(cell, cell.graphicProperty(), null);
        }
    }

    static void applyTableItemProviderColor(@Nullable Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        ITableItemColorProvider colorProvider = (ITableItemColorProvider)adapterFactory.adapt(item, ITableItemColorProvider.class);
        if (colorProvider != null) {
            Color color = AdapterFactoryCellFactory.colorFromObject(colorProvider.getForeground(item, columnIndex));
            if (color == null) {
                AdapterFactoryCellFactory.resetPropertyState(cell, cell.textFillProperty(), Color.BLACK);
            } else {
                cell.setTextFill((Paint)color);
            }
            String background = AdapterFactoryCellFactory.cssColorFromObject(colorProvider.getBackground(item, columnIndex));
            if (background != null) {
                cell.setStyle("-fx-background-color: " + background);
            } else {
                cell.setStyle(null);
            }
        } else {
            AdapterFactoryCellFactory.resetPropertyState(cell, cell.textFillProperty(), Color.BLACK);
            cell.setStyle(null);
        }
    }

    static void applyTableItemProviderFont(@Nullable Object item, int columnIndex, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        ITableItemFontProvider fontProvider = (ITableItemFontProvider)adapterFactory.adapt(item, ITableItemFontProvider.class);
        if (fontProvider != null) {
            Font font = AdapterFactoryCellFactory.fontFromObject(fontProvider.getFont(item, columnIndex));
            if (font == null) {
                AdapterFactoryCellFactory.resetPropertyState(cell, cell.fontProperty(), Font.getDefault());
            } else {
                cell.setFont(font);
            }
        } else {
            AdapterFactoryCellFactory.resetPropertyState(cell, cell.fontProperty(), Font.getDefault());
        }
    }

    protected static <T> void resetPropertyState(Cell<?> cell, ObjectProperty<T> property, T defaultValue) {
        if (property instanceof StyleableProperty) {
            StyleableProperty styleableProperty = (StyleableProperty)property;
            styleableProperty.applyStyle(null, defaultValue);
            cell.applyCss();
        } else {
            property.set(defaultValue);
        }
    }

    static Node graphicFromObject(@Nullable Object object) {
        if (object instanceof Node) {
            return (Node)object;
        }
        if (object instanceof URL) {
            return new ImageView(((URL)object).toExternalForm());
        }
        if (object instanceof ComposedImage) {
            Pane pane = new Pane();
            for (Object image : ((ComposedImage)object).getImages()) {
                if (!(image instanceof URL)) continue;
                ImageView imageView = new ImageView(((URL)image).toExternalForm());
                pane.getChildren().add((Object)imageView);
            }
            return pane;
        }
        return null;
    }

    static void applyItemProviderColor(@Nullable Object item, @NonNull Cell<?> cell, @NonNull AdapterFactory adapterFactory) {
        IItemColorProvider colorProvider = (IItemColorProvider)adapterFactory.adapt(item, IItemColorProvider.class);
        if (colorProvider != null) {
            Color color = AdapterFactoryCellFactory.colorFromObject(colorProvider.getForeground(item));
            if (color == null) {
                AdapterFactoryCellFactory.resetPropertyState(cell, cell.textFillProperty(), Color.BLACK);
            } else {
                cell.setTextFill((Paint)color);
            }
            String background = AdapterFactoryCellFactory.cssColorFromObject(colorProvider.getBackground(item));
            if (background != null) {
                cell.setStyle("-fx-background-color: " + background);
            } else {
                cell.setStyle(null);
            }
        } else {
            AdapterFactoryCellFactory.resetPropertyState(cell, cell.textFillProperty(), Color.BLACK);
            cell.setStyle(null);
        }
    }

    static Color colorFromObject(@Nullable Object object) {
        URI colorURI = AdapterFactoryCellFactory.toColorURI(object);
        if (colorURI != null) {
            try {
                int red = Integer.parseInt(colorURI.segment(0));
                int green = Integer.parseInt(colorURI.segment(1));
                int blue = Integer.parseInt(colorURI.segment(2));
                return Color.rgb((int)red, (int)green, (int)blue);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse color values " + colorURI + ". " + e.getMessage());
            }
        }
        return null;
    }

    static String cssColorFromObject(@Nullable Object object) {
        URI colorURI = AdapterFactoryCellFactory.toColorURI(object);
        if (colorURI != null) {
            return "rgb(" + colorURI.segment(0) + ", " + colorURI.segment(1) + ", " + colorURI.segment(2) + ")";
        }
        return null;
    }

    static URI toColorURI(@Nullable Object object) {
        if (object instanceof URI) {
            URI colorURI = (URI)object;
            if (!"color".equals(colorURI.scheme())) {
                throw new IllegalArgumentException("Only 'color' scheme is recognized " + colorURI);
            }
            if (!"rgb".equals(colorURI.authority())) {
                throw new IllegalArgumentException("Only 'rgb' authority is recognized " + colorURI);
            }
            if (colorURI.segmentCount() != 3) {
                throw new IllegalArgumentException("Color must have 3 segments (r, g, b) " + colorURI);
            }
            return colorURI;
        }
        return null;
    }

    public static interface ICellCreationListener {
        public void cellCreated(Cell<?> var1);
    }

    public static interface ICellEditHandler {
        public boolean canEdit(Cell<?> var1);

        public void startEdit(Cell<?> var1);

        public void commitEdit(Cell<?> var1, Object var2);

        public void cancelEdit(Cell<?> var1);
    }

    public static interface ICellUpdateListener {
        public void updateItem(Cell<?> var1, Object var2, boolean var3);
    }
}

