/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.references;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.AnyTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ArrayTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.InnerFunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.InnerTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnknownTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class StandardTypeReferenceOwner
implements ITypeReferenceOwner {
    private final CommonTypeComputationServices services;
    private final ResourceSet context;
    private LightweightTypeReferenceFactory factory;

    public StandardTypeReferenceOwner(CommonTypeComputationServices services, ResourceSet context) {
        this.services = services;
        this.context = context;
        this.factory = new LightweightTypeReferenceFactory(this);
    }

    public StandardTypeReferenceOwner(CommonTypeComputationServices services, EObject context) {
        this(services, context.eResource());
    }

    public StandardTypeReferenceOwner(CommonTypeComputationServices services, Resource context) {
        this(services, context.getResourceSet());
    }

    @Override
    public CommonTypeComputationServices getServices() {
        return this.services;
    }

    public LightweightTypeReferenceFactory getFactory() {
        return this.factory;
    }

    public void setFactory(LightweightTypeReferenceFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.factory = factory;
    }

    @Override
    public ResourceSet getContextResourceSet() {
        return this.context;
    }

    @Override
    public void acceptHint(Object handle, LightweightBoundTypeArgument boundTypeArgument) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LightweightBoundTypeArgument> getAllHints(Object handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isResolved(Object handle) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public LightweightTypeReference toPlainTypeReference(JvmType type) {
        return this.factory.toPlainTypeReference(type);
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmType type) {
        return this.factory.toLightweightReference(type);
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference type) {
        return this.factory.toLightweightReference(type);
    }

    @Override
    public CompoundTypeReference newCompoundTypeReference(boolean synonym) {
        return new CompoundTypeReference(this, synonym);
    }

    @Override
    public WildcardTypeReference newWildcardTypeReference() {
        return new WildcardTypeReference(this);
    }

    @Override
    public ArrayTypeReference newArrayTypeReference(LightweightTypeReference componentTypeReference) {
        return new ArrayTypeReference(this, componentTypeReference);
    }

    @Override
    public FunctionTypeReference newFunctionTypeReference(JvmType type) {
        FunctionTypeReference result;
        if (this.factory.isInner(type)) {
            ParameterizedTypeReference outer = this.newParameterizedTypeReference((JvmType)((JvmDeclaredType)type.eContainer()));
            result = new InnerFunctionTypeReference(this, outer, type);
        } else {
            result = new FunctionTypeReference(this, type);
        }
        return result;
    }

    @Override
    public InnerFunctionTypeReference newFunctionTypeReference(LightweightTypeReference outer, JvmType type) {
        if (!this.factory.isInner(type)) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        return new InnerFunctionTypeReference(this, outer, type);
    }

    @Override
    public ParameterizedTypeReference newParameterizedTypeReference(JvmType type) {
        ParameterizedTypeReference result;
        if (this.factory.isInner(type)) {
            ParameterizedTypeReference outer = this.newParameterizedTypeReference((JvmType)((JvmDeclaredType)type.eContainer()));
            result = new InnerTypeReference(this, outer, type);
        } else {
            result = new ParameterizedTypeReference(this, type);
        }
        return result;
    }

    @Override
    public InnerTypeReference newParameterizedTypeReference(LightweightTypeReference outer, JvmType type) {
        if (!this.factory.isInner(type)) {
            throw new IllegalArgumentException(String.valueOf(type));
        }
        return new InnerTypeReference(this, outer, type);
    }

    @Override
    public UnknownTypeReference newUnknownTypeReference() {
        return new UnknownTypeReference(this);
    }

    @Override
    public UnknownTypeReference newUnknownTypeReference(String name) {
        return new UnknownTypeReference(this, name);
    }

    @Override
    public AnyTypeReference newAnyTypeReference() {
        return new AnyTypeReference(this);
    }
}

