/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Pagination;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.bindings.FXBindings;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.BaseStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragSourceWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPopupMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.DnDSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.PaginationItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DefStackRenderer
extends BaseStackRenderer<Node, Object, Node> {
    protected Class<? extends WStack<Node, Object, Node>> getWidgetClass(MPartStack stack) {
        if (stack.getTags().contains("fx_pagination")) {
            return PaginationWidgetImpl.class;
        }
        if (stack.getTags().contains("fx_stackpane")) {
            return StackPaneWidgetImpl.class;
        }
        return StackWidgetImpl.class;
    }

    static class PaginationWidgetImpl
    extends WLayoutedWidgetImpl<Node, Node, MPartStack>
    implements WStack<Node, Object, Node> {
        @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items = new ArrayList<WStack.WStackItem<Object, Node>>();
        @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
        WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback;
        private final @NonNull MPartStack domainElement;

        @Inject
        public PaginationWidgetImpl(@Named(value="fx.rendering.domElement") @NonNull MPartStack domainElement) {
            this.domainElement = domainElement;
        }

        public void setMinMaxCallback(WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback) {
        }

        public void setMinMaxState(WMinMaxableWidget.WMinMaxState state) {
        }

        public Class<? extends WStack.WStackItem<Object, Node>> getStackItemClass() {
            return PagninationItemImpl.class;
        }

        @Override
        public Pagination getWidget() {
            return (Pagination)super.getWidget();
        }

        public void addItem(WStack.WStackItem<Object, Node> item) {
            this.items.add(item);
            this.getWidget().setPageCount(this.items.size());
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.items.addAll(items);
            this.getWidget().setPageCount(this.items.size());
        }

        public void addItems(int index, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.items.addAll(index, items);
            this.getWidget().setPageCount(this.items.size());
        }

        public void selectItem(int idx) {
            this.getWidget().setCurrentPageIndex(idx);
        }

        public int indexOf(WStack.WStackItem<Object, Node> item) {
            return this.items.indexOf(item);
        }

        public List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> getItems() {
            return this.items;
        }

        public void removeItems(List<WStack.WStackItem<Object, Node>> items) {
            this.items.removeAll(items);
            this.getWidget().setPageCount(this.items.size());
        }

        public void setMouseSelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> selectedItemCallback) {
            this.mouseSelectedItemCallback = selectedItemCallback;
        }

        public void setKeySelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> selectedItemCallback) {
        }

        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public Node getWidgetNode() {
            Pagination widget = this.getWidget();
            if (this.domainElement.getTags().contains("fx_scrollable")) {
                ScrollPane scroll = new ScrollPane((Node)widget);
                scroll.setFitToWidth(true);
                scroll.setFitToHeight(true);
                widget = scroll;
            }
            return widget;
        }

        @Override
        protected Pagination createWidget() {
            Pagination p = new Pagination();
            p.setPageFactory((Callback)new Callback<Integer, Node>(){

                public Node call(Integer param) {
                    PaginationItem nativeItem;
                    PagninationItemImpl item = (PagninationItemImpl)items.get(param);
                    item.handleSelection();
                    WCallback<WStack.WStackItem<Object, Node>, Void> cb = mouseSelectedItemCallback;
                    if (cb != null) {
                        cb.call((Object)item);
                    }
                    if ((nativeItem = item.getNativeItem()) != null) {
                        return nativeItem.getContent();
                    }
                    return null;
                }
            });
            p.currentPageIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    PagninationItemImpl item = (PagninationItemImpl)items.get(newValue.intValue());
                    WCallback<WStack.WStackItem<Object, Node>, Void> cb = mouseSelectedItemCallback;
                    if (cb != null) {
                        cb.call((Object)item);
                    }
                }
            });
            return p;
        }

        public void setDragStartCallback(@NonNull WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStackCallback) {
        }
    }

    static class PagninationItemImpl
    implements WStack.WStackItem<Object, Node> {
        private WCallback<WStack.WStackItem<Object, Node>, Node> initCallback;
        private PaginationItem item = new PaginationItem();
        private MStackElement domElement;

        PagninationItemImpl() {
        }

        void handleSelection() {
            if (this.initCallback != null) {
                this.item.setContent((Node)this.initCallback.call((Object)this));
                this.initCallback = null;
            }
        }

        public PaginationItem getNativeItem() {
            return this.item;
        }

        public void setDomElement(MStackElement domElement) {
            this.domElement = domElement;
        }

        public MStackElement getDomElement() {
            return this.domElement;
        }

        public void setInitCallback(WCallback<WStack.WStackItem<Object, Node>, Node> callback) {
            this.initCallback = callback;
        }

        public void setOnCloseCallback(WCallback<WStack.WStackItem<Object, Node>, Boolean> callback) {
        }

        @PreDestroy
        public void dispose() {
            this.initCallback = null;
        }
    }

    static class StackItemImpl
    implements WStack.WStackItem<Object, Node> {
        Tab tab;
        private WCallback<WStack.WStackItem<Object, Node>, Node> initCallback;
        WCallback<WStack.WStackItem<Object, Node>, Boolean> closeCallback;
        private MStackElement domElement;
        @Inject
        private GraphicsLoader graphicsLoader;
        @Inject
        private EModelService modelService;
        @Inject
        IPresentationEngine engine;
        private String label;
        private boolean dirty;
        private ObjectProperty<org.eclipse.fx.core.URI> iconUri = new SimpleObjectProperty((Object)this, "iconUri", null);

        @Inject
        public StackItemImpl(@Named(value="localizedLabel") @Optional String label, @Named(value="dirty") @Optional boolean dirty) {
            this.label = label;
            this.dirty = dirty;
        }

        @PostConstruct
        void init() {
            this.getWidget();
        }

        public void setDomElement(MStackElement domElement) {
            this.domElement = domElement;
            if (this.domElement instanceof MPart) {
                ((MPart)this.domElement).getMenus().stream().filter(m -> m instanceof MPopupMenu).filter(m -> m.getTags().contains("tabmenu")).findFirst().map(m -> (ContextMenu)((WPopupMenu)this.engine.createGui((MUIElement)m, null, this.modelService.getContainingContext((MUIElement)domElement.getParent()))).getWidget()).ifPresent(arg_0 -> ((Tab)this.getWidget()).setContextMenu(arg_0));
            } else {
                this.getWidget().setContextMenu(null);
            }
        }

        public MStackElement getDomElement() {
            return this.domElement;
        }

        protected Tab getWidget() {
            if (this.tab == null) {
                this.tab = this.createWidget();
            }
            this.tab.setUserData((Object)this);
            return this.tab;
        }

        protected Tab createWidget() {
            Tab t = new Tab();
            t.setOnCloseRequest(this::handleOnCloseRequest);
            return t;
        }

        private void handleOnCloseRequest(Event event) {
            if (((Boolean)this.closeCallback.call((Object)this)).booleanValue()) {
                event.consume();
            }
        }

        void handleSelection() {
            if (this.initCallback != null) {
                this.tab.setContent((Node)this.initCallback.call((Object)this));
                this.initCallback = null;
            }
            if (WLayoutedWidgetImpl.OPTIMIZED_STACK_LAYOUT) {
                if (this.tab.getContent() instanceof Parent) {
                    this.domElement.getParent().setSelectedElement((MUIElement)this.domElement);
                    ((Parent)this.tab.getContent()).requestLayout();
                } else {
                    this.tab.getTabPane().requestLayout();
                }
            }
        }

        public void setInitCallback(WCallback<WStack.WStackItem<Object, Node>, Node> initCallback) {
            this.initCallback = initCallback;
        }

        public Tab getNativeItem() {
            return this.getWidget();
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") @Optional String label) {
            this.label = label;
            this.getWidget().setText(this.dirty ? "*" + StackItemImpl.notNull(label) : StackItemImpl.notNull(label));
        }

        @Inject
        public void setTooltip(@Named(value="localizedTooltip") @Optional String tooltip) {
            if (tooltip != null && !tooltip.isEmpty()) {
                this.getWidget().setTooltip(new Tooltip(tooltip));
            } else {
                this.getWidget().setTooltip(null);
            }
        }

        @Inject
        public void setCloseable(@Named(value="closeable") @Optional boolean closeable) {
            this.getWidget().setClosable(closeable);
        }

        @Inject
        public void setIcon(@Named(value="iconURI") @Optional String iconUri) {
            if (!Strings.isNullOrEmpty((String)iconUri)) {
                EMFUri uri = new EMFUri(URI.createURI((String)iconUri));
                this.iconUri.set((Object)uri);
                this.getWidget().setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)uri));
            } else {
                this.iconUri.set(null);
                this.getWidget().setGraphic(null);
            }
        }

        @Inject
        public void setDirty(@Named(value="dirty") @Optional boolean dirty) {
            this.dirty = dirty;
            this.getWidget().setText(dirty ? "*" + StackItemImpl.notNull(this.label) : StackItemImpl.notNull(this.label));
        }

        public void setOnCloseCallback(WCallback<WStack.WStackItem<Object, Node>, Boolean> callback) {
            this.closeCallback = callback;
        }

        private static String notNull(String s) {
            return s == null ? "" : s;
        }

        @PreDestroy
        public void dispose() {
            this.initCallback = null;
            this.closeCallback = null;
            this.graphicsLoader = null;
            this.tab.setOnCloseRequest(null);
            this.tab = null;
        }
    }

    static class StackPaneItemImpl
    implements WStack.WStackItem<Object, Node> {
        private WCallback<WStack.WStackItem<Object, Node>, Node> initCallback;
        private StackPane internalPane = new StackPane();
        private MStackElement domElement;

        StackPaneItemImpl() {
        }

        void handleSelection() {
            if (this.initCallback != null) {
                this.internalPane.getChildren().add((Object)((Node)this.initCallback.call((Object)this)));
                this.initCallback = null;
            }
        }

        public Node getNativeItem() {
            return this.internalPane;
        }

        public void setDomElement(MStackElement domElement) {
            this.domElement = domElement;
        }

        public MStackElement getDomElement() {
            return this.domElement;
        }

        public void setInitCallback(WCallback<WStack.WStackItem<Object, Node>, Node> callback) {
            this.initCallback = callback;
        }

        public void setOnCloseCallback(WCallback<WStack.WStackItem<Object, Node>, Boolean> callback) {
        }

        @PreDestroy
        public void dispose() {
            this.initCallback = null;
        }
    }

    static class StackPaneWidgetImpl
    extends WLayoutedWidgetImpl<Node, Node, MPartStack>
    implements WStack<Node, Object, Node> {
        @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items = new ArrayList<WStack.WStackItem<Object, Node>>();
        @Nullable WCallback<// Could not load outer class - annotation placement on inner may be incorrect
        WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback;
        private final @NonNull MPartStack domainElement;

        @Inject
        public StackPaneWidgetImpl(@Named(value="fx.rendering.domElement") @NonNull MPartStack domainElement) {
            this.domainElement = domainElement;
        }

        public void setMinMaxCallback(WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback) {
        }

        public void setMinMaxState(WMinMaxableWidget.WMinMaxState state) {
        }

        public Class<? extends WStack.WStackItem<Object, Node>> getStackItemClass() {
            return StackPaneItemImpl.class;
        }

        @Override
        public StackPane getWidget() {
            return (StackPane)super.getWidget();
        }

        private void addChildNode(WStack.WStackItem<Object, Node> item) {
            this.addStackPaneItem((StackPaneItemImpl)item);
        }

        public void addItem(WStack.WStackItem<Object, Node> item) {
            this.items.add(item);
            this.addChildNode(item);
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.items.addAll(items);
            items.stream().map(item -> (StackPaneItemImpl)item).forEach(this::addStackPaneItem);
        }

        public void addItems(int index, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.items.addAll(index, items);
            List<Node> collect = items.stream().map(item -> (StackPaneItemImpl)item).filter(item -> item.getNativeItem() != null).map(StackPaneItemImpl::getNativeItem).collect(Collectors.toList());
            collect.forEach(node -> {
                node.setVisible(false);
                node.setManaged(false);
            });
            this.getWidget().getChildren().addAll(index, collect);
        }

        private void addStackPaneItem(StackPaneItemImpl item) {
            Node node = item.getNativeItem();
            if (node != null) {
                node.setVisible(false);
                node.setManaged(false);
                this.getWidget().getChildren().add((Object)node);
            }
        }

        public void selectItem(int idx) {
            int index;
            int n = index = idx == -1 ? 0 : idx;
            if (this.items.size() > index) {
                StackPaneItemImpl item = (StackPaneItemImpl)this.items.get(index);
                item.handleSelection();
                this.getWidget().getChildren().forEach(node -> {
                    node.setVisible(false);
                    node.setManaged(false);
                });
                Node node2 = (Node)this.getWidget().getChildren().get(index);
                node2.setVisible(true);
                node2.setManaged(true);
            }
        }

        public int indexOf(WStack.WStackItem<Object, Node> item) {
            return this.items.indexOf(item);
        }

        public List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> getItems() {
            return this.items;
        }

        public void removeItems(List<WStack.WStackItem<Object, Node>> items) {
            this.items.removeAll(items);
        }

        public void setMouseSelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> selectedItemCallback) {
            this.mouseSelectedItemCallback = selectedItemCallback;
        }

        public void setKeySelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> selectedItemCallback) {
        }

        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public Node getWidgetNode() {
            StackPane widget = this.getWidget();
            if (this.domainElement.getTags().contains("fx_scrollable")) {
                ScrollPane scroll = new ScrollPane((Node)widget);
                scroll.setFitToWidth(true);
                scroll.setFitToHeight(true);
                widget = scroll;
            }
            return widget;
        }

        @Override
        protected StackPane createWidget() {
            return new StackPane();
        }

        public void setDragStartCallback(@NonNull WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStackCallback) {
        }
    }

    static class StackWidgetImpl
    extends WLayoutedWidgetImpl<Node, Node, MPartStack>
    implements WStack<Node, Object, Node> {
        WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback;
        WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback;
        WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStartCallback;
        private WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback;
        boolean inKeyTraversal;
        @Inject
        @NonNull DnDFeedbackService dndFeedback;
        @Inject
        @Optional
        @Nullable DnDService dndService;
        @Inject
        @NonNull ModelService modelService;
        @Inject
        GraphicsLoader graphicsLoader;
        private final @NonNull MPartStack domainElement;
        private BorderPane pane;
        private Label titleLabel;

        @Inject
        public StackWidgetImpl(@Named(value="fx.rendering.domElement") @NonNull MPartStack domainElement) {
            this.domainElement = domainElement;
        }

        @Override
        protected Pane createStaticPane() {
            return new StackPane(){

                protected void layoutChildren() {
                    super.layoutChildren();
                }
            };
        }

        public void setMouseSelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback) {
            this.mouseSelectedItemCallback = mouseSelectedItemCallback;
        }

        public void setKeySelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback) {
            this.keySelectedItemCallback = keySelectedItemCallback;
        }

        @Override
        public TabPane getWidget() {
            return (TabPane)super.getWidget();
        }

        public int indexOf(WStack.WStackItem<Object, Node> item) {
            return this.getWidget().getTabs().indexOf(item.getNativeItem());
        }

        public int getItemCount() {
            return this.getWidget().getTabs().size();
        }

        public void setMinMaxCallback(WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback) {
            this.minMaxCallback = minMaxCallback;
        }

        public void setMinMaxState(WMinMaxableWidget.WMinMaxState state) {
        }

        @Override
        protected TabPane createWidget() {
            Side v;
            DnDSupport dnd = new DnDSupport((WCallback<Void, WCallback<WDragSourceWidget.DragData, Boolean>>)((WCallback)param -> this.dragStartCallback), (WCallback<Void, WCallback<WDragTargetWidget.DropData, Void>>)((WCallback)param -> this.getDropDroppedCallback()), this.dndFeedback, this.domainElement, this.dndService, this.modelService);
            TabPane p = DndTabPaneFactory.createDndTabPane(s -> {
                s.setStartFunction(dnd::handleDragStart);
                s.setDropConsumer(dnd::handleDropped);
                s.setFeedbackConsumer(dnd::handleFeedback);
                s.setDragFinishedConsumer(dnd::handleFinished);
                s.setClipboardDataFunction(dnd::clipboardDataFunction);
            }, (boolean)DnDSupport.DETACHABLE_DRAG);
            String location = (String)this.domainElement.getPersistedState().get("fx.stack.tabslocation");
            if (location != null && (v = Side.valueOf((String)location)) != null) {
                p.setSide(v);
            }
            p.setOnMouseClicked(e -> {
                if (e.getClickCount() > 1 && this.minMaxCallback != null) {
                    p.getChildrenUnmodifiable().stream().filter(n -> n.getStyleClass().contains((Object)"tab-header-area")).findFirst().ifPresent(node -> {
                        if (node.localToScene(node.getBoundsInLocal()).contains(e.getSceneX(), e.getSceneY())) {
                            this.minMaxCallback.call((Object)WMinMaxableWidget.WMinMaxState.TOGGLE);
                        }
                    });
                }
            });
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_allTabs")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_unavailable")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_selectedTab")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.SELECTED_TAB);
            }
            p.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = true;
                }
            });
            p.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = false;
                }
            });
            p.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){
                boolean inUpdate;

                public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                    if (titleLabel != null) {
                        titleLabel.textProperty().unbind();
                        titleLabel.graphicProperty().unbind();
                        titleLabel.setGraphic(null);
                        titleLabel.setText(null);
                        if (newValue != null) {
                            StackItemImpl d = (StackItemImpl)newValue.getUserData();
                            titleLabel.graphicProperty().bind((ObservableValue)FXBindings.map((ObservableValue)d.iconUri, u -> graphicsLoader.getGraphicsNode(u)));
                            titleLabel.textProperty().bind((ObservableValue)newValue.textProperty());
                        }
                    }
                    if (newValue == null || this.getWidgetState() != WWidget.WidgetState.CREATED && this.getWidgetState() != WWidget.WidgetState.IN_SETUP) {
                        return;
                    }
                    final StackItemImpl w = (StackItemImpl)newValue.getUserData();
                    w.handleSelection();
                    final WCallback<WStack.WStackItem<Object, Node>, Void> cb = !inKeyTraversal ? mouseSelectedItemCallback : keySelectedItemCallback;
                    if (cb != null) {
                        if (w.tab.getContent() != null && !w.tab.getContent().isVisible()) {
                            w.tab.getContent().visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                    w.tab.getContent().visibleProperty().removeListener((ChangeListener)this);
                                    if (newValue.booleanValue()) {
                                        cb.call((Object)w);
                                    }
                                }
                            });
                        } else if (w.tab.getContent() == null || w.tab.getContent().getScene() != null) {
                            if (!this.inUpdate) {
                                this.inUpdate = true;
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.call((Object)w);
                                        inUpdate = false;
                                    }
                                });
                            } else {
                                logger.debug("An endless activation update has been blocked!");
                            }
                        } else {
                            cb.call((Object)w);
                        }
                    }
                }
            });
            return p;
        }

        @Override
        public BorderPane getWidgetNode() {
            if (this.pane == null) {
                this.pane = new BorderPane();
                if (this.domainElement.getTags().contains("showTopTrimArea")) {
                    HBox box = new HBox();
                    box.getStyleClass().add((Object)"tool-bar");
                    this.titleLabel = new Label();
                    box.getChildren().add((Object)this.titleLabel);
                    this.pane.setTop((Node)box);
                }
                TabPane widget = this.getWidget();
                if (this.domainElement.getTags().contains("fx_scrollable")) {
                    ScrollPane scroll = new ScrollPane((Node)widget);
                    scroll.setFitToWidth(true);
                    scroll.setFitToHeight(true);
                    widget = scroll;
                }
                this.pane.setCenter((Node)widget);
            }
            return this.pane;
        }

        public Class<? extends WStack.WStackItem<Object, Node>> getStackItemClass() {
            return StackItemImpl.class;
        }

        public void addItem(WStack.WStackItem<Object, Node> item) {
            this.addItems(Collections.singletonList(item));
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.getWidget().getTabs().addAll(StackWidgetImpl.extractTabs(items));
        }

        public void addItems(int index, List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            if (index >= this.getWidget().getTabs().size()) {
                this.addItems(items);
            } else {
                this.getWidget().getTabs().addAll(index, StackWidgetImpl.extractTabs(items));
            }
        }

        private static final List<Tab> extractTabs(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Tab> tabs = new ArrayList<Tab>(items.size());
            for (WStack.WStackItem<Object, Node> t : items) {
                tabs.add((Tab)t.getNativeItem());
            }
            return tabs;
        }

        public void selectItem(int idx) {
            this.getWidget().getSelectionModel().select(idx);
        }

        public List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> getItems() {
            ArrayList<WStack.WStackItem> rv = new ArrayList<WStack.WStackItem>();
            for (Tab t : this.getWidget().getTabs()) {
                WStack.WStackItem i = (WStack.WStackItem)t.getUserData();
                if (i == null) continue;
                rv.add(i);
            }
            return Collections.unmodifiableList(rv);
        }

        public void removeItems(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (WStack.WStackItem<Object, Node> i : items) {
                l.add(i.getNativeItem());
            }
            this.getWidget().getTabs().removeAll(l);
        }

        public void setDragStartCallback(@NonNull WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStackCallback) {
            this.dragStartCallback = dragStackCallback;
        }
    }
}

