/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.field;

import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.eclipse.jdt.internal.core.nd.field.BaseField;

public class FieldShort
extends BaseField {
    private final ModificationLog.Tag putTag;

    public FieldShort(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.putTag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public short get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getShort(address + (long)this.offset);
    }

    public void put(Nd nd, long address, short newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.putTag);
        try {
            nd.getDB().putShort(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.putTag);
        }
    }

    @Override
    public int getRecordSize() {
        return 2;
    }
}

