/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.jet.JETSkeleton;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JETCompileTemplateOperation
implements IWorkspaceRunnable {
    protected static final String JET_EXTENSION = "jet";
    protected IProject project;
    protected Collection<?> containers;
    protected List<Object> files = new ArrayList<Object>();
    protected boolean inBuild;

    public JETCompileTemplateOperation(IProject project, Collection<?> containers) throws CoreException {
        this.project = project;
        this.containers = containers;
        for (Object container : containers) {
            if (container instanceof IContainer) {
                this.consider((IContainer)container);
                continue;
            }
            this.consider(container.toString());
        }
    }

    public JETCompileTemplateOperation(IProject project, Collection<?> containers, Collection<?> resources) throws CoreException {
        this.project = project;
        this.containers = containers;
        block0: for (Object object : resources) {
            if (object instanceof IFile) {
                IFile file = (IFile)object;
                IContainer container = file.getParent();
                while (container != null) {
                    if (containers.contains(container)) {
                        this.consider(file);
                        continue block0;
                    }
                    container = container.getParent();
                }
                continue;
            }
            if (!(object instanceof IContainer)) continue;
            IContainer container = (IContainer)object;
            while (container != null) {
                if (containers.contains(container)) {
                    this.consider(container);
                    continue block0;
                }
                container = container.getParent();
            }
        }
    }

    public boolean shouldCompile() {
        return !this.files.isEmpty();
    }

    protected void consider(String uri) {
        URI baseURI = URI.createURI((String)uri);
        URI localURI = CommonPlugin.asLocalURI((URI)baseURI);
        if (localURI.isFile() && !localURI.isRelative()) {
            File file = new File(localURI.toFileString());
            if (file.isDirectory() && !uri.endsWith("/")) {
                baseURI = URI.createURI((String)(String.valueOf(uri) + "/"));
            }
            this.consider(baseURI, localURI, new File(localURI.toFileString()));
        }
    }

    protected void consider(URI baseURI, URI localURI, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.consider(baseURI, localURI, files[i]);
                ++i;
            }
        } else if (file.isFile() && file.getName().endsWith(JET_EXTENSION) && file.getName().indexOf(46) != -1) {
            this.files.add(URI.createFileURI((String)file.getAbsolutePath()).deresolve(localURI).resolve(baseURI));
        }
    }

    protected void consider(IFile file) {
        if (file.getFileExtension() != null && file.getFileExtension().endsWith(JET_EXTENSION)) {
            this.files.add(file);
        }
    }

    protected void consider(IContainer container) throws CoreException {
        IResource[] children;
        if (container.isAccessible() && (children = container.members()) != null) {
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource instanceof IFile) {
                    this.consider((IFile)resource);
                } else if (resource instanceof IContainer) {
                    this.consider((IContainer)resource);
                }
                ++i;
            }
        }
    }

    public void run(IProgressMonitor progressMonitor) throws CoreException {
        try {
            try {
                progressMonitor.beginTask("", 3 * this.files.size());
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompilingTemplates_message"));
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                HashSet<IProject> jetProjects = new HashSet<IProject>();
                HashSet<String> visitedRelativePaths = new HashSet<String>();
                block9: for (Object file : this.files) {
                    String fileName = file instanceof IFile ? ((IFile)file).getName() : file.toString();
                    progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETCompile_message", new Object[]{fileName}));
                    JETNature nature = JETNature.getRuntime(this.project);
                    IContainer directory = nature.getJavaSourceContainer();
                    if (!directory.exists()) {
                        this.project.getFolder(directory.getProjectRelativePath()).create(true, true, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    }
                    Path filePath = file instanceof IFile ? ((IFile)file).getFullPath() : new Path(file.toString());
                    List<Object> templateContainers = nature.getTemplateContainers();
                    List<Object> templateSourceContainers = nature.getTemplateSourceContainers();
                    String[] containerLocations = new String[templateContainers.size()];
                    ListIterator<Object> j = templateContainers.listIterator();
                    while (j.hasNext()) {
                        Object container = j.next();
                        containerLocations[j.previousIndex()] = container instanceof IContainer ? URI.createPlatformResourceURI((String)((IContainer)container).getFullPath().toString(), (boolean)true).toString() : container.toString();
                    }
                    for (Object container : templateSourceContainers) {
                        byte[] bytes;
                        String relativePath;
                        Path containerPath;
                        Object object = containerPath = container instanceof IContainer ? ((IContainer)container).getFullPath() : new Path(container.toString());
                        if (!containerPath.isPrefixOf((IPath)filePath) || !visitedRelativePaths.add(relativePath = filePath.removeFirstSegments(containerPath.segmentCount()).setDevice(null).toString())) continue;
                        JETCompiler compiler = new JETCompiler(containerLocations, relativePath);
                        compiler.parse();
                        StringWriter stringWriter = new StringWriter();
                        compiler.generate(stringWriter);
                        JETSkeleton skeleton = compiler.getSkeleton();
                        if (skeleton.getClassName().equals("")) {
                            skeleton.setClassName(fileName.substring(0, fileName.indexOf(46)));
                        }
                        if (skeleton.getPackageName() != null) {
                            directory = this.getPackageContainer(directory, skeleton.getPackageName(), (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                        } else {
                            progressMonitor.worked(1);
                        }
                        IFile outputFile = workspaceRoot.getFile(directory.getFullPath().append(String.valueOf(skeleton.getClassName()) + ".java"));
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETUpdate_message", new Object[]{fileName}));
                        String encoding = outputFile.getCharset();
                        String result = JETCompileTemplateOperation.convertLineDelimiters(outputFile, stringWriter.getBuffer().toString());
                        try {
                            bytes = encoding == null ? result.getBytes() : result.getBytes(encoding);
                        }
                        catch (UnsupportedEncodingException exception) {
                            bytes = result.getBytes();
                        }
                        if (!outputFile.exists()) {
                            outputFile.create((InputStream)new ByteArrayInputStream(bytes), true, progressMonitor);
                        } else {
                            boolean changed = true;
                            try {
                                InputStream inputStream = outputFile.getContents();
                                byte[] oldBytes = new byte[inputStream.available()];
                                inputStream.read(oldBytes);
                                inputStream.close();
                                changed = !Arrays.equals(oldBytes, bytes);
                            }
                            catch (IOException inputStream) {
                                // empty catch block
                            }
                            if (changed) {
                                IStatus status;
                                if (outputFile.isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{outputFile}, null)).isOK()) {
                                    throw new CoreException(status);
                                }
                                outputFile.setContents((InputStream)new ByteArrayInputStream(bytes), true, true, progressMonitor);
                            }
                        }
                        jetProjects.add(outputFile.getProject());
                        progressMonitor.worked(1);
                        continue block9;
                    }
                }
                if (!this.isInBuild()) {
                    for (IProject project : jetProjects) {
                        progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_JETJavaCompileProject_message", new Object[]{project.getFullPath()}));
                        project.build(10, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    }
                }
            }
            catch (JETException exception) {
                throw DiagnosticException.toCoreException((DiagnosticException)exception);
            }
        }
        finally {
            progressMonitor.done();
        }
    }

    private static String convertLineDelimiters(IFile file, String text) {
        IProject project = file.getProject();
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(project), new InstanceScope()});
        return text.replaceAll("\r?\n", lineDelimiter);
    }

    protected IContainer getPackageContainer(IContainer root, String packagename, IProgressMonitor monitor) throws CoreException {
        StringTokenizer stringTokenizer = new StringTokenizer(packagename, ".");
        while (stringTokenizer.hasMoreTokens()) {
            IFolder newContainer = root.getFolder((IPath)new Path(stringTokenizer.nextToken()));
            if (!newContainer.exists()) {
                newContainer.create(true, true, monitor);
            }
            root = newContainer;
        }
        return root;
    }

    public boolean isInBuild() {
        return this.inBuild;
    }

    public void setInBuild(boolean build) {
        this.inBuild = build;
    }
}

