/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import org.eclipse.fx.core.bindings.FXBindings;

public class SortedBorderPane
extends BorderPane {
    private ObservableList<Node> children;
    private ObservableList<Node> positioned = new SortedList((ObservableList)new FilteredList(super.getChildren(), this::isPositioned), this::compare);
    private ObservableList<Node> unpositioned = new FilteredList(super.getChildren(), n -> !this.isPositioned((Node)n));

    public SortedBorderPane() {
        this.children = FXBindings.concat((ObservableList[])new ObservableList[]{this.positioned, this.unpositioned});
    }

    private boolean isLeft(Node node) {
        return this.getLeft() == node;
    }

    private boolean isTop(Node node) {
        return this.getTop() == node;
    }

    private boolean isRight(Node node) {
        return this.getRight() == node;
    }

    private boolean isBottom(Node node) {
        return this.getBottom() == node;
    }

    private boolean isCenter(Node node) {
        return this.getCenter() == node;
    }

    private boolean isPositioned(Node node) {
        return this.isTop(node) || this.isLeft(node) || this.isCenter(node) || this.isRight(node) || this.isBottom(node);
    }

    private int getWeight(Node node) {
        return 0 + (this.isTop(node) ? 5 : 0) + (this.isLeft(node) ? 4 : 0) + (this.isCenter(node) ? 3 : 0) + (this.isRight(node) ? 2 : 0) + (this.isBottom(node) ? 1 : 0);
    }

    private int compare(Node a, Node b) {
        return this.getWeight(b) - this.getWeight(a);
    }

    public ObservableList<Node> getChildrenUnmodifiable() {
        return this.children;
    }
}

