/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class NativeLoader {
    private static String OS = null;
    static boolean osgi = false;
    private static boolean useJavaLibraryPath = Boolean.getBoolean("driftfx.use.java.library.path");

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static boolean isWindows() {
        return NativeLoader.getOsName().toLowerCase().contains("windows");
    }

    public static boolean isLinux() {
        return NativeLoader.getOsName().toLowerCase().contains("linux");
    }

    public static boolean isMacOs() {
        return NativeLoader.getOsName().toLowerCase().contains("macos");
    }

    public static void loadLibrary(Class<?> context, String libname) {
        if (useJavaLibraryPath || osgi) {
            System.loadLibrary(libname);
        } else {
            String filename = NativeLoader.getFilename(libname);
            Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
            Path extractPath = tmpDir.resolve("driftfx").resolve(filename);
            String resourceName = "/native/" + filename;
            URL url = context.getResource(resourceName);
            System.err.println("Resource Lookup: name: " + resourceName + ", context: " + context + " => " + url);
            try (InputStream in = context.getResourceAsStream("/native/" + filename);){
                NativeLoader.extract(in, extractPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.load(extractPath.toString());
        }
    }

    private static Path extract(InputStream in, Path extractPath) throws IOException {
        long bytes;
        Files.createDirectories(extractPath.getParent(), new FileAttribute[0]);
        if (!Files.exists(extractPath, new LinkOption[0]) && (bytes = Files.copy(in, extractPath, new CopyOption[0])) == 0L) {
            throw new IOException("library has no size!");
        }
        return extractPath;
    }

    private static String getFilename(String libname) {
        if (NativeLoader.isWindows()) {
            return libname + ".dll";
        }
        if (NativeLoader.isLinux()) {
            return "lib" + libname + ".so";
        }
        if (NativeLoader.isMacOs()) {
            return "lib" + libname + ".dylib";
        }
        throw new RuntimeException("os not supported: " + NativeLoader.getOsName());
    }
}

