/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.ds.internal.annotations.Activator;
import org.eclipse.pde.ds.internal.annotations.AnnotationProcessor;
import org.eclipse.pde.ds.internal.annotations.ComponentActivationAnnotation;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationProblem;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.DSEnums;
import org.eclipse.pde.ds.internal.annotations.Debug;
import org.eclipse.pde.ds.internal.annotations.Messages;
import org.eclipse.pde.ds.internal.annotations.NameGenerator;
import org.eclipse.pde.ds.internal.annotations.ProblemReporter;
import org.eclipse.pde.ds.internal.annotations.ProjectState;
import org.eclipse.pde.ds.internal.annotations.ReferenceProcessor;
import org.eclipse.pde.ds.internal.annotations.ValidationErrorLevel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentObject;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.ds.core.IDSBundleProperties;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSDocumentFactory;
import org.eclipse.pde.internal.ds.core.IDSImplementation;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProperties;
import org.eclipse.pde.internal.ds.core.IDSProperty;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSReference;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.IDSSingleProperty;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.BundleContext;

public class AnnotationVisitor
extends ASTVisitor {
    private static final String MAP_TYPE = Map.class.getName();
    private static final String BUNDLE_CONTEXT = BundleContext.class.getName();
    private static final String DEFAULT_ACTIVATE_METHOD_NAME = "activate";
    private static final String COMPONENT_CONTEXT = "org.osgi.service.component.ComponentContext";
    private static final String COMPONENT_ANNOTATION = "org.osgi.service.component.annotations.Component";
    private static final String ACTIVATE_ANNOTATION = "org.osgi.service.component.annotations.Activate";
    private static final String MODIFIED_ANNOTATION = "org.osgi.service.component.annotations.Modified";
    private static final String DEACTIVATE_ANNOTATION = "org.osgi.service.component.annotations.Deactivate";
    private static final String REFERENCE_ANNOTATION = "org.osgi.service.component.annotations.Reference";
    private static final String COMPONENT_PROPERTY_TYPE_ANNOTATION = "org.osgi.service.component.annotations.ComponentPropertyType";
    private static final String DESIGNATE_ANNOTATION = "org.osgi.service.metatype.annotations.Designate";
    private static final Pattern PID_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*");
    private static final String ATTRIBUTE_COMPONENT_CONFIGURATION_PID = "configuration-pid";
    private static final String ATTRIBUTE_COMPONENT_REFERENCE = "reference";
    private static final String ATTRIBUTE_SERVICE_SCOPE = "scope";
    private static final String VALUE_SERVICE_SCOPE_DEFAULT = DSEnums.getServiceScope("DEFAULT");
    private static final String VALUE_SERVICE_SCOPE_SINGLETON = DSEnums.getServiceScope("SINGLETON");
    private static final String VALUE_SERVICE_SCOPE_BUNDLE = DSEnums.getServiceScope("BUNDLE");
    private static final Set<String> PROPERTY_TYPES = Set.of("String", "Long", "Double", "Float", "Integer", "Byte", "Character", "Boolean", "Short");
    private static final Map<String, String> PRIMITIVE_TYPE_MAP = Map.ofEntries(Map.entry(Long.class.getName(), "Long"), Map.entry(Double.class.getName(), "Double"), Map.entry(Float.class.getName(), "Float"), Map.entry(Integer.class.getName(), "Integer"), Map.entry(Byte.class.getName(), "Byte"), Map.entry(Character.class.getName(), "Character"), Map.entry(Boolean.class.getName(), "Boolean"), Map.entry(Short.class.getName(), "Short"), Map.entry(Long.TYPE.getName(), "Long"), Map.entry(Double.TYPE.getName(), "Double"), Map.entry(Float.TYPE.getName(), "Float"), Map.entry(Integer.TYPE.getName(), "Integer"), Map.entry(Byte.TYPE.getName(), "Byte"), Map.entry(Character.TYPE.getName(), "Character"), Map.entry(Boolean.TYPE.getName(), "Boolean"), Map.entry(Short.TYPE.getName(), "Short"));
    private static final Comparator<IDSReference> REF_NAME_COMPARATOR = Comparator.comparing(IDSReference::getReferenceName);
    private static final Debug debug = AnnotationProcessor.debug;
    private final AnnotationProcessor processor;
    private final ProjectState state;
    private final DSAnnotationVersion specVersion;
    private final ValidationErrorLevel errorLevel;
    private final Map<String, String> dsKeys;
    private final ProblemReporter problemReporter;

    public AnnotationVisitor(AnnotationProcessor processor, ProjectState state, Map<String, String> dsKeys, Set<DSAnnotationProblem> problems) {
        this.processor = processor;
        this.state = state;
        this.specVersion = state.getSpecVersion();
        this.errorLevel = state.getErrorLevel();
        this.dsKeys = dsKeys;
        this.problemReporter = new ProblemReporter(state.getErrorLevel(), problems);
    }

    public boolean visit(TypeDeclaration type) {
        if (!Modifier.isPublic((int)type.getModifiers())) {
            if (this.errorLevel.isIgnore()) {
                return false;
            }
            Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
            if (annotation != null) {
                this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notPublic, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
            }
            return true;
        }
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)type);
        if (annotation != null) {
            boolean isInterface = false;
            boolean isAbstract = false;
            boolean isNested = false;
            boolean noDefaultConstructor = false;
            boolean hasInjectableConstructor = false;
            isInterface = type.isInterface();
            if (isInterface || (isAbstract = Modifier.isAbstract((int)type.getModifiers())) || (isNested = !type.isPackageMemberTypeDeclaration() && !this.isNestedPublicStatic((AbstractTypeDeclaration)type)) || (noDefaultConstructor = !AnnotationVisitor.hasDefaultConstructor(type) && !(hasInjectableConstructor = AnnotationVisitor.hasInjectableConstructor(type, this.problemReporter)))) {
                if (!this.errorLevel.isIgnore()) {
                    if (isInterface) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_interface, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isAbstract) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_abstract, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (isNested) {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_notTopLevel, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    } else if (noDefaultConstructor) {
                        if (this.specVersion.isEqualOrHigherThan(DSAnnotationVersion.V1_4)) {
                            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_compatibleConstructor, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                        } else {
                            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_noDefaultConstructor, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                        }
                    } else {
                        this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentImplementationClass, (Object)type.getName().getIdentifier()), type.getName().getIdentifier());
                    }
                }
            } else {
                ITypeBinding typeBinding = type.resolveBinding();
                if (typeBinding == null) {
                    if (debug.isDebugging()) {
                        debug.trace(String.format("Unable to resolve binding for type: %s", type));
                    }
                } else {
                    IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                    if (annotationBinding == null) {
                        if (debug.isDebugging()) {
                            debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                        }
                    } else {
                        try {
                            this.processComponent(type, typeBinding, annotation, annotationBinding);
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_enumeration, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        Annotation annotation = this.findComponentAnnotation((AbstractTypeDeclaration)node);
        if (annotation != null) {
            this.problemReporter.reportProblem(annotation, null, NLS.bind((String)Messages.AnnotationProcessor_invalidCompImplClass_annotation, (Object)node.getName().getIdentifier()), node.getName().getIdentifier());
        }
        return true;
    }

    private Annotation findComponentAnnotation(AbstractTypeDeclaration type) {
        for (Object item : type.modifiers()) {
            if (!(item instanceof Annotation)) continue;
            Annotation annotation = (Annotation)item;
            IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
            if (annotationBinding == null) {
                if (!debug.isDebugging()) continue;
                debug.trace(String.format("Unable to resolve binding for annotation: %s", annotation));
                continue;
            }
            if (!COMPONENT_ANNOTATION.equals(annotationBinding.getAnnotationType().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private boolean isNestedPublicStatic(AbstractTypeDeclaration type) {
        AbstractTypeDeclaration parentType;
        ASTNode parent;
        if (Modifier.isStatic((int)type.getModifiers()) && (parent = type.getParent()) != null && (parent.getNodeType() == 55 || parent.getNodeType() == 81) && Modifier.isPublic((int)(parentType = (AbstractTypeDeclaration)parent).getModifiers())) {
            return parentType.isPackageMemberTypeDeclaration() || this.isNestedPublicStatic(parentType);
        }
        return false;
    }

    private void processComponent(TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding) throws CoreException {
        block15: {
            IFile oldFile;
            String implClass;
            HashMap<String, Object> params = new HashMap<String, Object>();
            IMemberValuePairBinding[] iMemberValuePairBindingArray = annotationBinding.getDeclaredMemberValuePairs();
            int n = iMemberValuePairBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
                params.put(pair.getName(), pair.getValue());
                ++n2;
            }
            String name = implClass = typeBinding.getBinaryName();
            Object value = params.get("name");
            if (value instanceof String) {
                name = (String)value;
                this.validateComponentName(annotation, name);
            }
            IPath path = IPath.fromOSString((String)this.state.getPath()).append(name).addFileExtension("xml");
            String dsKey = path.toPortableString();
            this.dsKeys.put(implClass, dsKey);
            IProject project = typeBinding.getJavaElement().getJavaProject().getProject();
            IFile file = PDEProject.getBundleRelativeFile((IProject)project, (IPath)path);
            IPath filePath = file.getFullPath();
            this.processor.verifyOutputLocation(file);
            String oldPath = this.state.getModelFile(implClass);
            if (oldPath != null && !oldPath.equals(dsKey) && !file.exists() && (oldFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)IPath.fromPortableString((String)oldPath))).exists()) {
                try {
                    oldFile.move(file.getFullPath(), true, true, null);
                }
                catch (CoreException e) {
                    Activator.log((IStatus)Status.warning((String)String.format("Unable to move model file from '%s' to '%s'.", oldPath, file.getFullPath()), (Throwable)e));
                }
            }
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            bufferManager.connect(filePath, LocationKind.IFILE, null);
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(filePath, LocationKind.IFILE);
            if (buffer.isDirty()) {
                buffer.commit(null, true);
            }
            IDocument document = buffer.getDocument();
            final DSModel dsModel = new DSModel(document, true);
            dsModel.setUnderlyingResource((IResource)file);
            dsModel.setCharset(StandardCharsets.UTF_8);
            dsModel.load();
            IDocument fDoc = document;
            dsModel.addModelChangedListener((IModelChangedListener)new IModelTextChangeListener(fDoc){
                private final IDocument document;
                private boolean changed;
                {
                    this.document = iDocument;
                }

                public void modelChanged(IModelChangedEvent event) {
                    this.changed = true;
                }

                public TextEdit[] getTextOperations() {
                    if (!this.changed) {
                        return new TextEdit[0];
                    }
                    String text = dsModel.getContents();
                    ReplaceEdit edit = new ReplaceEdit(0, this.document.getLength(), text);
                    return new TextEdit[]{edit};
                }

                public String getReadableName(TextEdit edit) {
                    return null;
                }
            });
            try {
                this.processComponent((IDSModel)dsModel, type, typeBinding, annotation, annotationBinding, params, name, implClass);
                TextEdit[] edits = dsModel.getLastTextChangeListener().getTextOperations();
                if (edits.length <= 0) break block15;
                if (debug.isDebugging()) {
                    debug.trace(String.format("Saving model: %s", file.getFullPath()));
                }
                MultiTextEdit edit = new MultiTextEdit();
                edit.addChildren(edits);
                if (buffer.isSynchronizationContextRequested()) {
                    CoreException[] ex;
                    block16: {
                        IDocument doc = document;
                        ex = new CoreException[1];
                        CountDownLatch latch = new CountDownLatch(1);
                        bufferManager.execute(() -> {
                            try {
                                this.performEdit(doc, (TextEdit)edit);
                            }
                            catch (CoreException e) {
                                coreExceptionArray[0] = e;
                            }
                            latch.countDown();
                        });
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            if (!debug.isDebugging()) break block16;
                            debug.trace("Interrupted while waiting for edits to complete on display thread.", e);
                        }
                    }
                    if (ex[0] != null) {
                        throw ex[0];
                    }
                } else {
                    this.performEdit(document, (TextEdit)edit);
                }
                buffer.commit(null, true);
            }
            finally {
                dsModel.dispose();
                bufferManager.disconnect(buffer.getLocation(), LocationKind.IFILE, null);
            }
        }
    }

    private void performEdit(IDocument document, TextEdit edit) throws CoreException {
        DocumentRewriteSession session = null;
        try {
            try {
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                LinkedModeModel.closeAllModels((IDocument)document);
                edit.apply(document);
            }
            catch (BadLocationException | MalformedTreeException e) {
                throw new CoreException(Status.error((String)"Error applying changes to component model.", (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
            throw throwable;
        }
        if (session != null) {
            ((IDocumentExtension4)document).stopRewriteSession(session);
        }
    }

    private void processComponent(IDSModel model, TypeDeclaration type, ITypeBinding typeBinding, Annotation annotation, IAnnotationBinding annotationBinding, Map<String, ?> params, String name, String implClass) {
        List<ComponentActivationAnnotation> activateFields;
        ComponentActivationAnnotation activateConstructor;
        ComponentActivationAnnotation activateMethod;
        IMethodBinding modifiedMethod;
        String modified;
        IMethodBinding deactivateMethod;
        boolean lookedForDeactivateMethod;
        HashMap<String, IDSReference> refMap;
        IDSReference[] refElements;
        ArrayList<IDSReference> references;
        IDSService service;
        IDSDocumentFactory dsFactory;
        IDSComponent component;
        DSAnnotationVersion requiredVersion;
        String[] factoryPropertyFiles;
        String[] propertyFiles;
        String[] factoryProperties;
        String[] properties;
        Object value;
        block150: {
            String deactivate;
            block148: {
                block149: {
                    IMethodBinding binding;
                    IDSReference reference4;
                    String referenceName;
                    Object fragmentElement2;
                    Expression memberValue;
                    IDSProvide[] pos;
                    Object[] configPidElems;
                    AbstractCollection services;
                    value = params.get("service");
                    if (value instanceof Object[]) {
                        Object[] elements = (Object[])value;
                        services = new LinkedHashSet(elements.length);
                        HashMap<ITypeBinding[], Integer> serviceDuplicates = this.errorLevel.isIgnore() ? null : new HashMap<ITypeBinding[], Integer>();
                        i = 0;
                        while (i < elements.length) {
                            ITypeBinding serviceType = (ITypeBinding)elements[i];
                            serviceName = serviceType.getBinaryName();
                            if (services.add(serviceName)) {
                                if (serviceDuplicates != null) {
                                    serviceDuplicates.put((ITypeBinding[])serviceName, i);
                                }
                            } else if (serviceDuplicates != null) {
                                this.problemReporter.reportProblem(annotation, "service", i, Messages.AnnotationProcessor_duplicateServiceDeclaration, new String[]{serviceName});
                                Integer pos2 = serviceDuplicates.put((ITypeBinding[])serviceName, (Integer)null);
                                if (pos2 != null) {
                                    this.problemReporter.reportProblem(annotation, "service", (int)pos2, Messages.AnnotationProcessor_duplicateServiceDeclaration, new String[]{serviceName});
                                }
                            }
                            this.validateComponentService(annotation, typeBinding, serviceType, i);
                            ++i;
                        }
                    } else {
                        ITypeBinding[] serviceTypes = typeBinding.getInterfaces();
                        services = new ArrayList(serviceTypes.length);
                        serviceName = serviceTypes;
                        int serviceType = serviceTypes.length;
                        i = 0;
                        while (i < serviceType) {
                            ITypeBinding serviceType2 = serviceName[i];
                            services.add(serviceType2.getBinaryName());
                            ++i;
                        }
                    }
                    String factory = null;
                    value = params.get("factory");
                    if (value instanceof String) {
                        factory = (String)value;
                        this.validateComponentFactory(annotation, factory);
                    }
                    Boolean serviceFactory = null;
                    value = params.get("servicefactory");
                    if (value instanceof Boolean) {
                        serviceFactory = (Boolean)value;
                        if (!this.errorLevel.isIgnore() && Boolean.TRUE.equals(serviceFactory) && services.isEmpty()) {
                            this.problemReporter.reportProblem(annotation, "servicefactory", Messages.AnnotationVisitor_invalidServiceFactory_noServices, new String[0]);
                        }
                    }
                    Boolean enabled = null;
                    value = params.get("enabled");
                    if (value instanceof Boolean) {
                        enabled = (Boolean)value;
                    }
                    Boolean immediate = null;
                    value = params.get("immediate");
                    if (value instanceof Boolean) {
                        immediate = (Boolean)value;
                        if (!this.errorLevel.isIgnore()) {
                            if (factory != null && Boolean.TRUE.equals(immediate)) {
                                this.problemReporter.reportProblem(annotation, "immediate", Messages.AnnotationVisitor_invalidFactoryComponent_immediate, new String[0]);
                            }
                            if (services.isEmpty() && Boolean.FALSE.equals(immediate)) {
                                this.problemReporter.reportProblem(annotation, "immediate", Messages.AnnotationVisitor_invalidDelayedComponent_noServices, new String[0]);
                            }
                        }
                    }
                    properties = this.collectProperties("property", params);
                    factoryProperties = this.collectProperties("factoryProperty", params);
                    propertyFiles = this.collectPropertiesFiles("properties", typeBinding, annotation, params);
                    factoryPropertyFiles = this.collectPropertiesFiles("factoryProperties", typeBinding, annotation, params);
                    String configPolicy = null;
                    value = params.get("configurationPolicy");
                    if (value instanceof IVariableBinding) {
                        IVariableBinding configPolicyBinding = (IVariableBinding)value;
                        configPolicy = DSEnums.getConfigurationPolicy(configPolicyBinding.getName());
                    } else if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                        IAnnotationBinding[] iAnnotationBindingArray = typeBinding.getAnnotations();
                        int n = iAnnotationBindingArray.length;
                        int n2 = 0;
                        block2: while (n2 < n) {
                            IAnnotationBinding typeAnnotation = iAnnotationBindingArray[n2];
                            if (DESIGNATE_ANNOTATION.equals(typeAnnotation.getAnnotationType().getQualifiedName())) {
                                IMemberValuePairBinding[] iMemberValuePairBindingArray = typeAnnotation.getDeclaredMemberValuePairs();
                                int n3 = iMemberValuePairBindingArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IMemberValuePairBinding memberValuePair = iMemberValuePairBindingArray[n4];
                                    if ("factory".equals(memberValuePair.getName())) {
                                        if (!Boolean.TRUE.equals(memberValuePair.getValue())) break block2;
                                        configPolicy = "require";
                                        break block2;
                                    }
                                    ++n4;
                                }
                                break;
                            }
                            ++n2;
                        }
                    }
                    requiredVersion = DSAnnotationVersion.V1_1;
                    String configPid = null;
                    value = params.get("configurationPid");
                    if (value instanceof String) {
                        configPid = (String)value;
                        this.validateComponentConfigPID(annotation, configPid, -1);
                        requiredVersion = DSAnnotationVersion.V1_2;
                    } else if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion) && value instanceof Object[] && (configPidElems = (Object[])value).length > 0) {
                        LinkedHashSet<String> configPids = new LinkedHashSet<String>(configPidElems.length);
                        HashMap<String, Integer> pidDuplicates = this.errorLevel.isIgnore() ? null : new HashMap<String, Integer>(configPidElems.length);
                        int i = 0;
                        Object[] objectArray = configPidElems;
                        int n = configPidElems.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Object configPidElem = objectArray[n5];
                            Object configPidStr = String.valueOf(configPidElem);
                            if ("$".equals(configPidStr)) {
                                configPidStr = name;
                            } else {
                                this.validateComponentConfigPID(annotation, (String)configPidStr, i);
                            }
                            if (configPids.add((String)configPidStr)) {
                                if (pidDuplicates != null) {
                                    pidDuplicates.put((String)configPidStr, i);
                                }
                            } else if (pidDuplicates != null) {
                                this.problemReporter.reportProblem(annotation, "configurationPid", i, Messages.AnnotationVisitor_invalidComponentConfigurationPid_duplicate, new String[0]);
                                pos = pidDuplicates.put((String)configPidStr, (Integer)null);
                                if (pos != null) {
                                    this.problemReporter.reportProblem(annotation, "configurationPid", pos.intValue(), Messages.AnnotationVisitor_invalidComponentConfigurationPid_duplicate, new String[0]);
                                }
                            }
                            ++i;
                            ++n5;
                        }
                        requiredVersion = i > 1 ? DSAnnotationVersion.V1_3 : DSAnnotationVersion.V1_2;
                        StringBuilder configPidBuf = new StringBuilder();
                        for (String configPidElem : configPids) {
                            if (configPidBuf.length() > 0) {
                                configPidBuf.append(' ');
                            }
                            configPidBuf.append(configPidElem);
                        }
                        configPid = configPidBuf.toString();
                    }
                    String serviceScope = null;
                    if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion) && (value = params.get(ATTRIBUTE_SERVICE_SCOPE)) instanceof IVariableBinding) {
                        IVariableBinding serviceScopeBinding = (IVariableBinding)value;
                        serviceScope = DSEnums.getServiceScope(serviceScopeBinding.getName());
                        if (!this.errorLevel.isIgnore()) {
                            if (services.isEmpty()) {
                                this.problemReporter.reportProblem(annotation, ATTRIBUTE_SERVICE_SCOPE, Messages.AnnotationVisitor_invalidScope_noServices, new String[0]);
                            } else if ((factory != null || Boolean.TRUE.equals(immediate)) && !serviceScope.equals(VALUE_SERVICE_SCOPE_SINGLETON)) {
                                this.problemReporter.reportProblem(annotation, ATTRIBUTE_SERVICE_SCOPE, Messages.AnnotationVisitor_invalidScope_factoryImmediate, new String[0]);
                            }
                        }
                    }
                    if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion) && serviceFactory != null && serviceScope != null && !serviceScope.equals(VALUE_SERVICE_SCOPE_DEFAULT)) {
                        if (!this.errorLevel.isIgnore() && !serviceFactory.equals(VALUE_SERVICE_SCOPE_BUNDLE.equals(serviceScope))) {
                            this.problemReporter.reportProblem(annotation, "servicefactory", -1, true, this.errorLevel, Messages.AnnotationVisitor_invalidServiceFactory_ignored, new String[0]);
                        }
                        serviceFactory = null;
                    }
                    if (!(this.errorLevel.isIgnore() || serviceFactory == null || serviceFactory.equals(Boolean.FALSE) || services.isEmpty() || factory == null && !Boolean.TRUE.equals(immediate))) {
                        this.problemReporter.reportProblem(annotation, "servicefactory", Messages.AnnotationVisitor_invalidServiceFactory_factoryImmediate, new String[0]);
                    }
                    component = model.getDSComponent();
                    if (enabled == null) {
                        this.removeAttribute((IDSObject)component, "enabled", "true");
                    } else {
                        component.setEnabled(enabled.booleanValue());
                    }
                    if (name == null) {
                        this.removeAttribute((IDSObject)component, "name", null);
                    } else {
                        component.setAttributeName(name);
                    }
                    if (factory == null) {
                        this.removeAttribute((IDSObject)component, "factory", null);
                    } else {
                        component.setFactory(factory);
                    }
                    if (immediate == null) {
                        this.removeAttribute((IDSObject)component, "immediate", null);
                    } else {
                        component.setImmediate(immediate.booleanValue());
                    }
                    if (configPolicy == null) {
                        this.removeAttribute((IDSObject)component, "configuration-policy", "optional");
                    } else {
                        component.setConfigurationPolicy(configPolicy);
                    }
                    if (configPid == null) {
                        this.removeAttribute((IDSObject)component, ATTRIBUTE_COMPONENT_CONFIGURATION_PID, null);
                    } else {
                        component.setXMLAttribute(ATTRIBUTE_COMPONENT_CONFIGURATION_PID, configPid);
                    }
                    dsFactory = model.getFactory();
                    service = component.getService();
                    if (services.isEmpty()) {
                        if (service != null) {
                            component.removeService(service);
                        }
                    } else {
                        if (service == null) {
                            service = dsFactory.createService();
                            int firstPos = Math.max(0, this.indexOfLastPropertyOrProperties(component));
                            component.addChildNode((IDocumentElementNode)service, firstPos, true);
                        }
                        if (serviceScope == null || serviceScope.equals(VALUE_SERVICE_SCOPE_DEFAULT)) {
                            this.removeAttribute((IDSObject)service, ATTRIBUTE_SERVICE_SCOPE, null);
                        } else {
                            service.setXMLAttribute(ATTRIBUTE_SERVICE_SCOPE, serviceScope);
                            requiredVersion = DSAnnotationVersion.V1_3;
                        }
                        IDSProvide[] provides = service.getProvidedServices();
                        HashMap<String, IDSProvide> provideMap = new HashMap<String, IDSProvide>(provides.length);
                        pos = provides;
                        int configPidStr = provides.length;
                        int n = 0;
                        while (n < configPidStr) {
                            IDSProvide provide = pos[n];
                            provideMap.put(provide.getInterface(), provide);
                            ++n;
                        }
                        ArrayList<IDSProvide> provideList = new ArrayList<IDSProvide>(services.size());
                        for (String serviceName : services) {
                            IDSProvide provide = (IDSProvide)provideMap.remove(serviceName);
                            if (provide == null) {
                                provide = dsFactory.createProvide();
                                provide.setInterface(serviceName);
                            }
                            provideList.add(provide);
                        }
                        int firstPos = provides.length == 0 ? -1 : service.indexOf((IDocumentElementNode)provides[0]);
                        this.removeChildren((IDSObject)service, provideMap.values());
                        this.addOrMoveChildren((IDSObject)service, provideList, firstPos);
                        if (serviceFactory == null) {
                            this.removeAttribute((IDSObject)service, "servicefactory", "false");
                        } else {
                            service.setServiceFactory(serviceFactory.booleanValue());
                        }
                    }
                    references = new ArrayList<IDSReference>();
                    HashMap<String, Annotation> referenceNames = new HashMap<String, Annotation>();
                    refElements = component.getReferences();
                    refMap = this.buildReferenceMap(refElements);
                    if (annotation.isNormalAnnotation() && DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                        for (Object annotationValue : ((NormalAnnotation)annotation).values()) {
                            MemberValuePair annotationMemberValuePair = (MemberValuePair)annotationValue;
                            if (!ATTRIBUTE_COMPONENT_REFERENCE.equals(annotationMemberValuePair.getName().getIdentifier())) continue;
                            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
                            memberValue = annotationMemberValuePair.getValue();
                            if (memberValue instanceof Annotation) {
                                annotations.add((Annotation)memberValue);
                            } else if (memberValue instanceof ArrayInitializer) {
                                for (Object memberValueElement : ((ArrayInitializer)memberValue).expressions()) {
                                    if (!(memberValueElement instanceof Annotation)) continue;
                                    annotations.add((Annotation)memberValueElement);
                                }
                            }
                            for (Annotation referenceAnnotation : annotations) {
                                IAnnotationBinding referenceAnnotationBinding = referenceAnnotation.resolveAnnotationBinding();
                                if (referenceAnnotationBinding == null) {
                                    if (!debug.isDebugging()) continue;
                                    debug.trace(String.format("Unable to resolve binding for annotation: %s", referenceAnnotation));
                                    continue;
                                }
                                String annotationName = referenceAnnotationBinding.getAnnotationType().getQualifiedName();
                                if (!REFERENCE_ANNOTATION.equals(annotationName)) continue;
                                HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                                IMemberValuePairBinding[] iMemberValuePairBindingArray = referenceAnnotationBinding.getDeclaredMemberValuePairs();
                                int n = iMemberValuePairBindingArray.length;
                                int n6 = 0;
                                while (n6 < n) {
                                    IMemberValuePairBinding pair = iMemberValuePairBindingArray[n6];
                                    annotationParams.put(pair.getName(), pair.getValue());
                                    ++n6;
                                }
                                String referenceName2 = (String)annotationParams.get("name");
                                IDSReference reference2 = refMap.remove(referenceName2);
                                if (reference2 == null) {
                                    reference2 = this.createReference(dsFactory);
                                }
                                references.add(reference2);
                                ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                requiredVersion = requiredVersion.max(referenceProcessor.processReference(reference2, typeBinding, referenceAnnotation, referenceAnnotationBinding, annotationParams, referenceNames));
                            }
                        }
                    }
                    ArrayList<ComponentActivationAnnotation> activations = new ArrayList<ComponentActivationAnnotation>();
                    if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                        memberValue = type.getFields();
                        int annotations = ((FieldDeclaration[])memberValue).length;
                        int annotationMemberValuePair = 0;
                        while (annotationMemberValuePair < annotations) {
                            FieldDeclaration field = memberValue[annotationMemberValuePair];
                            for (Object modifier : field.modifiers()) {
                                if (!(modifier instanceof Annotation)) continue;
                                Annotation fieldAnnotation = (Annotation)modifier;
                                IAnnotationBinding fieldAnnotationBinding = fieldAnnotation.resolveAnnotationBinding();
                                if (fieldAnnotationBinding == null) {
                                    if (!debug.isDebugging()) continue;
                                    debug.trace(String.format("Unable to resolve binding for annotation: %s", fieldAnnotation));
                                    continue;
                                }
                                String annotationName = fieldAnnotationBinding.getAnnotationType().getQualifiedName();
                                if (REFERENCE_ANNOTATION.equals(annotationName)) {
                                    HashMap<String, Object> annotationParams = null;
                                    for (Object fragmentElement2 : field.fragments()) {
                                        IDSReference reference3;
                                        String referenceName3;
                                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragmentElement2;
                                        IVariableBinding fieldBinding = fragment.resolveBinding();
                                        if (fieldBinding == null) {
                                            if (!debug.isDebugging()) continue;
                                            debug.trace(String.format("Unable to resolve binding for field: %s", fragment));
                                            continue;
                                        }
                                        if (annotationParams == null) {
                                            annotationParams = new HashMap<String, Object>();
                                            IMemberValuePairBinding[] iMemberValuePairBindingArray = fieldAnnotationBinding.getDeclaredMemberValuePairs();
                                            int n = iMemberValuePairBindingArray.length;
                                            int n7 = 0;
                                            while (n7 < n) {
                                                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n7];
                                                annotationParams.put(pair.getName(), pair.getValue());
                                                ++n7;
                                            }
                                        }
                                        if ((referenceName3 = (String)annotationParams.get("name")) == null) {
                                            referenceName3 = fieldBinding.getName();
                                        }
                                        if ((reference3 = refMap.remove(referenceName3)) == null) {
                                            reference3 = this.createReference(dsFactory);
                                        }
                                        references.add(reference3);
                                        ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                        DSAnnotationVersion impliedVersion = referenceProcessor.processReference(reference3, (ASTNode)field, field.getModifiers(), fieldBinding, fieldAnnotation, fieldAnnotationBinding, annotationParams, referenceNames);
                                        requiredVersion = impliedVersion.max(requiredVersion);
                                    }
                                    continue;
                                }
                                if (!ACTIVATE_ANNOTATION.equals(annotationName)) continue;
                                fragmentElement2 = field.fragments().iterator();
                                while (fragmentElement2.hasNext()) {
                                    Object fragmentElement3 = fragmentElement2.next();
                                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragmentElement3;
                                    IVariableBinding fieldBinding = fragment.resolveBinding();
                                    if (fieldBinding == null) {
                                        if (!debug.isDebugging()) continue;
                                        debug.trace(String.format("Unable to resolve binding for field: %s", fragment));
                                        continue;
                                    }
                                    if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion)) {
                                        String fieldName = fieldBinding.getName();
                                        ITypeBinding binding2 = field.getType().resolveBinding();
                                        if (AnnotationVisitor.isActivationObject(binding2)) {
                                            if (Modifier.isStatic((int)field.getModifiers())) {
                                                this.problemReporter.reportProblem(fieldAnnotation, null, Messages.AnnotationProcessor_invalidActivate_staticField, new String[0]);
                                            } else {
                                                activations.add(new ComponentActivationAnnotation(fieldName, fieldAnnotation, null, (IBinding)binding2));
                                            }
                                        } else {
                                            this.problemReporter.reportProblem(fieldAnnotation, null, Messages.AnnotationProcessor_invalidActivateField, fieldName);
                                        }
                                        requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
                                        continue;
                                    }
                                    this.problemReporter.reportProblem(fieldAnnotation, null, Messages.AnnotationProcessor_invalidActivate, new String[0]);
                                }
                            }
                            ++annotationMemberValuePair;
                        }
                    }
                    deactivate = null;
                    lookedForDeactivateMethod = false;
                    deactivateMethod = null;
                    Annotation deactivateAnnotation = null;
                    modified = null;
                    modifiedMethod = null;
                    Annotation modifiedAnnotation = null;
                    fragmentElement2 = type.getMethods();
                    int fragmentElement3 = ((MethodDeclaration[])fragmentElement2).length;
                    int annotationName = 0;
                    while (annotationName < fragmentElement3) {
                        MethodDeclaration method = fragmentElement2[annotationName];
                        for (Object modifier : method.modifiers()) {
                            if (!(modifier instanceof Annotation)) continue;
                            Annotation methodAnnotation = (Annotation)modifier;
                            IAnnotationBinding methodAnnotationBinding = methodAnnotation.resolveAnnotationBinding();
                            if (methodAnnotationBinding == null) {
                                if (!debug.isDebugging()) continue;
                                debug.trace(String.format("Unable to resolve binding for annotation: %s", methodAnnotation));
                                continue;
                            }
                            String annotationName2 = methodAnnotationBinding.getAnnotationType().getQualifiedName();
                            if (ACTIVATE_ANNOTATION.equals(annotationName2)) {
                                String activate = method.getName().getIdentifier();
                                ComponentActivationAnnotation activation = DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion) ? new ComponentActivationAnnotation(activate, methodAnnotation, method, (IBinding)method.resolveBinding()) : new ComponentActivationAnnotation(activate, methodAnnotation, null, (IBinding)this.findLifeCycleMethod(typeBinding, DEFAULT_ACTIVATE_METHOD_NAME));
                                activations.add(activation);
                                if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion) && method.isConstructor()) continue;
                                this.validateLifeCycleMethod(methodAnnotation, DEFAULT_ACTIVATE_METHOD_NAME, method);
                                continue;
                            }
                            if (DEACTIVATE_ANNOTATION.equals(annotationName2)) {
                                if (deactivate == null) {
                                    deactivate = method.getName().getIdentifier();
                                    if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                                        deactivateMethod = method.resolveBinding();
                                    }
                                    deactivateAnnotation = methodAnnotation;
                                    this.validateLifeCycleMethod(methodAnnotation, "deactivate", method);
                                    continue;
                                }
                                if (this.errorLevel.isIgnore()) continue;
                                this.problemReporter.reportProblem(methodAnnotation, null, Messages.AnnotationProcessor_duplicateDeactivateMethod, method.getName().getIdentifier());
                                if (deactivateAnnotation == null) continue;
                                this.problemReporter.reportProblem(deactivateAnnotation, null, Messages.AnnotationProcessor_duplicateDeactivateMethod, deactivate);
                                deactivateAnnotation = null;
                                continue;
                            }
                            if (MODIFIED_ANNOTATION.equals(annotationName2)) {
                                if (modified == null) {
                                    modified = method.getName().getIdentifier();
                                    if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                                        modifiedMethod = method.resolveBinding();
                                    }
                                    modifiedAnnotation = methodAnnotation;
                                    this.validateLifeCycleMethod(methodAnnotation, "modified", method);
                                    continue;
                                }
                                if (this.errorLevel.isIgnore()) continue;
                                this.problemReporter.reportProblem(methodAnnotation, null, Messages.AnnotationProcessor_duplicateModifiedMethod, method.getName().getIdentifier());
                                if (modifiedAnnotation == null) continue;
                                this.problemReporter.reportProblem(modifiedAnnotation, null, Messages.AnnotationProcessor_duplicateModifiedMethod, modified);
                                modifiedAnnotation = null;
                                continue;
                            }
                            if (!REFERENCE_ANNOTATION.equals(annotationName2)) continue;
                            IMethodBinding methodBinding = method.resolveBinding();
                            if (methodBinding == null) {
                                if (!debug.isDebugging()) continue;
                                debug.trace(String.format("Unable to resolve binding for method: %s", method));
                                continue;
                            }
                            HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                            IMemberValuePairBinding[] iMemberValuePairBindingArray = methodAnnotationBinding.getDeclaredMemberValuePairs();
                            int n = iMemberValuePairBindingArray.length;
                            int n8 = 0;
                            while (n8 < n) {
                                IMemberValuePairBinding pair = iMemberValuePairBindingArray[n8];
                                annotationParams.put(pair.getName(), pair.getValue());
                                ++n8;
                            }
                            ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                            referenceName = referenceProcessor.getReferenceName(methodBinding.getName(), annotationParams);
                            reference4 = refMap.remove(referenceName);
                            if (reference4 == null) {
                                reference4 = this.createReference(dsFactory);
                            }
                            references.add(reference4);
                            requiredVersion = requiredVersion.max(referenceProcessor.processReference(reference4, method, methodBinding, methodAnnotation, methodAnnotationBinding, annotationParams, referenceNames));
                        }
                        ++annotationName;
                    }
                    if (activations.isEmpty() && (binding = this.findLifeCycleMethod(typeBinding, DEFAULT_ACTIVATE_METHOD_NAME)) != null) {
                        ComponentActivationAnnotation activation = new ComponentActivationAnnotation(DEFAULT_ACTIVATE_METHOD_NAME, null, null, (IBinding)binding);
                        activations.add(activation);
                    }
                    activateMethod = this.validateOnlyOne(activations.stream().filter(ca -> ca.isMethod()).toList());
                    activateConstructor = this.validateOnlyOne(activations.stream().filter(ca -> ca.isConstructor()).toList());
                    activateFields = activations.stream().filter(ca -> ca.isType()).sorted(Comparator.comparing(ComponentActivationAnnotation::activate)).toList();
                    if (activateMethod == null || DEFAULT_ACTIVATE_METHOD_NAME.equals(activateMethod.activate())) {
                        this.removeAttribute((IDSObject)component, DEFAULT_ACTIVATE_METHOD_NAME, null);
                    } else {
                        component.setActivateMethod(activateMethod.activate());
                    }
                    if (activateConstructor == null || activateConstructor.parameterCount() == 0) {
                        this.removeAttribute((IDSObject)component, "init", null);
                    } else {
                        component.setXMLAttribute("init", Integer.toString(activateConstructor.parameterCount()));
                    }
                    if (activateFields.isEmpty()) {
                        this.removeAttribute((IDSObject)component, "activation-fields", null);
                    } else {
                        component.setXMLAttribute("activation-fields", activateFields.stream().map(ComponentActivationAnnotation::activate).collect(Collectors.joining(" ")));
                    }
                    if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion) && activateConstructor != null) {
                        MethodDeclaration method = activateConstructor.method();
                        List parameters = method.parameters();
                        int i = 0;
                        while (i < parameters.size()) {
                            SingleVariableDeclaration parameter = (SingleVariableDeclaration)parameters.get(i);
                            IVariableBinding variableBinding = parameter.resolveBinding();
                            Optional<Annotation> referenceAnnotation = AnnotationVisitor.annotations(parameter.modifiers()).filter(a -> AnnotationVisitor.isReferenceAnnotation(a.resolveAnnotationBinding())).findFirst();
                            if (referenceAnnotation.isEmpty()) {
                                if (!AnnotationVisitor.isActivationObject(variableBinding.getType())) {
                                    this.problemReporter.reportProblem(activateConstructor.annotation(), null, Messages.AnnotationProcessor_invalidConstructorArgument, parameter.getName().toString(), Integer.toString(i));
                                }
                            } else {
                                Annotation constructorParameterAnnotation = referenceAnnotation.get();
                                IAnnotationBinding constructorParameterAnnotationBinding = constructorParameterAnnotation.resolveAnnotationBinding();
                                if (constructorParameterAnnotationBinding == null) {
                                    if (debug.isDebugging()) {
                                        debug.trace(String.format("Unable to resolve binding for parameter: %s", parameter));
                                    }
                                } else {
                                    HashMap<String, Object> annotationParams = new HashMap<String, Object>();
                                    IMemberValuePairBinding[] iMemberValuePairBindingArray = constructorParameterAnnotationBinding.getDeclaredMemberValuePairs();
                                    int n = iMemberValuePairBindingArray.length;
                                    int reference4 = 0;
                                    while (reference4 < n) {
                                        IMemberValuePairBinding pair = iMemberValuePairBindingArray[reference4];
                                        annotationParams.put(pair.getName(), pair.getValue());
                                        ++reference4;
                                    }
                                    referenceName = (String)annotationParams.get("name");
                                    if (referenceName == null) {
                                        referenceName = variableBinding.getName();
                                    }
                                    if ((reference4 = refMap.remove(referenceName)) == null) {
                                        reference4 = this.createReference(dsFactory);
                                    }
                                    references.add(reference4);
                                    ReferenceProcessor referenceProcessor = new ReferenceProcessor(this, this.specVersion, requiredVersion, this.errorLevel, this.state.getMissingUnbindMethodLevel(), this.problemReporter);
                                    referenceProcessor.processReference(reference4, (ASTNode)parameter, parameter.getModifiers(), variableBinding, constructorParameterAnnotation, constructorParameterAnnotationBinding, annotationParams, referenceNames);
                                    reference4.setXMLAttribute("parameter", Integer.toString(i));
                                    this.removeAttribute((IDSObject)reference4, "field", null);
                                    requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
                                }
                            }
                            ++i;
                        }
                    }
                    if (deactivate != null) break block148;
                    if (!"deactivate".equals(component.getDeactivateMethod())) break block149;
                    lookedForDeactivateMethod = true;
                    if (!true || (deactivateMethod = this.findLifeCycleMethod(typeBinding, "deactivate")) != null) break block150;
                }
                this.removeAttribute((IDSObject)component, "deactivate", null);
                break block150;
            }
            component.setDeactivateMethod(deactivate);
        }
        if (modified == null) {
            this.removeAttribute((IDSObject)component, "modified", null);
        } else {
            component.setModifiedeMethod(modified);
        }
        LinkedHashMap<String, IDSProperty> newPropMap = new LinkedHashMap<String, IDSProperty>();
        if (DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
            HashSet<ITypeBinding> cptClosure = new HashSet<ITypeBinding>();
            if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion)) {
                if (activateConstructor != null) {
                    requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
                    this.collectProperties(activateConstructor.binding(), dsFactory, newPropMap, cptClosure);
                }
                for (ComponentActivationAnnotation activateField : activateFields) {
                    requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
                    this.collectProperties(activateField.binding(), dsFactory, newPropMap, cptClosure);
                }
            }
            if (activateMethod != null) {
                this.collectProperties(activateMethod.binding(), dsFactory, newPropMap, cptClosure);
            }
            if (modifiedMethod != null) {
                this.collectProperties((IBinding)modifiedMethod, dsFactory, newPropMap, cptClosure);
            }
            if (deactivateMethod == null && !lookedForDeactivateMethod) {
                deactivateMethod = this.findLifeCycleMethod(typeBinding, "deactivate");
            }
            if (deactivateMethod != null) {
                this.collectProperties((IBinding)deactivateMethod, dsFactory, newPropMap, cptClosure);
            }
            if (!cptClosure.isEmpty()) {
                requiredVersion = DSAnnotationVersion.V1_3.max(requiredVersion);
            }
            if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion)) {
                List<Annotation> propertyTypeAnnotations = AnnotationVisitor.annotations(type.modifiers()).filter(a -> AnnotationVisitor.isComponentPropertyType(a.resolveTypeBinding())).toList();
                for (Annotation propertyType : propertyTypeAnnotations) {
                    requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
                    this.collectComponentPropertyTypes(dsFactory, newPropMap, propertyType);
                }
            }
        }
        this.updateProperties(model, type, annotation, value, properties, component, () -> ((IDSDocumentFactory)dsFactory).createProperty(), (IDSSingleProperty[])component.getPropertyElements(), newPropMap);
        this.updateProperties(model, type, annotation, value, factoryProperties, component, () -> ((IDSDocumentFactory)dsFactory).createFactoryProperty(), (IDSSingleProperty[])component.getFactoryPropertyElements(), new LinkedHashMap());
        this.updatePropertyFiles(propertyFiles, component, () -> ((IDSDocumentFactory)dsFactory).createProperties(), (IDSBundleProperties[])component.getPropertiesElements());
        this.updatePropertyFiles(factoryPropertyFiles, component, () -> ((IDSDocumentFactory)dsFactory).createFactoryProperties(), (IDSBundleProperties[])component.getFactoryPropertiesElements());
        if (factoryPropertyFiles.length > 0 || factoryProperties.length > 0) {
            requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
        }
        if (references.isEmpty()) {
            this.removeChildren((IDSObject)component, Arrays.asList(refElements));
        } else {
            Collections.sort(references, REF_NAME_COMPARATOR);
            int firstPos = refElements.length == 0 ? ((service = component.getService()) == null ? Math.max(0, this.indexOfLastPropertyOrProperties(component)) : component.indexOf((IDocumentElementNode)service) + 1) : component.indexOf((IDocumentElementNode)refElements[0]);
            this.removeChildren((IDSObject)component, refMap.values());
            this.addOrMoveChildren((IDSObject)component, references, firstPos);
        }
        IDSImplementation impl = component.getImplementation();
        if (impl == null) {
            impl = dsFactory.createImplementation();
            component.setImplementation(impl);
        }
        impl.setClassName(implClass);
        if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion) && activateConstructor != null) {
            requiredVersion = DSAnnotationVersion.V1_4.max(requiredVersion);
        }
        String xmlns = requiredVersion.getNamespace();
        value = params.get("xmlns");
        if (value instanceof String) {
            xmlns = (String)value;
            this.validateComponentXMLNS(annotation, xmlns, requiredVersion);
        }
        component.setNamespace(xmlns);
    }

    private void collectComponentPropertyTypes(IDSDocumentFactory dsFactory, LinkedHashMap<String, IDSProperty> newPropMap, Annotation propertyType) {
        String fqdn = propertyType.getTypeName().getFullyQualifiedName();
        ITypeBinding propertyTypeBinding = propertyType.resolveTypeBinding();
        String prefix = this.getPrefix(propertyTypeBinding);
        IMethodBinding[] methods = propertyTypeBinding.getDeclaredMethods();
        Map map = Arrays.stream(methods).map(methodBinding -> this.createProperty((IMethodBinding)methodBinding, prefix, dsFactory)).filter(Objects::nonNull).collect(Collectors.toMap(IDSObject::getName, Function.identity(), (a, b) -> a, LinkedHashMap::new));
        if (propertyType instanceof NormalAnnotation) {
            NormalAnnotation normal = (NormalAnnotation)propertyType;
            List values = normal.values();
            for (MemberValuePair pair : values) {
                String propName = pair.getName().getFullyQualifiedName();
                String key = NameGenerator.createPropertyName(propName, prefix, this.specVersion);
                this.setPropertyValue((IDSProperty)map.get(key), pair.getValue());
            }
        }
        if (propertyType instanceof MarkerAnnotation && map.isEmpty()) {
            IDSProperty property = dsFactory.createProperty();
            property.setPropertyName(NameGenerator.createClassPropertyName(fqdn, prefix));
            property.setPropertyType("Boolean");
            property.setPropertyValue(String.valueOf(Boolean.TRUE));
            newPropMap.remove(property.getName());
            newPropMap.put(property.getName(), property);
            return;
        }
        if (propertyType instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation single = (SingleMemberAnnotation)propertyType;
            if (map.size() == 1) {
                IDSProperty property = dsFactory.createProperty();
                property.setPropertyName(NameGenerator.createClassPropertyName(fqdn, prefix));
                Expression expression = single.getValue();
                property.setPropertyType(this.getPropertyType(expression.resolveTypeBinding()));
                this.setPropertyValue(property, expression);
                newPropMap.remove(property.getName());
                newPropMap.put(property.getName(), property);
                return;
            }
        }
        for (IDSProperty prop : map.values()) {
            newPropMap.remove(prop.getName());
            if (prop.getPropertyValue() == null && prop.getPropertyElemBody() == null) continue;
            newPropMap.put(prop.getName(), prop);
        }
    }

    private void setPropertyValue(IDSProperty property, Expression expression) {
        if (expression instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)expression;
            Object constantExpressionValue = name.resolveConstantExpressionValue();
            if (constantExpressionValue == null) {
                this.removeAttribute((IDSObject)property, "value", null);
            } else {
                property.setPropertyValue(constantExpressionValue.toString());
            }
        } else if (expression instanceof StringLiteral) {
            StringLiteral string = (StringLiteral)expression;
            property.setPropertyValue(string.getLiteralValue());
        } else if (expression instanceof ArrayInitializer) {
            ArrayInitializer array = (ArrayInitializer)expression;
            this.removeAttribute((IDSObject)property, "value", null);
            List expressions = array.expressions();
            if (!expressions.isEmpty()) {
                String body = expressions.stream().map(arrayExpression -> {
                    if (arrayExpression instanceof StringLiteral) {
                        StringLiteral string = (StringLiteral)arrayExpression;
                        return string.getLiteralValue();
                    }
                    if (arrayExpression instanceof TypeLiteral) {
                        TypeLiteral type = (TypeLiteral)arrayExpression;
                        return type.getType().resolveBinding().getQualifiedName();
                    }
                    if (expression instanceof QualifiedName) {
                        QualifiedName name = (QualifiedName)expression;
                        return String.valueOf(name.resolveConstantExpressionValue());
                    }
                    return expression.toString();
                }).collect(Collectors.joining(TextUtil.getDefaultLineDelimiter()));
                if (expressions.size() == 1) {
                    property.setPropertyValue(body);
                } else {
                    property.setPropertyElemBody(body);
                }
            }
        } else if (expression instanceof TypeLiteral) {
            TypeLiteral type = (TypeLiteral)expression;
            property.setPropertyValue(type.getType().resolveBinding().getQualifiedName());
        } else {
            property.setPropertyValue(expression.toString());
        }
    }

    private String getPrefix(ITypeBinding typeBinding) {
        if (DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion)) {
            IVariableBinding[] fields;
            IVariableBinding[] iVariableBindingArray = fields = typeBinding.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                IVariableBinding binding = iVariableBindingArray[n2];
                String name = binding.getName();
                if ("PREFIX_".equals(name) && (object = binding.getConstantValue()) instanceof String) {
                    String prefix = (String)object;
                    return prefix;
                }
                ++n2;
            }
        }
        return null;
    }

    private <T extends IDSSingleProperty> void updateProperties(IDSModel model, TypeDeclaration type, Annotation annotation, Object value, String[] properties, IDSComponent component, Supplier<T> factory, T[] propElements, LinkedHashMap<String, T> newPropMap) {
        if (newPropMap.isEmpty() && properties.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propElements));
        } else {
            Object propertyName;
            int colon;
            LinkedHashMap<T[], IDSSingleProperty> map = new LinkedHashMap<T[], IDSSingleProperty>(properties.length);
            int i = 0;
            while (i < properties.length) {
                IDSSingleProperty property;
                String propertyValue;
                String propertyType;
                String propertyStr = properties[i];
                String[] pair = propertyStr.split("=", 2);
                colon = pair[0].indexOf(58);
                if (colon == -1) {
                    propertyName = pair[0];
                    propertyType = null;
                } else {
                    propertyName = pair[0].substring(0, colon);
                    propertyType = pair[0].substring(colon + 1);
                }
                String string = propertyValue = pair.length > 1 ? pair[1].trim() : null;
                if (propertyValue != null && "Character".equals(propertyType)) {
                    if (propertyValue.length() == 0 || propertyValue.length() > 1) {
                        this.problemReporter.reportProblem(annotation, "property", i, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyValue, (Object)type, (Object)value), String.valueOf(value));
                    } else {
                        char c = propertyValue.charAt(0);
                        propertyValue = Integer.toString(c);
                    }
                }
                if ((property = (IDSSingleProperty)map.get(propertyName)) == null) {
                    property = (IDSSingleProperty)factory.get();
                    map.put((T[])propertyName, property);
                    property.setPropertyName(propertyName);
                    if (propertyType == null) {
                        this.removeAttribute((IDSObject)property, "type", null);
                    } else {
                        property.setPropertyType(propertyType);
                    }
                    property.setPropertyValue(propertyValue);
                    this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i);
                } else {
                    String content = property.getPropertyElemBody();
                    if (content == null) {
                        content = property.getPropertyValue();
                        property.setPropertyElemBody(content);
                        this.removeAttribute((IDSObject)property, "value", null);
                    }
                    if (!this.errorLevel.isIgnore()) {
                        String actual;
                        String expected = property.getPropertyType() == null || property.getPropertyType().length() == 0 || "String".equals(property.getPropertyType()) ? Messages.AnnotationProcessor_stringOrEmpty : property.getPropertyType();
                        String string2 = actual = propertyType == null || "String".equals(propertyType) ? Messages.AnnotationProcessor_stringOrEmpty : propertyType;
                        if (!actual.equals(expected)) {
                            this.problemReporter.reportProblem(annotation, "property", i, NLS.bind((String)Messages.AnnotationProcessor_inconsistentComponentPropertyType, (Object)actual, (Object)expected), actual);
                        } else {
                            this.validateComponentProperty(annotation, (String)propertyName, propertyType, propertyValue, i);
                        }
                    }
                    if (propertyValue != null) {
                        property.setPropertyElemBody(content + TextUtil.getDefaultLineDelimiter() + pair[1]);
                    }
                }
                ++i;
            }
            HashMap<String, T> propMap = new HashMap<String, T>(propElements.length);
            propertyName = propElements;
            colon = propElements.length;
            int pair = 0;
            while (pair < colon) {
                T propElement = propertyName[pair];
                IDSSingleProperty put = (IDSSingleProperty)propMap.put(propElement.getPropertyName(), propElement);
                if (put != null) {
                    this.removeChildren((IDSObject)component, List.of(put));
                }
                ++pair;
            }
            newPropMap.keySet().removeAll(map.keySet());
            newPropMap.putAll(map);
            ArrayList<T> propList = new ArrayList<T>(newPropMap.values());
            ListIterator<T> i2 = propList.listIterator();
            while (i2.hasNext()) {
                String newContent;
                IDSSingleProperty newProperty = (IDSSingleProperty)i2.next();
                IDSSingleProperty property = (IDSSingleProperty)propMap.remove(newProperty.getPropertyName());
                if (property == null) continue;
                i2.set(property);
                String newPropertyType = newProperty.getPropertyType();
                if (newPropertyType != null || !"String".equals(property.getPropertyType())) {
                    property.setPropertyType(newPropertyType);
                }
                if ((newContent = newProperty.getPropertyElemBody()) == null) {
                    property.setPropertyValue(newProperty.getPropertyValue());
                    IDocumentTextNode textNode = property.getTextNode();
                    if (textNode == null) continue;
                    property.removeTextNode();
                    if (!property.isInTheModel() || !property.isEditable()) continue;
                    model.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)model, 2, new Object[]{textNode}, null));
                    continue;
                }
                this.removeAttribute((IDSObject)property, "value", null);
                String content = property.getPropertyElemBody();
                if (content != null && newContent.equals(this.normalizePropertyElemBody(content))) continue;
                property.setPropertyElemBody(newContent);
            }
            int firstPos = propElements.length == 0 ? 0 : component.indexOf(propElements[0]);
            this.removeChildren((IDSObject)component, propMap.values());
            this.addOrMoveChildren((IDSObject)component, propList, firstPos);
        }
    }

    private String[] collectProperties(String key, Map<String, ?> params) {
        String[] properties;
        Object value = params.get(key);
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<String> list = new ArrayList<String>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof String) {
                    list.add((String)element);
                }
                ++n2;
            }
            properties = list.toArray(new String[list.size()]);
        } else {
            properties = new String[]{};
        }
        return properties;
    }

    private <T extends IDSBundleProperties> void updatePropertyFiles(String[] propertyFiles, IDSComponent component, Supplier<T> factory, T[] propFileElements) {
        if (propertyFiles.length == 0) {
            this.removeChildren((IDSObject)component, Arrays.asList(propFileElements));
        } else {
            IDSProperty[] propElements;
            HashMap<String, T> propFileMap = new HashMap<String, T>(propFileElements.length);
            T[] TArray = propFileElements;
            int n = propFileElements.length;
            int n2 = 0;
            while (n2 < n) {
                T propFileElement = TArray[n2];
                IDSBundleProperties put = (IDSBundleProperties)propFileMap.put(propFileElement.getEntry(), propFileElement);
                if (put != null) {
                    this.removeChildren((IDSObject)component, List.of(put));
                }
                ++n2;
            }
            ArrayList<IDSBundleProperties> propFileList = new ArrayList<IDSBundleProperties>(propertyFiles.length);
            String[] stringArray = propertyFiles;
            int n3 = propertyFiles.length;
            n = 0;
            while (n < n3) {
                String propertyFile = stringArray[n];
                IDSBundleProperties propertiesElement = (IDSBundleProperties)propFileMap.remove(propertyFile);
                if (propertiesElement == null) {
                    propertiesElement = (IDSBundleProperties)factory.get();
                    propertiesElement.setInTheModel(false);
                    propertiesElement.setEntry(propertyFile);
                }
                propFileList.add(propertiesElement);
                ++n;
            }
            int firstPos = propFileElements.length == 0 ? ((propElements = component.getPropertyElements()).length == 0 ? 0 : component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1) : component.indexOf(propFileElements[0]);
            this.removeChildren((IDSObject)component, propFileMap.values());
            this.addOrMoveChildren((IDSObject)component, propFileList, firstPos);
        }
    }

    private String[] collectPropertiesFiles(String key, ITypeBinding typeBinding, Annotation annotation, Map<String, ?> params) {
        String[] propertyFiles;
        Object value = params.get(key);
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<String> list = new ArrayList<String>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof String) {
                    list.add((String)element);
                }
                ++n2;
            }
            propertyFiles = list.toArray(new String[list.size()]);
            this.validateComponentPropertyFiles(key, annotation, ((IType)typeBinding.getJavaElement()).getJavaProject().getProject(), propertyFiles);
        } else {
            propertyFiles = new String[]{};
        }
        return propertyFiles;
    }

    private HashMap<String, IDSReference> buildReferenceMap(IDSReference[] refElements) {
        HashMap<String, IDSReference> refMap = new HashMap<String, IDSReference>(refElements.length);
        IDSReference[] iDSReferenceArray = refElements;
        int n = refElements.length;
        int n2 = 0;
        while (n2 < n) {
            IDSReference refElement = iDSReferenceArray[n2];
            String referenceName = refElement.getReferenceName();
            if (referenceName == null) {
                String referenceBind = refElement.getXMLAttributeValue("field");
                if (referenceBind != null) {
                    referenceName = ReferenceProcessor.getReferenceName(referenceBind);
                }
                if (referenceName == null && (referenceName = refElement.getReferenceBind()) == null) {
                    referenceName = refElement.getReferenceInterface();
                }
            }
            refMap.put(referenceName, refElement);
            ++n2;
        }
        return refMap;
    }

    private ComponentActivationAnnotation validateOnlyOne(List<ComponentActivationAnnotation> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1 || this.errorLevel.isIgnore()) {
            return list.get(0);
        }
        for (ComponentActivationAnnotation a : list) {
            this.problemReporter.reportProblem(a.annotation(), null, Messages.AnnotationProcessor_duplicateActivateMethod, a.activate());
        }
        return null;
    }

    private IDSReference createReference(IDSDocumentFactory dsFactory) {
        IDSReference reference = dsFactory.createReference();
        this.removeAttribute((IDSObject)reference, "cardinality", null);
        this.removeAttribute((IDSObject)reference, "policy", null);
        return reference;
    }

    private void removeChildren(IDSObject parent, Collection<? extends IDocumentElementNode> children) {
        for (IDocumentElementNode iDocumentElementNode : children) {
            parent.removeChildNode(iDocumentElementNode, true);
        }
    }

    void removeAttribute(IDSObject obj, String name, String defaultValue) {
        IDocumentAttributeNode attrNode = obj.getDocumentAttribute(name);
        if (attrNode != null) {
            String value = attrNode.getAttributeValue();
            if (value != null && value.equals(defaultValue)) {
                return;
            }
            obj.removeDocumentAttribute(attrNode);
            if (obj.isInTheModel() && obj.isEditable()) {
                obj.getModel().fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)obj.getModel(), 2, new Object[]{attrNode}, null));
            }
        }
    }

    private void addOrMoveChildren(IDSObject parent, List<? extends IDSObject> children, int firstPos) {
        int i = 0;
        int n = children.size();
        while (i < n) {
            IDSObject child = children.get(i);
            if (child.isInTheModel()) {
                int pos = parent.indexOf((IDocumentElementNode)child);
                if (i == 0) {
                    if (firstPos < pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, firstPos - pos, true);
                    }
                } else {
                    int prevPos = parent.indexOf((IDocumentElementNode)children.get(i - 1));
                    if (prevPos > pos) {
                        this.moveChildNode((IDocumentObject)parent, (IDocumentElementNode)child, prevPos - pos, true);
                    }
                }
            } else if (i == 0) {
                if (firstPos == -1) {
                    parent.addChildNode((IDocumentElementNode)child, true);
                } else {
                    parent.addChildNode((IDocumentElementNode)child, firstPos, true);
                }
            } else {
                parent.addChildNode((IDocumentElementNode)child, parent.indexOf((IDocumentElementNode)children.get(i - 1)) + 1, true);
            }
            ++i;
        }
    }

    private void moveChildNode(IDocumentObject obj, IDocumentElementNode node, int newRelativeIndex, boolean fireEvent) {
        if (newRelativeIndex == 1 || newRelativeIndex == -1) {
            obj.moveChildNode(node, newRelativeIndex, fireEvent);
            return;
        }
        int currentIndex = obj.indexOf(node);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= obj.getChildCount()) {
            return;
        }
        obj.removeChildNode(node, fireEvent);
        IDocumentElementNode clone = this.clone(obj, node);
        obj.addChildNode(clone, newIndex, fireEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDocumentElementNode clone(IDocumentObject obj, IDocumentElementNode node) {
        IDocumentElementNode clone = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
                block30: {
                    Throwable throwable2 = null;
                    Throwable throwable3 = null;
                    try (ObjectOutputStream out = new ObjectOutputStream(bout);){
                        out.writeObject(node);
                        out.flush();
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                    byte[] bytes = bout.toByteArray();
                    throwable3 = null;
                    Object var9_15 = null;
                    try {
                        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
                        try {
                            try (ObjectInputStream in = new ObjectInputStream(bin);){
                                clone = (IDocumentElementNode)in.readObject();
                            }
                            if (bin == null) break block30;
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                            } else if (throwable3 != throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            if (bin == null) throw throwable3;
                            bin.close();
                            throw throwable3;
                        }
                        bin.close();
                    }
                    catch (Throwable throwable6) {
                        if (throwable3 == null) {
                            throwable3 = throwable6;
                            throw throwable3;
                        }
                        if (throwable3 == throwable6) throw throwable3;
                        throwable3.addSuppressed(throwable6);
                        throw throwable3;
                    }
                }
                clone.reconnect((IDocumentElementNode)obj, obj.getSharedModel());
                return clone;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                }
                if (throwable == throwable7) throw throwable;
                throwable.addSuppressed(throwable7);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            if (!debug.isDebugging()) return clone;
            debug.trace("Error cloning element.", e);
        }
        return clone;
    }

    private int indexOfLastPropertyOrProperties(IDSComponent component) {
        int lastPos;
        int pos = -1;
        IDSProperty[] propElements = component.getPropertyElements();
        IDSProperties[] propFileElements = component.getPropertiesElements();
        if (propElements.length > 0) {
            pos = component.indexOf((IDocumentElementNode)propElements[propElements.length - 1]) + 1;
        }
        if (propFileElements.length > 0 && (lastPos = component.indexOf((IDocumentElementNode)propFileElements[propFileElements.length - 1]) + 1) > pos) {
            pos = lastPos;
        }
        return pos;
    }

    private String normalizePropertyElemBody(String content) {
        StringBuilder buf;
        block13: {
            buf = new StringBuilder(content.length());
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = new BufferedReader(new StringReader(content));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String trimmed = line.trim();
                        if (trimmed.length() == 0) continue;
                        if (buf.length() > 0) {
                            buf.append(TextUtil.getDefaultLineDelimiter());
                        }
                        buf.append(trimmed);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!debug.isDebugging()) break block13;
                debug.trace("Error reading property element body.", e);
            }
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    private DSAnnotationVersion collectProperties(IBinding binding, IDSDocumentFactory factory, Map<String, IDSProperty> properties, Collection<ITypeBinding> visited) {
        version = DSAnnotationVersion.V1_3;
        if (binding instanceof IMethodBinding) {
            method = (IMethodBinding)binding;
            parameterTypes = method.getParameterTypes();
        } else if (binding instanceof ITypeBinding) {
            type = (ITypeBinding)binding;
            parameterTypes = new ITypeBinding[]{type};
        } else {
            return version;
        }
        var12_9 = parameterTypes;
        var11_10 = parameterTypes.length;
        var10_11 = 0;
        while (var10_11 < var11_10) {
            block12: {
                paramTypeBinding = var12_9[var10_11];
                if (!paramTypeBinding.isAnnotation() || !visited.add(paramTypeBinding)) break block12;
                prefix = this.getPrefix(paramTypeBinding);
                if (prefix != null) {
                    version = DSAnnotationVersion.V1_4.max(version);
                }
                declaredMethods = paramTypeBinding.getDeclaredMethods();
                if (!DSAnnotationVersion.V1_4.isEqualOrHigherThan(this.specVersion)) ** GOTO lbl-1000
                if (declaredMethods.length == 0) {
                    version = DSAnnotationVersion.V1_4.max(version);
                    property = factory.createProperty();
                    property.setPropertyName(NameGenerator.createClassPropertyName(paramTypeBinding.getName(), prefix));
                    property.setPropertyType("Boolean");
                    property.setPropertyValue(String.valueOf(Boolean.TRUE));
                    properties.remove(property.getName());
                    properties.put(property.getName(), property);
                } else if (declaredMethods.length == 1 && "value".equals(declaredMethods[0].getName())) {
                    version = DSAnnotationVersion.V1_4.max(version);
                    property = this.createProperty(declaredMethods[0], prefix, factory);
                    property.setPropertyName(NameGenerator.createClassPropertyName(paramTypeBinding.getName(), prefix));
                    properties.remove(property.getName());
                    properties.put(property.getName(), property);
                } else lbl-1000:
                // 2 sources

                {
                    var18_18 = declaredMethods;
                    var17_17 = declaredMethods.length;
                    var16_16 = 0;
                    while (var16_16 < var17_17) {
                        methodBinding = var18_18[var16_16];
                        property = this.createProperty(methodBinding, prefix, factory);
                        if (property != null && (property.getPropertyElemBody() != null || property.getPropertyValue() != null)) {
                            properties.remove(property.getName());
                            properties.put(property.getName(), property);
                        }
                        ++var16_16;
                    }
                }
            }
            ++var10_11;
        }
        return version;
    }

    private IDSProperty createProperty(IMethodBinding methodBinding, String prefix, IDSDocumentFactory factory) {
        if (!methodBinding.isAnnotationMember()) {
            return null;
        }
        ITypeBinding returnType = methodBinding.getReturnType();
        if (returnType.isArray() ? returnType.getElementType().isAnnotation() : returnType.isAnnotation()) {
            return null;
        }
        Object value = methodBinding.getDefaultValue();
        String propertyName = NameGenerator.createPropertyName(methodBinding.getName(), prefix, this.specVersion);
        String propertyType = this.getPropertyType(returnType);
        IDSProperty property = factory.createProperty();
        property.setPropertyName(propertyName);
        property.setPropertyType(propertyType);
        if (value == null) {
            this.removeAttribute((IDSObject)property, "value", null);
        } else if (returnType.isArray()) {
            Object[] objects = (Object[])value;
            if (objects.length > 0) {
                StringBuilder body = new StringBuilder();
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    String itemValue = this.getPropertyValue(item);
                    if (itemValue != null && !(itemValue = itemValue.trim()).isEmpty()) {
                        if (body.length() > 0) {
                            body.append(TextUtil.getDefaultLineDelimiter());
                        }
                        body.append(itemValue);
                    }
                    ++n2;
                }
                property.setPropertyElemBody(body.toString());
            }
            this.removeAttribute((IDSObject)property, "value", null);
        } else {
            property.setPropertyValue(this.getPropertyValue(value));
        }
        return property;
    }

    private String getPropertyType(ITypeBinding type) {
        String name;
        String result;
        if (type.isArray()) {
            return this.getPropertyType(type.getElementType());
        }
        if (type.isPrimitive() && (result = PRIMITIVE_TYPE_MAP.get(name = type.getQualifiedName())) != null) {
            return result;
        }
        return "String";
    }

    private String getPropertyValue(Object value) {
        if (value instanceof IVariableBinding) {
            return ((IVariableBinding)value).getName();
        }
        if (value instanceof ITypeBinding) {
            return ((ITypeBinding)value).getQualifiedName();
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return Integer.toString(character.charValue());
        }
        return String.valueOf(value);
    }

    private void validateComponentName(Annotation annotation, String name) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(name).matches()) {
            this.problemReporter.reportProblem(annotation, "name", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentName, (Object)name), name);
        }
    }

    private void validateComponentService(Annotation annotation, ITypeBinding componentType, ITypeBinding serviceType, int index) {
        if (!this.errorLevel.isIgnore() && !componentType.isAssignmentCompatible(serviceType)) {
            this.problemReporter.reportProblem(annotation, "service", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentService, (Object)serviceType.getName()), serviceType.getName());
        }
    }

    private void validateComponentFactory(Annotation annotation, String factory) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(factory).matches()) {
            this.problemReporter.reportProblem(annotation, "factory", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentFactoryName, (Object)factory), factory);
        }
    }

    private void validateComponentProperty(Annotation annotation, String name, String type, String value, int index) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        if (type == null || PROPERTY_TYPES.contains(type)) {
            if (name == null || name.trim().length() == 0) {
                this.problemReporter.reportProblem(annotation, "property", index, Messages.AnnotationProcessor_invalidComponentProperty_nameRequired, name);
            }
            if (value == null) {
                this.problemReporter.reportProblem(annotation, "property", index, Messages.AnnotationProcessor_invalidComponentProperty_valueRequired, name);
            } else {
                try {
                    if ("Long".equals(type)) {
                        Long.valueOf(value);
                    } else if ("Double".equals(type)) {
                        Double.valueOf(value);
                    } else if ("Float".equals(type)) {
                        Float.valueOf(value);
                    } else if ("Integer".equals(type) || "Character".equals(type)) {
                        Integer.valueOf(value);
                    } else if ("Byte".equals(type)) {
                        Byte.valueOf(value);
                    } else if ("Short".equals(type)) {
                        Short.valueOf(value);
                    }
                }
                catch (NumberFormatException e) {
                    this.problemReporter.reportProblem(annotation, "property", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyValue, (Object)type, (Object)value), String.valueOf(value));
                }
            }
        } else {
            this.problemReporter.reportProblem(annotation, "property", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyType, (Object)type), String.valueOf(type));
        }
    }

    private void validateComponentPropertyFiles(String key, Annotation annotation, IProject project, String[] files) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String file = files[i];
            IFile wsFile = PDEProject.getBundleRelativeFile((IProject)project, (IPath)IPath.fromOSString((String)file));
            if (!wsFile.exists()) {
                this.problemReporter.reportProblem(annotation, key, i, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentPropertyFile, (Object)file, (Object)key), file);
            }
            ++i;
        }
    }

    private void validateComponentXMLNS(Annotation annotation, String xmlns, DSAnnotationVersion requiredVersion) {
        if (this.errorLevel.isIgnore()) {
            return;
        }
        DSAnnotationVersion specifiedVersion = DSAnnotationVersion.fromNamespace(xmlns);
        if (specifiedVersion == null || requiredVersion.compareTo(specifiedVersion) > 0) {
            this.problemReporter.reportProblem(annotation, "xmlns", NLS.bind((String)Messages.AnnotationProcessor_invalidComponentDescriptorNamespace, (Object)xmlns), xmlns);
        }
    }

    private void validateComponentConfigPID(Annotation annotation, String configPid, int index) {
        if (!this.errorLevel.isIgnore() && !PID_PATTERN.matcher(configPid).matches()) {
            this.problemReporter.reportProblem(annotation, "configurationPid", index, NLS.bind((String)Messages.AnnotationProcessor_invalidComponentConfigurationPid, (Object)configPid), configPid);
        }
    }

    private void validateLifeCycleMethod(Annotation annotation, String methodName, MethodDeclaration method) {
        ITypeBinding[] paramTypeBindings;
        if (this.errorLevel.isIgnore()) {
            return;
        }
        IMethodBinding methodBinding = method.resolveBinding();
        if (methodBinding == null) {
            if (debug.isDebugging()) {
                debug.trace(String.format("Unable to resolve binding for method: %s", method));
            }
            return;
        }
        if (methodBinding.isConstructor()) {
            this.problemReporter.reportProblem(annotation, methodName, Messages.AnnotationProcessor_invalidLifecycleMethod_noMethod, new String[0]);
        }
        if (Modifier.isStatic((int)methodBinding.getModifiers())) {
            this.problemReporter.reportProblem(annotation, methodName, Messages.AnnotationProcessor_invalidLifecycleMethod_static, new String[0]);
        }
        String returnTypeName = methodBinding.getReturnType().getName();
        if (!Void.TYPE.getName().equals(returnTypeName)) {
            this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodReturnType, (Object)methodName, (Object)returnTypeName), returnTypeName);
        }
        if ((paramTypeBindings = methodBinding.getParameterTypes()).length == 0) {
            return;
        }
        boolean hasMap = false;
        boolean hasCompCtx = false;
        boolean hasBundleCtx = false;
        boolean hasInt = false;
        HashSet<ITypeBinding> annotationParams = new HashSet<ITypeBinding>(1);
        ITypeBinding[] iTypeBindingArray = paramTypeBindings;
        int n = paramTypeBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding paramTypeBinding = iTypeBindingArray[n2];
            ITypeBinding paramTypeErasure = paramTypeBinding.getErasure();
            String paramTypeName = paramTypeErasure.isMember() ? paramTypeErasure.getBinaryName() : paramTypeErasure.getQualifiedName();
            boolean isDuplicate = false;
            if (paramTypeBinding.isAnnotation() && DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion)) {
                if (!annotationParams.add(paramTypeBinding)) {
                    isDuplicate = true;
                }
            } else if (MAP_TYPE.equals(paramTypeName)) {
                if (hasMap) {
                    isDuplicate = true;
                } else {
                    hasMap = true;
                }
            } else if (COMPONENT_CONTEXT.equals(paramTypeName)) {
                if (hasCompCtx) {
                    isDuplicate = true;
                } else {
                    hasCompCtx = true;
                }
            } else if (BUNDLE_CONTEXT.equals(paramTypeName)) {
                if (hasBundleCtx) {
                    isDuplicate = true;
                } else {
                    hasBundleCtx = true;
                }
            } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                if (hasInt) {
                    isDuplicate = true;
                } else {
                    hasInt = true;
                }
            } else {
                this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_invalidLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            if (isDuplicate) {
                this.problemReporter.reportProblem(annotation, methodName, NLS.bind((String)Messages.AnnotationProcessor_duplicateLifeCycleMethodParameterType, (Object)methodName, (Object)paramTypeName), paramTypeName);
            }
            ++n2;
        }
    }

    private IMethodBinding findLifeCycleMethod(ITypeBinding componentClass, String methodName) {
        IMethodBinding[] iMethodBindingArray = componentClass.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            if (methodName.equals(methodBinding.getName()) && Void.TYPE.getName().equals(methodBinding.getReturnType().getName())) {
                ITypeBinding[] paramTypeBindings = methodBinding.getParameterTypes();
                boolean hasMap = false;
                boolean hasCompCtx = false;
                boolean hasBundleCtx = false;
                boolean hasInt = false;
                boolean isInvalid = false;
                HashSet<ITypeBinding> annotationParams = new HashSet<ITypeBinding>(1);
                ITypeBinding[] iTypeBindingArray = paramTypeBindings;
                int n3 = paramTypeBindings.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding paramTypeBinding = iTypeBindingArray[n4];
                    if (paramTypeBinding.isAnnotation()) {
                        if (!DSAnnotationVersion.V1_3.isEqualOrHigherThan(this.specVersion) || !annotationParams.add(paramTypeBinding)) {
                            isInvalid = true;
                            break;
                        }
                    } else {
                        String paramTypeName;
                        ITypeBinding paramTypeErasure = paramTypeBinding.getErasure();
                        String string = paramTypeName = paramTypeErasure.isMember() ? paramTypeErasure.getBinaryName() : paramTypeErasure.getQualifiedName();
                        if (MAP_TYPE.equals(paramTypeName)) {
                            if (hasMap) {
                                isInvalid = true;
                            } else {
                                hasMap = true;
                            }
                        } else if (COMPONENT_CONTEXT.equals(paramTypeName)) {
                            if (hasCompCtx) {
                                isInvalid = true;
                            } else {
                                hasCompCtx = true;
                            }
                        } else if (BUNDLE_CONTEXT.equals(paramTypeName)) {
                            if (hasBundleCtx) {
                                isInvalid = true;
                            } else {
                                hasBundleCtx = true;
                            }
                        } else if ("deactivate".equals(methodName) && (Integer.class.getName().equals(paramTypeName) || Integer.TYPE.getName().equals(paramTypeName))) {
                            if (hasInt) {
                                isInvalid = true;
                            } else {
                                hasInt = true;
                            }
                        } else {
                            isInvalid = true;
                        }
                        if (isInvalid) break;
                    }
                    ++n4;
                }
                if (!isInvalid) {
                    return methodBinding;
                }
            }
            ++n2;
        }
        return null;
    }

    private static boolean hasInjectableConstructor(TypeDeclaration type, ProblemReporter problemReporter) {
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor() && AnnotationVisitor.annotations(method.modifiers()).map(Annotation::resolveAnnotationBinding).anyMatch(AnnotationVisitor::isActivateAnnotation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasDefaultConstructor(TypeDeclaration type) {
        boolean hasConstructor = false;
        MethodDeclaration[] methodDeclarationArray = type.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            if (method.isConstructor()) {
                hasConstructor = true;
                if (Modifier.isPublic((int)method.getModifiers()) && method.parameters().isEmpty()) {
                    return true;
                }
            }
            ++n2;
        }
        return !hasConstructor;
    }

    private static Stream<Annotation> annotations(List<?> modifiers) {
        return modifiers.stream().filter(Annotation.class::isInstance).map(Annotation.class::cast);
    }

    private static boolean isActivateAnnotation(IAnnotationBinding binding) {
        return binding != null && ACTIVATE_ANNOTATION.equals(binding.getAnnotationType().getQualifiedName());
    }

    private static boolean isReferenceAnnotation(IAnnotationBinding binding) {
        return binding != null && REFERENCE_ANNOTATION.equals(binding.getAnnotationType().getQualifiedName());
    }

    private static boolean isComponentPropertyType(IAnnotationBinding binding) {
        return binding != null && COMPONENT_PROPERTY_TYPE_ANNOTATION.equals(binding.getAnnotationType().getQualifiedName());
    }

    private static boolean isActivationObject(ITypeBinding param) {
        String binaryName = param.getErasure().getBinaryName();
        if (COMPONENT_CONTEXT.equals(binaryName) || BUNDLE_CONTEXT.equals(binaryName) || MAP_TYPE.equals(binaryName)) {
            return true;
        }
        return param.isAnnotation();
    }

    private static boolean isComponentPropertyType(ITypeBinding param) {
        if (param != null) {
            IAnnotationBinding[] annotations;
            IAnnotationBinding[] iAnnotationBindingArray = annotations = param.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotationBinding annotationAnnotation = iAnnotationBindingArray[n2];
                if (AnnotationVisitor.isComponentPropertyType(annotationAnnotation)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

