/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.natures.PDE;

public class PDEBuilderHelper {
    public static String[] getUnlistedClasspaths(List<IBuildEntry> sourceEntries, IProject project, IClasspathEntry[] cpes) {
        String[] unlisted = new String[cpes.length];
        int index = 0;
        IClasspathEntry[] iClasspathEntryArray = cpes;
        int n = cpes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && !entry.isTest()) {
                IPath path = entry.getPath();
                boolean found = false;
                int j = 0;
                while (j < sourceEntries.size()) {
                    String[] tokens;
                    IBuildEntry be = sourceEntries.get(j);
                    String[] stringArray = tokens = be.getTokens();
                    int n3 = tokens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPath ipath;
                        String token = stringArray[n4];
                        IResource res = project.findMember(token);
                        if (res != null && (ipath = res.getFullPath()).equals((Object)path)) {
                            found = true;
                        }
                        ++n4;
                    }
                    ++j;
                }
                if (!found) {
                    unlisted[index++] = path.removeFirstSegments(1).addTrailingSeparator().toString();
                }
            }
            ++n2;
        }
        return unlisted;
    }

    public static ArrayList<String> getSourceEntries(IBuild build) {
        IBuildEntry[] entries;
        ArrayList<String> sourceEntryKeys = new ArrayList<String>();
        IBuildEntry[] iBuildEntryArray = entries = build.getBuildEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry buildEntry = iBuildEntryArray[n2];
            String name = buildEntry.getName();
            if (name.startsWith("source.")) {
                String entry = name.substring("source.".length(), name.length());
                sourceEntryKeys.add(entry);
            }
            ++n2;
        }
        return sourceEntryKeys;
    }

    public static boolean isPDEProject(IProject project) {
        return project != null && project.isAccessible() && (PDE.hasPluginNature(project) || PDE.hasFeatureNature(project) || PDE.hasUpdateSiteNature(project));
    }
}

