/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette.customize;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

class PaletteTreeProvider
implements ITreeContentProvider {
    private final TreeViewer viewer;
    private PaletteRoot root;
    private final PropertyChangeListener modelListener = this::handlePropertyChanged;

    public PaletteTreeProvider(TreeViewer treeviewer) {
        this.viewer = treeviewer;
    }

    public void dispose() {
        this.traverseModel(this.root, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getChildren(Object parentElement) {
        Object object = parentElement;
        if (object instanceof PaletteContainer) {
            void pc;
            PaletteContainer paletteContainer = (PaletteContainer)object;
            PaletteContainer cfr_ignored_0 = (PaletteContainer)object;
            List<PaletteEntry> children = pc.getChildren();
            if (!children.isEmpty()) {
                return children.toArray();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = this.getChildren(inputElement);
        if (elements == null) {
            elements = new Object[]{};
        }
        return elements;
    }

    public Object getParent(Object element) {
        return ((PaletteEntry)element).getParent();
    }

    protected void handlePropertyChanged(PropertyChangeEvent evt) {
        PaletteEntry entry = (PaletteEntry)evt.getSource();
        String property = evt.getPropertyName();
        if (property.equals("Name") || property.equals("Small Icon")) {
            this.viewer.update((Object)entry, null);
        } else if (property.equals("Visible")) {
            this.viewer.refresh((Object)entry);
        } else if (property.equals("Children Changed")) {
            this.viewer.refresh((Object)entry);
            List oldChildren = (List)evt.getOldValue();
            oldChildren.forEach(child -> this.traverseModel((PaletteEntry)child, false));
            this.traverseModel(entry, true);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.root != null) {
            this.traverseModel(this.root, false);
        }
        if (newInput != null) {
            this.root = (PaletteRoot)newInput;
            this.traverseModel(this.root, true);
        }
    }

    private void traverseModel(PaletteEntry entry, boolean isHook) {
        if (isHook) {
            entry.addPropertyChangeListener(this.modelListener);
        } else {
            entry.removePropertyChangeListener(this.modelListener);
        }
        if (this.hasChildren(entry)) {
            Object[] children;
            Object[] objectArray = children = this.getChildren(entry);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.traverseModel((PaletteEntry)child, isHook);
                ++n2;
            }
        }
    }
}

