/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SourceModule;
import org.eclipse.jdt.internal.formatter.CommentsPreparator;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.LineBreaksPreparator;
import org.eclipse.jdt.internal.formatter.OneLineEnforcer;
import org.eclipse.jdt.internal.formatter.SpacePreparator;
import org.eclipse.jdt.internal.formatter.TextEditsBuilder;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.linewrap.CommentWrapExecutor;
import org.eclipse.jdt.internal.formatter.linewrap.WrapPreparator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class DefaultCodeFormatter
extends CodeFormatter {
    public static boolean DEBUG = false;
    private static final int K_COMMENTS_MASK = 112;
    private static final int K_MASK = 255;
    private static final Map<Integer, Integer> FORMAT_TO_PARSER_KIND = new HashMap<Integer, Integer>();
    private DefaultCodeFormatterOptions originalOptions;
    private DefaultCodeFormatterOptions workingOptions;
    private Object oldCommentFormatOption;
    private String sourceLevel;
    public boolean previewEnabled;
    private String sourceString;
    char[] sourceArray;
    private List<IRegion> formatRegions;
    private ASTNode astRoot;
    private List<Token> tokens = new ArrayList<Token>();
    private TokenManager tokenManager;

    static {
        FORMAT_TO_PARSER_KIND.put(8, 8);
        FORMAT_TO_PARSER_KIND.put(128, 8);
        FORMAT_TO_PARSER_KIND.put(4, 4);
        FORMAT_TO_PARSER_KIND.put(2, 2);
        FORMAT_TO_PARSER_KIND.put(1, 1);
    }

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions options) {
        this(options, null);
    }

    public DefaultCodeFormatter(Map<String, String> options) {
        this(null, options);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        this.initOptions(defaultCodeFormatterOptions, options);
    }

    private void initOptions(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, String> options) {
        if (options != null) {
            this.originalOptions = new DefaultCodeFormatterOptions(options);
            this.workingOptions = new DefaultCodeFormatterOptions(options);
            this.oldCommentFormatOption = this.getOldCommentFormatOption(options);
            String compilerSource = options.get("org.eclipse.jdt.core.compiler.source");
            this.sourceLevel = compilerSource != null ? compilerSource : CompilerOptions.getLatestVersion();
            this.previewEnabled = "enabled".equals(options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures"));
        } else {
            Map settings = DefaultCodeFormatterConstants.getJavaConventionsSettings();
            this.originalOptions = new DefaultCodeFormatterOptions(settings);
            this.workingOptions = new DefaultCodeFormatterOptions(settings);
            this.oldCommentFormatOption = "true";
            this.sourceLevel = CompilerOptions.getLatestVersion();
        }
        if (defaultCodeFormatterOptions != null) {
            this.originalOptions.set(defaultCodeFormatterOptions.getMap());
            this.workingOptions.set(defaultCodeFormatterOptions.getMap());
        }
    }

    @Deprecated
    private Object getOldCommentFormatOption(Map<String, String> options) {
        return options.get("org.eclipse.jdt.core.formatter.comment.format_comments");
    }

    @Override
    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        int indent = indentationLevel * this.originalOptions.indentation_size;
        TextEditsBuilder.appendIndentationString(sb, this.originalOptions.tab_char, this.originalOptions.tab_size, indent, 0);
        return sb.toString();
    }

    @Override
    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        return this.format(kind, source, new IRegion[]{new Region(offset, length)}, indentationLevel, lineSeparator);
    }

    @Override
    public TextEdit format(int kind, String source, IRegion[] regions, int indentationLevel, String lineSeparator) {
        if (!this.regionsSatisfiesPreconditions(regions, source.length())) {
            throw new IllegalArgumentException();
        }
        this.formatRegions = Arrays.asList(regions);
        this.updateWorkingOptions(indentationLevel, lineSeparator, kind);
        if ((kind & 0x70) != 0) {
            return this.formatComments(source, kind & 0x70);
        }
        if (this.prepareFormattedCode(source, kind) == null) {
            return this.tokens.isEmpty() ? new MultiTextEdit() : null;
        }
        MultiTextEdit result = new MultiTextEdit();
        TextEditsBuilder resultBuilder = new TextEditsBuilder(this.sourceString, this.formatRegions, this.tokenManager, this.workingOptions);
        this.tokenManager.traverse(0, resultBuilder);
        for (TextEdit edit : resultBuilder.getEdits()) {
            result.addChild(edit);
        }
        return result;
    }

    private boolean init(String source, int kind) {
        this.sourceString = source;
        this.sourceArray = source.toCharArray();
        this.tokens.clear();
        this.tokenManager = new TokenManager(this.tokens, source, this.workingOptions);
        this.tokenizeSource(kind);
        return !this.tokens.isEmpty();
    }

    List<Token> prepareFormattedCode(String source) {
        this.formatRegions = Arrays.asList(new Region(0, source.length()));
        return this.prepareFormattedCode(source, 0);
    }

    private List<Token> prepareFormattedCode(String source, int kind) {
        if (!this.init(source, kind)) {
            return null;
        }
        this.astRoot = this.parseSourceCode(kind);
        if (this.astRoot == null) {
            return null;
        }
        if (kind != 0) {
            this.findHeader();
        }
        this.prepareSpaces();
        this.prepareLineBreaks();
        this.prepareComments();
        this.prepareWraps(kind);
        return this.tokens;
    }

    private void findHeader() {
        if (this.astRoot instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            PackageDeclaration firstElement;
            org.eclipse.jdt.core.dom.CompilationUnit unit = (org.eclipse.jdt.core.dom.CompilationUnit)this.astRoot;
            List types = unit.types();
            ASTNode aSTNode = firstElement = types.isEmpty() ? unit.getPackage() : (ASTNode)types.get(0);
            if (firstElement != null) {
                int headerEndIndex = this.tokenManager.firstIndexIn(firstElement, -1);
                this.tokenManager.setHeaderEndIndex(headerEndIndex);
            }
        }
    }

    private TextEdit formatComments(String source, int kind) {
        Token token3;
        MultiTextEdit result = new MultiTextEdit();
        if (!this.init(source, kind)) {
            return result;
        }
        CommentsPreparator commentsPreparator = new CommentsPreparator(this.tokenManager, this.workingOptions, this.sourceLevel);
        CommentWrapExecutor commentWrapper = new CommentWrapExecutor(this.tokenManager, this.workingOptions);
        switch (kind) {
            case 64: {
                for (Token token2 : this.tokens) {
                    if (token2.tokenType != 1003) continue;
                    org.eclipse.jdt.core.dom.CompilationUnit cu = (org.eclipse.jdt.core.dom.CompilationUnit)this.parseSourceCode(8);
                    Javadoc javadoc = (Javadoc)cu.getCommentList().get(0);
                    javadoc.accept(commentsPreparator);
                    int startPosition = this.tokenManager.findSourcePositionInLine(token2.originalStart);
                    commentWrapper.wrapMultiLineComment(token2, startPosition, false, false);
                }
                break;
            }
            case 32: {
                int i = 0;
                while (i < this.tokens.size()) {
                    token3 = this.tokens.get(i);
                    if (token3.tokenType == 1002) {
                        commentsPreparator.handleBlockComment(i);
                        int startPosition = this.tokenManager.findSourcePositionInLine(token3.originalStart);
                        commentWrapper.wrapMultiLineComment(token3, startPosition, false, false);
                    }
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < this.tokens.size()) {
                    token3 = this.tokens.get(i);
                    if (token3.tokenType == 1001) {
                        commentsPreparator.handleLineComment(i);
                        if (i >= this.tokens.size() || this.tokens.get(i) != token3) {
                            token3 = this.tokens.get(--i);
                        }
                        int startPosition = this.tokenManager.findSourcePositionInLine(token3.originalStart);
                        commentWrapper.wrapLineComment(token3, startPosition);
                    }
                    ++i;
                }
                break;
            }
            default: {
                throw new AssertionError((Object)String.valueOf(kind));
            }
        }
        this.applyFormatOff();
        TextEditsBuilder resultBuilder = new TextEditsBuilder(source, this.formatRegions, this.tokenManager, this.workingOptions);
        resultBuilder.setAlignChar(2);
        for (Token token3 : this.tokens) {
            List<Token> structure = token3.getInternalStructure();
            if (!token3.isComment() || structure == null || structure.isEmpty()) continue;
            resultBuilder.processComment(token3);
        }
        for (TextEdit edit : resultBuilder.getEdits()) {
            result.addChild(edit);
        }
        return result;
    }

    private ASTNode parseSourceCode(int kind) {
        int[] kindsToTry;
        if ((kind &= 0xFF) != 0) {
            ASTNode astNode = this.createParser(kind).createAST(null);
            if (kind == 8 || kind == 128) {
                return astNode;
            }
            return this.hasErrors(astNode) ? null : astNode;
        }
        int[] nArray = kindsToTry = new int[]{8, 1, 4, 2, 128};
        int n = kindsToTry.length;
        int n2 = 0;
        while (n2 < n) {
            int kindToTry = nArray[n2];
            ASTNode astNode = this.createParser(kindToTry).createAST(null);
            if (!this.hasErrors(astNode)) {
                if (kindToTry == 128) {
                    this.tokenizeSource(kindToTry);
                }
                return astNode;
            }
            ++n2;
        }
        return null;
    }

    private ASTParser createParser(int kind) {
        ASTParser parser = ASTParser.newParser(20);
        if (kind == 128) {
            parser.setSource(this.createDummyModuleInfoCompilationUnit());
        } else {
            parser.setSource(this.sourceArray);
        }
        parser.setKind(FORMAT_TO_PARSER_KIND.get(kind));
        Hashtable<String, String> parserOptions = JavaCore.getOptions();
        parserOptions.put("org.eclipse.jdt.core.compiler.source", this.sourceLevel);
        parserOptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parserOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        parserOptions.put("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "ignore");
        parser.setCompilerOptions(parserOptions);
        return parser;
    }

    private ICompilationUnit createDummyModuleInfoCompilationUnit() {
        final JavaProject dummyProject = new JavaProject(){

            @Override
            public Map<String, String> getOptions(boolean inheritJavaCoreOptions) {
                return new HashMap<String, String>();
            }

            @Override
            public IModuleDescription getModuleDescription() throws JavaModelException {
                return new SourceModule(this, "");
            }
        };
        return new CompilationUnit(null, "module-info.java", null){

            @Override
            public char[] getContents() {
                return DefaultCodeFormatter.this.sourceArray;
            }

            @Override
            public JavaProject getJavaProject() {
                return dummyProject;
            }
        };
    }

    private boolean hasErrors(ASTNode astNode) {
        org.eclipse.jdt.core.dom.CompilationUnit root = (org.eclipse.jdt.core.dom.CompilationUnit)astNode.getRoot();
        IProblem[] iProblemArray = root.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void tokenizeSource(int kind) {
        this.tokens.clear();
        Scanner scanner = new Scanner(true, false, false, CompilerOptions.versionToJdkLevel((String)this.sourceLevel), null, null, false, this.previewEnabled);
        scanner.setSource(this.sourceArray);
        scanner.fakeInModule = (kind & 0x80) != 0;
        while (true) {
            try {
                int tokenType;
                while ((tokenType = scanner.getNextToken()) != 64) {
                    Token token = Token.fromCurrent(scanner, tokenType);
                    this.tokens.add(token);
                }
            }
            catch (InvalidInputException invalidInputException) {
                Token token = Token.fromCurrent(scanner, 0);
                this.tokens.add(token);
                continue;
            }
            break;
        }
    }

    private void prepareSpaces() {
        SpacePreparator spacePreparator = new SpacePreparator(this.tokenManager, this.workingOptions);
        this.astRoot.accept(spacePreparator);
        spacePreparator.finishUp();
    }

    private void prepareLineBreaks() {
        LineBreaksPreparator breaksPreparator = new LineBreaksPreparator(this.tokenManager, this.workingOptions);
        this.astRoot.accept(breaksPreparator);
        breaksPreparator.finishUp();
        this.astRoot.accept(new OneLineEnforcer(this.tokenManager, this.workingOptions));
    }

    private void prepareComments() {
        CommentsPreparator commentsPreparator = new CommentsPreparator(this.tokenManager, this.workingOptions, this.sourceLevel);
        List comments = ((org.eclipse.jdt.core.dom.CompilationUnit)this.astRoot.getRoot()).getCommentList();
        for (Comment comment : comments) {
            comment.accept(commentsPreparator);
        }
        commentsPreparator.finishUp();
    }

    private void prepareWraps(int kind) {
        WrapPreparator wrapPreparator = new WrapPreparator(this.tokenManager, this.workingOptions, kind);
        this.astRoot.accept(wrapPreparator);
        this.applyFormatOff();
        wrapPreparator.finishUp(this.astRoot, this.formatRegions);
    }

    private void applyFormatOff() {
        for (Token[] offPair : this.tokenManager.getDisableFormatTokenPairs()) {
            int offStart = offPair[0].originalStart;
            int offEnd = offPair[1].originalEnd;
            offPair[0].setWrapPolicy(null);
            offPair[0].setIndent(Math.min(offPair[0].getIndent(), this.tokenManager.findSourcePositionInLine(offStart)));
            ArrayList<IRegion> result = new ArrayList<IRegion>();
            for (IRegion region : this.formatRegions) {
                int start = region.getOffset();
                int end = region.getOffset() + region.getLength() - 1;
                if (offEnd < start || end < offStart) {
                    result.add(region);
                    continue;
                }
                if (offStart <= start && end <= offEnd) continue;
                if (start < offStart) {
                    result.add((IRegion)new Region(start, offStart - start));
                }
                if (offEnd >= end) continue;
                result.add((IRegion)new Region(offEnd + 1, end - offEnd));
            }
            this.formatRegions = result;
        }
    }

    private boolean regionsSatisfiesPreconditions(IRegion[] regions, int maxLength) {
        int regionsLength;
        int n = regionsLength = regions == null ? 0 : regions.length;
        if (regionsLength == 0) {
            return false;
        }
        IRegion first = regions[0];
        if (first.getOffset() < 0 || first.getLength() < 0 || first.getOffset() + first.getLength() > maxLength) {
            return false;
        }
        int lastOffset = first.getOffset() + first.getLength() - 1;
        int i = 1;
        while (i < regionsLength) {
            IRegion current = regions[i];
            if (lastOffset > current.getOffset()) {
                return false;
            }
            if (current.getOffset() < 0 || current.getLength() < 0 || current.getOffset() + current.getLength() > maxLength) {
                return false;
            }
            lastOffset = current.getOffset() + current.getLength() - 1;
            ++i;
        }
        return true;
    }

    private void updateWorkingOptions(int indentationLevel, String lineSeparator, int kind) {
        String string = this.workingOptions.line_separator = lineSeparator != null ? lineSeparator : this.originalOptions.line_separator;
        if (this.workingOptions.line_separator == null) {
            this.workingOptions.line_separator = Util.LINE_SEPARATOR;
        }
        this.workingOptions.initial_indentation_level = indentationLevel;
        this.workingOptions.comment_format_javadoc_comment = this.originalOptions.comment_format_javadoc_comment && this.canFormatComment(kind, 64);
        this.workingOptions.comment_format_block_comment = this.originalOptions.comment_format_block_comment && this.canFormatComment(kind, 32);
        this.workingOptions.comment_format_line_comment = this.originalOptions.comment_format_line_comment && this.canFormatComment(kind, 16);
    }

    private boolean canFormatComment(int kind, int commentKind) {
        if ((kind & 0x1000) != 0) {
            return true;
        }
        if ("false".equals(this.oldCommentFormatOption)) {
            return false;
        }
        if ((kind & 0xFF) == commentKind) {
            return true;
        }
        return kind == 0 && "true".equals(this.oldCommentFormatOption);
    }

    @Override
    public void setOptions(Map<String, String> options) {
        this.initOptions(null, options);
    }
}

