/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public String format(LogRecord record) {
        StackTraceElement se;
        StringBuffer sb = new StringBuffer();
        sb.append(record.getLevel().getLocalizedName());
        sb.append(':');
        String s = this.formatMessage(record);
        if (s.indexOf("append") < 0) {
            return "";
        }
        sb.append(s);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((se = this.findCaller()) != null) {
            sb.append(" . . . . . .  . . . . . . . . . . . . . . . . . . . . . . . . ");
            sb.append(se.toString());
        }
        sb.append('\n');
        return sb.toString();
    }

    private StackTraceElement findCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals("java.util.logging.Logger"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals("java.util.logging.Logger")) {
                return frame;
            }
            ++ix;
        }
        return null;
    }
}

