/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TextWriter
extends FilterWriter {
    private boolean autoFlush = false;
    private String lineSeparator;

    public TextWriter(Writer out) {
        this(out, false);
    }

    public TextWriter(Writer out, boolean autoFlush) {
        super(out);
        this.autoFlush = autoFlush;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(this.lineSeparator);
            if (this.autoFlush) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(b);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int i) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(i);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String s) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object obj) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(obj);
            this.println();
        }
    }
}

