/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.httpd;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TimeZone;

public class PageGenerator {
    private static DateFormat dateFormat;
    private static String swBuildDate;
    private static String swName;
    private static String swVersion;
    private static I18NResourceBundle i18n;
    private static final String TIMEZONE = "UTC";
    public static final int HTML32 = 0;
    public static final int HTML40_TRANS = 1;
    private static final String HTML32_ID = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">";
    private static final String HTML40_TRANS_ID = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    private static final String HTTP_CONTENT_TYPE = "Content-Type: ";
    private static final String HTTP_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_BAD = "HTTP/1.1 400 Bad Request";
    private static final String HTTP_CONTENT_HTML = "Content-Type: text/html";

    public static void generateOkHttp(PrintWriter out) {
        out.println(HTTP_OK);
        PageGenerator.genServerHdr(out);
        out.println(HTTP_CONTENT_HTML);
        out.println();
    }

    public static void generateBadHttp(PrintWriter out) {
        out.println(HTTP_BAD);
        PageGenerator.genServerHdr(out);
        out.println(HTTP_CONTENT_HTML);
    }

    public static void generateDocType(PrintWriter out, int version) {
        switch (version) {
            case 0: {
                out.println(HTML32_ID);
                break;
            }
            case 1: {
                out.println(HTML40_TRANS_ID);
            }
        }
    }

    public static void writeHeader(PrintWriter out, String title) {
        out.println("<Head>");
        out.print("<Title>");
        out.print(title);
        out.println("</Title>");
        out.println("</Head>");
    }

    public static void writeBeginDoc(PrintWriter out) {
        out.println("<html>");
    }

    public static void writeEndDoc(PrintWriter out) {
        out.println("</html>");
    }

    public static void startBody(PrintWriter out) {
        out.println("<Body>");
    }

    public static void endBody(PrintWriter out) {
        out.println("</Body>");
    }

    public static void writeFooter(PrintWriter out) {
        out.println(dateFormat.format(new Date()));
        out.println("<Address>");
        out.print(i18n.getString("generator.produced.txt"));
        out.print(swName);
        out.print(" ");
        out.println(swVersion);
        out.print(i18n.getString("generator.built.txt"));
        out.println(swBuildDate);
        out.println("</Address>");
    }

    public static void writeDictionary(PrintWriter out, Dictionary dict, String keyHeader, String valHeader) {
        if (keyHeader == null) {
            keyHeader = "Key";
        }
        if (valHeader == null) {
            valHeader = "Value";
        }
        out.println("<Table Border>");
        StringBuffer buf = new StringBuffer(50);
        buf.append("<tr><th>");
        buf.append(keyHeader);
        buf.append("<th>");
        buf.append(valHeader);
        buf.append("</tr>");
        out.println(buf.toString());
        if (dict == null || dict.size() == 0) {
            buf.setLength(0);
            buf.append("<tr><td colspan=2>");
            buf.append("-EMPTY-");
            buf.append("</tr>");
        } else {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                out.println("<tr>");
                buf.setLength(0);
                buf.append("<td>");
                buf.append(key.toString());
                buf.append("<td>");
                buf.append(dict.get(key).toString());
                out.println(buf.toString());
                out.println("</tr>");
            }
        }
        out.println("</Table>");
    }

    public static void startTable(PrintWriter out, boolean borders) {
        out.print("<Table");
        if (borders) {
            out.print(" Border");
        }
        out.println(">");
    }

    public static void endTable(PrintWriter out) {
        out.println("</Table>");
    }

    public static String getSWBuildDate() {
        return swBuildDate;
    }

    public static String getSWName() {
        return swName;
    }

    public static String getSWVersion() {
        return swVersion;
    }

    public static void setSWBuildDate(String date) {
        swBuildDate = date;
    }

    public static void setSWName(String name) {
        swName = name;
    }

    public static void setSWVersion(String ver) {
        swVersion = ver;
    }

    private static void genServerHdr(PrintWriter out) {
        if (swName != null) {
            out.print("Server: ");
            out.print(swName);
            if (swVersion != null) {
                out.print("/");
                out.print(swVersion);
            }
            if (swBuildDate != null) {
                out.print("  built ");
                out.print(swBuildDate);
            }
        }
        out.println();
        out.print("Date: ");
        out.println(dateFormat.format(new Date()));
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(PageGenerator.class);
        dateFormat = DateFormat.getDateTimeInstance(0, 1);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
    }
}

