/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.entity.jspejbjdbc;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.util.DBSupport;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import jakarta.ejb.RemoveException;
import java.util.Properties;

public class AccountBean
implements EntityBean {
    private EntityContext ectx = null;
    private double balance;

    public Integer ejbCreate(int account, double balance, boolean newTable, Properties p) throws CreateException {
        DBSupport DB = null;
        TestUtil.logTrace((String)"ejbCreate");
        if (p != null) {
            try {
                TestUtil.logMsg((String)"initialize remote logging");
                TestUtil.init((Properties)p);
            }
            catch (RemoteLoggingInitException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new CreateException(e.getMessage());
            }
        }
        try {
            TestUtil.logTrace((String)"initialize DBSupport");
            DB = new DBSupport();
            TestUtil.logTrace((String)"initialize database table");
            DB.initDB(newTable, false);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Unable to initialize DB. Exception: " + e);
        }
        try {
            DB.insert(account, balance);
            this.balance = balance;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("unable to insert new entity");
        }
        return new Integer(account);
    }

    public void ejbPostCreate(int account, double balance, boolean newTable, Properties p) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        DBSupport DB = null;
        try {
            TestUtil.logTrace((String)"initialize DBSupport");
            DB = new DBSupport();
            DB.delete((Integer)this.ectx.getPrimaryKey());
        }
        catch (Exception se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new RemoveException("unable to remove entity from database");
        }
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
        DBSupport DB = null;
        try {
            DB = new DBSupport();
            this.balance = DB.balance((Integer)this.ectx.getPrimaryKey());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to obtain balance");
        }
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
        DBSupport DB = null;
        try {
            DB = new DBSupport();
            DB.updateAccount((Integer)this.ectx.getPrimaryKey(), this.balance);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to update account balance");
        }
    }

    public Integer ejbFindTheBean(Integer key, Properties p) throws FinderException {
        TestUtil.logTrace((String)"ejbFindTheBean");
        DBSupport DB = null;
        try {
            boolean foundKey;
            if (p != null) {
                TestUtil.logMsg((String)"Initialize remote logging");
                TestUtil.init((Properties)p);
            }
            if (foundKey = (DB = new DBSupport()).keyExists(key)) {
                return key;
            }
            throw new FinderException("Key not found: " + key);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new FinderException(e.getMessage());
        }
        catch (Exception se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new FinderException("unable to obtain primary key existance");
        }
    }

    public Integer ejbFindByPrimaryKey(Integer key) throws FinderException {
        TestUtil.logTrace((String)"ejbFindByPrimaryKey");
        DBSupport DB = null;
        try {
            DB = new DBSupport();
            boolean foundKey = DB.keyExists(key);
            if (foundKey) {
                return key;
            }
            throw new FinderException("Key not found: " + key);
        }
        catch (Exception se) {
            TestUtil.printStackTrace((Throwable)se);
            throw new FinderException("unable to obtain primary key existance");
        }
    }

    public double balance() {
        return this.balance;
    }

    public double deposit(double v) {
        this.balance += v;
        return this.balance;
    }

    public double withdraw(double v) {
        this.balance -= v;
        return this.balance;
    }

    public String sayHello() {
        return "Hello There World From AccountBean!!!";
    }
}

