/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.ee;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class TransactionTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(TransactionTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void cleanup() throws EETest.Fault {
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str + ""));
    }

    public void testTranRollbackRetryReadSkipRead() throws EETest.Fault {
        String METHOD = "testTranRollbackRetryReadSkipRead";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 8;
            Integer forcedFailCountProcess = 0;
            Integer forcedFailCountWrite = 0;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_retryskip_rollback.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testTranRollbackRetryProcessSkipProcess() throws EETest.Fault {
        String METHOD = "testTranRollbackRetryProcessSkipProcess";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 0;
            Integer forcedFailCountProcess = 8;
            Integer forcedFailCountWrite = 0;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_retryskip_rollback.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testTranRollbackRetryWriteSkipWrite() throws EETest.Fault {
        String METHOD = "testTranRollbackRetryWriteSkipWrite";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            Integer initNumbers = 10;
            Integer forcedFailCountRead = 0;
            Integer forcedFailCountProcess = 0;
            Integer forcedFailCountWrite = 8;
            Integer dummyDelay = 0;
            Boolean rollback = true;
            Boolean autoCommit = false;
            Properties jobParams = new Properties();
            jobParams.put("jakarta.transaction.global.mode", "true");
            jobParams.put("jakarta.transaction.global.timeout", "20");
            jobParams.put("init.numbers.quantity", initNumbers.toString());
            jobParams.put("forced.fail.count.read", forcedFailCountRead.toString());
            jobParams.put("forced.fail.count.write", forcedFailCountWrite.toString());
            jobParams.put("forced.fail.count.process", forcedFailCountProcess.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("rollback", rollback.toString());
            jobParams.put("auto.commit", autoCommit.toString());
            TestUtil.logMsg((String)"Locate job XML file: job_chunk_retryskip_rollback.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_retryskip_rollback", jobParams);
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranNoExceptions() throws EETest.Fault {
        String METHOD = "testGlobalTranNoExceptions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 0;
            Integer itemCount = 5;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranNoExceptions.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)"jakarta.transaction.global.timeout=300");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            TestUtil.logMsg((String)("expected.inventory=" + expectedInventory.toString()));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + null + " OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranForcedExceptionWithRollback() throws EETest.Fault {
        String METHOD = "testGlobalTranForcedExceptionWithRollback";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 20;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranForcedExceptionWithRollback.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)"jakarta.transaction.global.timeout=300");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            TestUtil.logMsg((String)("expected.inventory=" + expectedInventory.toString()));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + null + " OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranForcedExceptionCheckpointRestart() throws EETest.Fault {
        String METHOD = "testGlobalTranForcedExceptionCheckpointRestart";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 20;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranForcedExceptionCheckpointRestart.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)"jakarta.transaction.global.timeout=300");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            TestUtil.logMsg((String)("expected.inventory=" + expectedInventory.toString()));
            jobParams.put("jakarta.transaction.global.timeout", "300");
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran", jobParams);
            long jobInstanceId = jobExec.getInstanceId();
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.FAILED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + null + " OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            forcedFailCount = 0;
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(expectedInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders2 = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult with id: " + jobInstanceId + ""));
            TCKJobExecutionWrapper restartedJobExec = jobOp.restartJobAndWaitForResult(jobExec.getExecutionId(), jobParams);
            TestUtil.logMsg((String)("restarted job JobExecution getBatchStatus()=" + restartedJobExec.getBatchStatus()));
            TestUtil.logMsg((String)("restarted job JobExecution getExitStatus()=" + restartedJobExec.getExitStatus()));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + expectedCompletedOrders + " OrderCount=" + expectedCompletedOrders2, restartedJobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, restartedJobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranNoDelayLongTimeout() throws EETest.Fault {
        String METHOD = "testGlobalTranNoDelayLongTimeout";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "0";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 0;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranNoDelayLongTimeout.sleep", DEFAULT_SLEEP_TIME));
            Integer expectedInventory = TransactionTests.calculateGlobalTranExpectedInventory(initInventory, forcedFailCount, itemCount);
            Integer expectedCompletedOrders = TransactionTests.calculateExpectedCompleteOrders(initInventory, forcedFailCount, itemCount);
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            TestUtil.logMsg((String)("expected.inventory=" + expectedInventory.toString()));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            jobParams.put("expected.inventory", expectedInventory.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_default", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals("Inventory=" + expectedInventory + " InitialCheckpoint=" + null + " OrderCount=" + expectedCompletedOrders, jobExec.getExitStatus());
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps() throws EETest.Fault {
        String METHOD = "testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "10000";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 15;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutSteps.sleep", DEFAULT_SLEEP_TIME));
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_multiple_steps", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=0 InitialCheckpoint=null OrderCount=" + initInventory, jobExec.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            boolean seen2 = false;
            boolean seen3 = false;
            for (StepExecution s : stepExecutions) {
                if (s.getStepName().equals("step2")) {
                    AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                    seen2 = true;
                    continue;
                }
                if (!s.getStepName().equals("step3")) continue;
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                seen3 = true;
            }
            AssertionUtils.assertWithMessage("Step2 execution seen", true, seen2);
            AssertionUtils.assertWithMessage("Step3 execution seen", true, seen3);
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    public void testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm() throws EETest.Fault {
        String METHOD = "testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "10000";
        try {
            Integer initInventory = 99;
            Integer forcedFailCount = 15;
            Integer itemCount = 9;
            Integer dummyDelay = Integer.parseInt(System.getProperty("TransactionTests.testGlobalTranLongDelayMixOfLongTimeoutStepsAndShortTimeoutStepsCustomCheckpointAlgorithm.sleep", DEFAULT_SLEEP_TIME));
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            TestUtil.logMsg((String)("commit.interval=" + itemCount.toString()));
            TestUtil.logMsg((String)("init.inventory.quantity=" + initInventory.toString()));
            TestUtil.logMsg((String)("forced.fail.count=" + forcedFailCount.toString()));
            TestUtil.logMsg((String)("dummy.delay.seconds=" + dummyDelay.toString()));
            jobParams.put("commit.interval", itemCount.toString());
            jobParams.put("init.inventory.quantity", initInventory.toString());
            jobParams.put("forced.fail.count", forcedFailCount.toString());
            jobParams.put("dummy.delay.seconds", dummyDelay.toString());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_chunk_globaltran_multiple_steps-customCA", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + jobExec.getExitStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            AssertionUtils.assertObjEquals("Inventory=0 InitialCheckpoint=null OrderCount=" + initInventory, jobExec.getExitStatus());
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            boolean seen2 = false;
            boolean seen3 = false;
            for (StepExecution s : stepExecutions) {
                if (s.getStepName().equals("step2")) {
                    AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                    seen2 = true;
                    continue;
                }
                if (!s.getStepName().equals("step3")) continue;
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, s.getBatchStatus());
                seen3 = true;
            }
            AssertionUtils.assertWithMessage("Step2 execution seen", true, seen2);
            AssertionUtils.assertWithMessage("Step3 execution seen", true, seen3);
        }
        catch (Exception e) {
            TransactionTests.handleException(METHOD, e);
        }
    }

    private static int calculateGlobalTranExpectedInventory(int initInventory, int forcedFailCount, int commitInterval) {
        int expectedResult = forcedFailCount <= 0 ? 0 : initInventory - forcedFailCount + forcedFailCount % commitInterval;
        return expectedResult;
    }

    private static int calculateExpectedCompleteOrders(int initInventory, int forcedFailCount, int commitInterval) {
        int expectedResult = forcedFailCount <= 0 ? initInventory : forcedFailCount / commitInterval * commitInterval;
        return expectedResult;
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }
}

