/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import jakarta.batch.api.AbstractBatchlet;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.logging.Logger;

@Named(value="startLimitStateMachineVariation3Batchlet")
public class StartLimitStateMachineVariation3Batchlet
extends AbstractBatchlet {
    private static final String sourceClass = StartLimitStateMachineVariation3Batchlet.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final String JSL_STOP_TRANSITION = "JSL.STOP";
    private static final String JSL_FAIL_TRANSITION = "JSL.FAIL";
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="runNumber")
    String runNumberString;

    public String process() throws Exception {
        logger.fine(sourceClass + ".process()");
        String exitStatus = null;
        exitStatus = this.contributeToExitStatus();
        this.appendToJobContext(exitStatus);
        logger.fine(sourceClass + ".process(); exitStatus = " + exitStatus);
        if (exitStatus.startsWith("s")) {
            logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , return: " + JSL_STOP_TRANSITION);
            return JSL_STOP_TRANSITION;
        }
        if (exitStatus.startsWith("f")) {
            logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , return: " + JSL_FAIL_TRANSITION);
            return JSL_FAIL_TRANSITION;
        }
        logger.fine("For step exitStatus for step: " + this.stepCtx.getStepName() + " , don't return value");
        return null;
    }

    private void appendToJobContext(String exitStatus) {
        String es = this.jobCtx.getExitStatus();
        if (es == null) {
            logger.fine("First addition to Job ExitStatus = " + es);
            this.jobCtx.setExitStatus(exitStatus);
        } else {
            String newExitStatus = es.concat(",").concat(exitStatus);
            logger.fine("Existing Job ExitStatus = " + es + " ; Updating to : " + newExitStatus);
            this.jobCtx.setExitStatus(newExitStatus);
        }
    }

    public void stop() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }

    private String contributeToExitStatus() {
        logger.fine(sourceClass + ".calculateExitStatus(), runNumberString = " + this.runNumberString);
        int execNum = Integer.parseInt(this.runNumberString.substring(new String("runNumber.").length()));
        String stepId = this.stepCtx.getStepName();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        if (stepId.equals("step1")) {
            switch (execNum) {
                case 1: {
                    return "c1";
                }
                case 3: {
                    return "c1";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step2")) {
            switch (execNum) {
                case 1: {
                    return "c2";
                }
                case 3: {
                    return "c2";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step3")) {
            switch (execNum) {
                case 1: {
                    return "c3";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step4")) {
            switch (execNum) {
                case 1: {
                    return "c4";
                }
                case 3: {
                    return "c4";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step5")) {
            switch (execNum) {
                case 1: {
                    return "s5";
                }
                case 2: {
                    return "f5";
                }
                case 3: {
                    return "c5";
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }
}

