/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayBuilders {
    ArrayBuilders() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonArrayBuilder API factory methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonArrayBuilder API factory methods added in JSON-P 1.1.");
        this.testCreateFromCollection(result);
        this.testCreateFromJsonArray(result);
        this.testGetStringValuesAs(result);
        this.testGetIntValuesAs(result);
        return result;
    }

    private void testCreateFromCollection(TestResult result) {
        TestUtil.logMsg((String)" - Json#createArrayBuilder(Collection<Object>)");
        JsonArray check = SimpleValues.createSimpleStringArray5();
        ArrayList<String> values = new ArrayList<String>(check.size());
        for (JsonValue value : check) {
            values.add(((JsonString)value).getString());
        }
        JsonArrayBuilder builder = Json.createArrayBuilder(values);
        JsonArray out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createArrayBuilder(Collection<Object>)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testCreateFromJsonArray(TestResult result) {
        TestUtil.logMsg((String)" - Json#createArrayBuilder(JsonArray)");
        JsonArray check = SimpleValues.createSimpleStringArray5();
        JsonArrayBuilder builder = Json.createArrayBuilder((JsonArray)check);
        JsonArray out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createArrayBuilder(JsonArray)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testGetStringValuesAs(TestResult result) {
        boolean failed;
        TestUtil.logMsg((String)" - getValuesAs(Function<K,T> on String array");
        JsonArray in = SimpleValues.createStringArray2();
        List out = in.getValuesAs(JsonString::getString);
        boolean bl = failed = in.size() != out.size();
        if (!failed) {
            Iterator inIt = in.iterator();
            Iterator outIt = out.iterator();
            while (!failed && inIt.hasNext()) {
                JsonValue inVal = (JsonValue)inIt.next();
                String outVal = (String)outIt.next();
                failed = !((JsonString)inVal).getString().equals(outVal);
            }
        }
        if (failed) {
            result.fail("getValuesAs(Function<K,T>)", "Returned Array " + out.toString() + " content shall match " + JsonAssert.valueToString((JsonValue)in));
        }
    }

    private void testGetIntValuesAs(TestResult result) {
        boolean failed;
        TestUtil.logMsg((String)" - getValuesAs(Function<K,T> on int array");
        JsonArray in = SimpleValues.createIntArray2();
        List out = in.getValuesAs(JsonNumber::intValue);
        boolean bl = failed = in.size() != out.size();
        if (!failed) {
            Iterator inIt = in.iterator();
            Iterator outIt = out.iterator();
            while (!failed && inIt.hasNext()) {
                JsonValue inVal = (JsonValue)inIt.next();
                Integer outVal = (Integer)outIt.next();
                failed = ((JsonNumber)inVal).intValue() != outVal.intValue();
            }
        }
        if (failed) {
            result.fail("getValuesAs(Function<K,T>)", "Returned Array " + out.toString() + " content shall match " + JsonAssert.valueToString((JsonValue)in));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

